package com.elitesland.tw.tw5.server.prd.org.service;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.dto.req.UserCreateDTO;
import com.elitescloud.cloudt.system.provider.org.UserRpcService;
import com.elitesland.tw.tw5.api.prd.org.payload.PrdOrgEmployeePayload;
import com.elitesland.tw.tw5.api.prd.org.payload.PrdOrgEmployeeRefPayload;
import com.elitesland.tw.tw5.api.prd.org.payload.PrdOrgTenantEmployeePayload;
import com.elitesland.tw.tw5.api.prd.org.query.PrdOrgEmployeeQuery;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgEmployeeService;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgCompanyVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeRefVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgOrganizationRefVO;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemSelectionService;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemSelectionVO;
import com.elitesland.tw.tw5.server.common.ExcelUtil;
import com.elitesland.tw.tw5.server.common.QyWx.service.QyWxCommunicationService;
import com.elitesland.tw.tw5.server.common.StringUtil;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.FileUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.AddressBookEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.FunctionSelectionEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.SystemDefaultEnum;
import com.elitesland.tw.tw5.server.prd.org.convert.PrdOrgEmployeeConvert;
import com.elitesland.tw.tw5.server.prd.org.convert.PrdOrgEmployeeRefConvert;
import com.elitesland.tw.tw5.server.prd.org.convert.PrdOrgPersonConvert;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgCompanyDAO;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgEmployeeDAO;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgOrganizationDAO;
import com.elitesland.tw.tw5.server.prd.org.entity.PrdOrgEmployeeDO;
import com.elitesland.tw.tw5.server.prd.org.entity.PrdOrgEmployeeRefDO;
import com.elitesland.tw.tw5.server.prd.org.entity.PrdOrgPersonDO;
import com.elitesland.tw.tw5.server.prd.system.entity.PrdSystemUserRoleDO;
import com.elitesland.tw.tw5crm.api.tenant.payload.TwTenantPayload;
import com.elitesland.tw.tw5crm.api.tenant.service.TwTenantService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.io.InputStream;
import java.time.LocalDate;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 员工管理service
 *
 * @author wangding
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class PrdOrgEmployeeServiceImpl implements PrdOrgEmployeeService {
    private final PrdOrgEmployeeDAO dao;
    private final PrdOrgOrganizationDAO daoOrg;
    private final PrdOrgCompanyDAO daoComppany;
    private final PrdSystemSelectionService service;
    private final AsyncEmployeeServiceImpl serviceAsync;
    private final QyWxCommunicationService qyWxCommunicationService;
    private final ExcelUtil excelUtil;
    private final FileUtil fileUtil;
    private final CacheUtil cacheUtil;
    @Autowired(required = false)
    private TwTenantService twTenantService;
    @Value("${tw5.shortcut.size}")
    private Integer shortcutSize = 5;
    //@Autowired
    // @DubboReference
    //private SysUserRpcService sysUserRpcService;
    @Autowired
    private UserRpcService userRpcService;
    @Value("${tw5.user_default.password}")
    private String default_password = "111111";
    @Value("${tw5.user_default.role_id}")
    private Long default_role_id;
    @Value("${tw5.sys_default.dimensionId}")
    private Long default_dimension_id;

    //TODO 测试通过租户新增来新增用户
    @Transactional
    @Override
    public PrdOrgEmployeeVO saveTenantUser(PrdOrgTenantEmployeePayload payload) {
        final Long tenantId = Long.valueOf(payload.getTenantId());

        String shortcutIds = getDefultShortcut();
        String aa = System.currentTimeMillis() + ((int) (Math.random() * 10)) + "";
        String substring = aa.substring(aa.length() - 7);

        PrdOrgPersonDO pDO = new PrdOrgPersonDO();
        pDO.setUserName(payload.getAdminAccount());
        pDO.setPersonName(payload.getAdminAccount());
        pDO.setEnabled(true);
        pDO.setTenantId(tenantId);
        dao.savePerson(pDO);

        PrdOrgEmployeeDO ado = new PrdOrgEmployeeDO();
        ado.setEmployeeNo(substring);
        ado.setHrStatus(SystemDefaultEnum.DefaultHrStatus.getCode());
        ado.setEmployeeName(payload.getAdminAccount());
        ado.setPersonId(pDO.getId());
        ado.setUserId(payload.getAdminUserId());
        ado.setShortcutIds(shortcutIds);
        ado.setTenantId(tenantId);
        ado.setCompanyId(1001L);
//        ado.setWecomId("wangding");
        ado = dao.save(ado);
        List<PrdSystemUserRoleDO> userRoleDOS = new ArrayList<>();
        PrdSystemUserRoleDO roleDO = new PrdSystemUserRoleDO();
        roleDO.setRoleId(default_role_id);
        roleDO.setUserId(ado.getUserId());
        userRoleDOS.add(roleDO);
        dao.saveUserRoleAll(userRoleDOS);

        // 插入租户管理表 tw自己维护租户信息
        TwTenantPayload twTenant = new TwTenantPayload();
        BeanUtils.copyProperties(payload,twTenant);
        twTenant.setSysTenantId(tenantId);
        twTenantService.insert(twTenant);

        return PrdOrgEmployeeConvert.INSTANCE.toVo(ado);
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public PrdOrgEmployeeVO insert(PrdOrgEmployeePayload payload) {
        String shortcutIds = getDefultShortcut();
        PrdOrgEmployeeDO ado = insertEmployee(payload, shortcutIds);
        checkEmployeeRef(payload.getOrgId(), payload.getParentId(), ado.getUserId());
        PrdOrgEmployeeRefDO refDo = new PrdOrgEmployeeRefDO();
        refDo.setJoinDate(LocalDate.now());
        refDo.setOrgId(payload.getOrgId());
        refDo.setUserId(ado.getUserId());
        refDo.setParentId(payload.getParentId());
        refDo.setIsDefault(0);
        dao.saveRef(refDo);
        return PrdOrgEmployeeConvert.INSTANCE.toVo(ado);
    }


    @Transactional(rollbackFor = Exception.class)
    @Override
    public PrdOrgEmployeeVO insertByTenant(PrdOrgEmployeePayload payload) {
        //String shortcutIds = getDefultShortcut();
        //PrdOrgEmployeeDO ado = insertEmployee(payload, shortcutIds);
        if (dao.queryByCode(payload.getEmployeeNo()) == null) {
            // 手机号 不能重复
            if (StringUtils.hasText(payload.getMobile())) {
                //设置最终名称为员工名称
                payload.setLastName(payload.getEmployeeName());
                //获取企业微信账号
                String wecom = qyWxCommunicationService.getQyWxuserid(payload.getMobile());
                UserCreateDTO param = new UserCreateDTO();
                param.setUsername(payload.getUserName());
                param.setPassword(default_password);
                //param.setLastName(payload.getLastName());
                param.setFullName(payload.getEmployeeName());
                param.setMobile(payload.getMobile());
                param.setEmail(payload.getEmail());
                param.setEnabled(payload.getEnabled());
                //param.setRoleIds(new ArrayList<>());
                //param.setDataRoleIds(new ArrayList<>());
                //param.setFlowRoleIds(new ArrayList<>());
                param.setSourceType("sys");
                //param.setTerminals(new HashSet<>());
                ApiResult<Long> obj = userRpcService.upsert(param);

                if (obj == null || obj.getCode() != 200) {
                    throw TwException.error(obj.getCode()+"", obj.getMsg());
                }

                PrdOrgPersonDO pDO = PrdOrgPersonConvert.INSTANCE.toDo(payload);
                pDO = dao.savePerson(pDO);
                // 租户初始化数据
                if (null != payload.getInitTenantId()) {
                    pDO.setTenantId(payload.getInitTenantId());
                }
                PrdOrgEmployeeDO ado = PrdOrgEmployeeConvert.INSTANCE.toDo(payload);
                ado.setWecomId(wecom);
                ado.setPersonId(pDO.getId());
                ado.setUserId(Long.valueOf(obj.getData() + ""));
                //ado.setShortcutIds(shortcutIds);
                // 租户初始化数据
                if (null != payload.getInitTenantId()) {
                    ado.setTenantId(payload.getInitTenantId());
                }
                ado = dao.save(ado);
                //保存用户角色
                List<PrdSystemUserRoleDO> userRoleDOS = new ArrayList<>();
                if (payload.getRoleIds() != null && payload.getRoleIds().size() > 0) {
                    for (Long roleId : payload.getRoleIds()) {
                        PrdSystemUserRoleDO roleDO = new PrdSystemUserRoleDO();
                        roleDO.setRoleId(roleId);
                        roleDO.setUserId(ado.getUserId());
                        // 租户初始化数据
                        if (null != payload.getInitTenantId()) {
                            roleDO.setTenantId(payload.getInitTenantId());
                        }
                        userRoleDOS.add(roleDO);
                    }
                } else {
                    PrdSystemUserRoleDO roleDO = new PrdSystemUserRoleDO();
                    roleDO.setRoleId(default_role_id);
                    roleDO.setUserId(ado.getUserId());
                    // 租户初始化数据
                    if (null != payload.getInitTenantId()) {
                        roleDO.setTenantId(payload.getInitTenantId());
                    }
                    userRoleDOS.add(roleDO);
                }
                dao.saveUserRoleAll(userRoleDOS);


                //checkEmployeeRef(payload.getOrgId(), payload.getParentId(), ado.getUserId());
                PrdOrgEmployeeRefDO refDo = new PrdOrgEmployeeRefDO();
                refDo.setJoinDate(LocalDate.now());
                refDo.setOrgId(payload.getOrgId());
                refDo.setUserId(ado.getUserId());
                refDo.setParentId(payload.getParentId());
                refDo.setIsDefault(0);
                // 租户初始化数据
                if (null != payload.getInitTenantId()) {
                    refDo.setTenantId(payload.getInitTenantId());
                }
                dao.saveRef(refDo);

                return PrdOrgEmployeeConvert.INSTANCE.toVo(ado);
            } else {
                throw TwException.error("", "电话不可为空");
            }

        } else {
            throw TwException.error("", "编号不可重复");
        }

    }


    @Transactional
    @Override
    public Long update(PrdOrgEmployeePayload payload) {
        PrdOrgEmployeeVO eDo = dao.queryByKey(payload.getId());
        String subType = payload.getSubType();
        if (subType.equals("system") || subType.equals("person")) {
            if (subType.equals("system")) {
                //SysUserUpdateParam param = new SysUserUpdateParam();
                UserCreateDTO param = new UserCreateDTO();
                param.setEmail(payload.getEmail());
                param.setEnabled(payload.getEnabled());
                param.setId(eDo.getUserId());
                //param.setLastName(payload.getLastName());
                //param.setFirstName(payload.getEmployeeName());
                param.setFullName(payload.getEmployeeName());
                param.setMobile(payload.getMobile());
                param.setUsername(payload.getUserName());
                //sysUserRpcService.update(param);
                userRpcService.upsert(param);
                if (!eDo.getEmployeeName().equals(payload.getEmployeeName())) {
                    dao.update(payload);
                }
                if (payload.getRoleIds() != null) {
                    if (payload.getRoleIds().size() == 0) {
                        dao.deleteRolesByUserId(eDo.getUserId());
                    } else {
                        List<PrdSystemUserRoleDO> userRoleDOS = new ArrayList<>();
                        for (Long roleId : payload.getRoleIds()) {
                            PrdSystemUserRoleDO roleDO = new PrdSystemUserRoleDO();
                            roleDO.setRoleId(roleId);
                            roleDO.setUserId(eDo.getUserId());
                            userRoleDOS.add(roleDO);
                        }
                        dao.deleteRolesByUserId(eDo.getUserId());
                        dao.saveUserRoleAll(userRoleDOS);
                    }
                }
            }
            payload.setPersonId(eDo.getPersonId());
            dao.updatePerson(payload);
        }
        if (subType.equals("company")) {
            PrdOrgEmployeeDO employeeDO = dao.queryByCode(payload.getEmployeeNo());
            if (employeeDO != null && employeeDO.getId().longValue() != payload.getId().longValue()) {
                throw TwException.error("", "编号不可重复");
            }
            dao.update(payload);
        }
        //throw TwException.error("", "测试分布式事务是否开启");
        return 0L;
    }

    @Transactional
    @Override
    public Long updateEmployeeRef(List<PrdOrgEmployeeRefPayload> payloads) {

        List<PrdOrgEmployeeRefDO> refDOS = new ArrayList<>();
        int defaultNum = 0;
        Map<Long, Long> map = new HashMap<>();
        //    Map<Long, Long> map = new HashMap<>();
        for (PrdOrgEmployeeRefPayload payload : payloads) {
            Long userId = map.get(payload.getOrgId());
            if (userId != null) {
                throw TwException.error("", "员工组织信息重复");
            }
            map.put(payload.getOrgId(), payload.getUserId());
            Long parentId = payload.getParentId();
            if (!ObjectUtils.isEmpty(parentId) && parentId.longValue() != 0) {
                if (parentId.longValue() == payload.getUserId().longValue()) {
                    throw TwException.error("", "上下级关系存在不合理操作");
                }
                //    map.put(payload.getEmployeeId(), parentId);
            }
            if (payload.getIsDefault() == 0) {
                defaultNum++;
            }
            // checkEmployeeRef(payload.getOrgId(), payload.getParentId(), payload.getEmployeeId());
            PrdOrgEmployeeRefDO ado = PrdOrgEmployeeRefConvert.INSTANCE.toDo(payload);
            if (payload.getId() == null || payload.getId().longValue() == 0) {
                ado.setJoinDate(LocalDate.now());
            }
            refDOS.add(ado);
        }
        if (defaultNum != 1) {
            throw TwException.error("", "员工默认组织提交异常");
        }
        dao.saveAllRef(refDOS);
        return 0L;
    }

    @Override
    public List<PrdOrgEmployeeVO> queryList(PrdOrgEmployeeQuery query) {
        return dao.queryList(query);
    }

    @Override
    public PrdOrgEmployeeVO queryByKey(Long key) {
        PrdOrgEmployeeVO vo = dao.queryByKey(key);
//        PrdOrgPersonDO pDo = dao.queryPersonById(eDo.getPersonId());
//        PrdOrgEmployeeVO vo = new PrdOrgEmployeeVO();
//        BeanUtils.copyProperties(pDo, vo);
//        BeanUtils.copyProperties(eDo, vo);
        vo.setRoleDatas(dao.queryUserRoles(vo.getUserId()));
        // 组织关系
        vo.setDataRefVOS(dao.queryOrgListByKey(vo.getUserId()));
        vo.setIdValidDatas(fileUtil.getFileDatas(vo.getIdValidCodes()));
        vo.setHeadDatas(fileUtil.getFileDatas(vo.getHeadCodes()));
        vo.setResourceName(cacheUtil.transferSystemSelection(FunctionSelectionEnum.EmployeeResource.getCode(), vo.getResourceStatus()));
        vo.setHrName(cacheUtil.transferSystemSelection(FunctionSelectionEnum.EmployeeHr.getCode(), vo.getHrStatus()));

        return vo;
    }

    @Override
    public Set<Long> queryParentIdsByUserId(Long userId) {
        List<PrdOrgEmployeeRefVO> prdOrgEmployeeRefVOS = dao.queryDefaultOrgEmployeeRef(default_dimension_id);
        Set<Long> parentIds = new HashSet<>();
        getParentIds(userId, prdOrgEmployeeRefVOS, parentIds);
        return parentIds;
    }

    /**
     * 查询下级 （直属下级）
     *
     * @param userId 用户id
     * @return {@link Set}<{@link Long}>
     */
    @Override
    public Set<Long> queryOneSubordinatesIdsByUserId(Long userId) {
        List<PrdOrgEmployeeRefVO> prdOrgEmployeeRefVOS = dao.queryDefaultOrgEmployeeRef(default_dimension_id);
        Set<Long> subordinatesIds = new HashSet<>();
        getOneSubordinatesIds(userId, prdOrgEmployeeRefVOS, subordinatesIds);
        return subordinatesIds;
    }

    /**
     * 查询下级id集合（下级 下级的下级  下级的下级的下级....）
     *
     * @param userId 用户id
     * @return {@link Set}<{@link Long}>
     */
    @Override
    public Set<Long> querySubordinatesIdsByUserId(Long userId) {
        List<PrdOrgEmployeeRefVO> prdOrgEmployeeRefVOS = dao.queryDefaultOrgEmployeeRef(default_dimension_id);
        Set<Long> subordinatesIds = new HashSet<>();
        getSubordinatesIds(userId, prdOrgEmployeeRefVOS, subordinatesIds);
        return subordinatesIds;
    }

    /**
     * 查找上级 （直属上级）
     *
     * @param userId 用户id
     * @return {@link Set}<{@link Long}>
     */
    @Override
    public Set<Long> queryOneParentIdsByUserId(Long userId) {
        List<PrdOrgEmployeeRefVO> prdOrgEmployeeRefVOS = dao.queryDefaultOrgEmployeeRef(default_dimension_id);
        Set<Long> parentIds = new HashSet<>();
        getOneParentIds(userId, prdOrgEmployeeRefVOS, parentIds);
        return parentIds;
    }


    /**
     * 填充上级id（上级 上级的上级  上级的上级的上级）
     *
     * @param userId
     * @param prdOrgEmployeeRefVOS
     * @param parentIds
     */
    void getParentIds(Long userId, List<PrdOrgEmployeeRefVO> prdOrgEmployeeRefVOS, Set<Long> parentIds) {
        Optional<PrdOrgEmployeeRefVO> first = prdOrgEmployeeRefVOS.stream().filter(refVO -> refVO.getUserId().equals(userId)).findFirst();
        if (first.isPresent()) {
            PrdOrgEmployeeRefVO refVO = first.get();
            if (refVO.getParentId() != null && !refVO.getParentId().equals(0) && !refVO.getParentId().equals(refVO.getUserId())) {
                parentIds.add(refVO.getParentId());
                getParentIds(refVO.getParentId(), prdOrgEmployeeRefVOS, parentIds);
            }
        }
    }

    /**
     * 查找上级 （直属上级）
     *
     * @param userId               用户id
     * @param prdOrgEmployeeRefVOS prd组织员工ref vos
     * @param parentIds            父id
     */
    void getOneParentIds(Long userId, List<PrdOrgEmployeeRefVO> prdOrgEmployeeRefVOS, Set<Long> parentIds) {
        Optional<PrdOrgEmployeeRefVO> first = prdOrgEmployeeRefVOS.stream().filter(refVO -> refVO.getUserId().equals(userId)).findFirst();
        if (first.isPresent()) {
            PrdOrgEmployeeRefVO refVO = first.get();
            if (refVO.getParentId() != null && !refVO.getParentId().equals(0) && !refVO.getParentId().equals(refVO.getUserId())) {
                parentIds.add(refVO.getParentId());
            }
        }
    }

    /**
     * 查询下级 （直属下级）
     *
     * @param userId               用户id
     * @param prdOrgEmployeeRefVOS prd组织员工ref vos
     * @param subordinatesIds      下属id集合
     */
    void getOneSubordinatesIds(Long userId, List<PrdOrgEmployeeRefVO> prdOrgEmployeeRefVOS, Set<Long> subordinatesIds) {
        final Set<Long> collect = prdOrgEmployeeRefVOS.stream()
            .filter(refVO -> refVO.getParentId() != null && refVO.getParentId().equals(userId))
            .map(PrdOrgEmployeeRefVO::getUserId)
            .collect(Collectors.toSet());
        subordinatesIds.addAll(collect);
    }

    /**
     * 查询下级id集合（下级 下级的下级  下级的下级的下级....）
     *
     * @param userId               用户id
     * @param prdOrgEmployeeRefVOS prd组织员工ref vos
     * @param subordinatesIds      下属id
     */
    void getSubordinatesIds(Long userId, List<PrdOrgEmployeeRefVO> prdOrgEmployeeRefVOS, Set<Long> subordinatesIds) {
        getOneSubordinatesIds(userId, prdOrgEmployeeRefVOS, subordinatesIds);
        if (!CollectionUtils.isEmpty(subordinatesIds)) {
            Set<Long> tempList = subordinatesIds;
            for (Long childId : tempList) {
                getOneSubordinatesIds(childId, prdOrgEmployeeRefVOS, subordinatesIds);
            }
        }
    }

    @Override
    public PagingVO<PrdOrgEmployeeVO> paging(PrdOrgEmployeeQuery query) {
        PagingVO<PrdOrgEmployeeVO> evo = dao.queryPaging(query);
        List<PrdOrgEmployeeVO> vos = evo.getRecords();
        for (PrdOrgEmployeeVO vo : vos) {
            vo.setResourceName(cacheUtil.transferSystemSelection(FunctionSelectionEnum.EmployeeResource.getCode(), vo.getResourceStatus()));
            vo.setHrName(cacheUtil.transferSystemSelection(FunctionSelectionEnum.EmployeeHr.getCode(), vo.getHrStatus()));
            // vo.setCompanyName(cacheUtil.transferSystemSelection(FunctionSelectionEnum.EmployeeCompany.getCode(), vo.getCompanyId() + ""));
            vo.setSexName(cacheUtil.transferSystemSelection(FunctionSelectionEnum.EmployeeSex.getCode(), vo.getSex()));

            vo.setIdTypeName(cacheUtil.transferSystemSelection(FunctionSelectionEnum.EmployeeIdType.getCode(), vo.getIdType()));
            vo.setJobsName(cacheUtil.transferSystemSelection(FunctionSelectionEnum.EmployeeJobs.getCode(), vo.getJobs()));
        }
//        List<Long> userIds = vos.stream().map(PrdOrgEmployeeVO::getUserId).collect(Collectors.toList());
        return evo;
    }

    @Transactional
    @Override
    public boolean deleteSoft(List<Long> keys) {
        List<Long> userIds = new ArrayList<>();
        List<Long> personIds = new ArrayList<>();
        List<PrdOrgEmployeeVO> employeeVOS = dao.queryEmployeeList(keys);
        for (PrdOrgEmployeeVO eDo : employeeVOS) {
            userIds.add(eDo.getUserId());
            personIds.add(eDo.getPersonId());
        }
        dao.deleteRefSoft(userIds);
        dao.deleteSoft(keys);
        dao.deletePersonSoft(personIds);
        //sysUserRpcService.deleteBatch(userIds);
        for (PrdOrgEmployeeVO eDo : employeeVOS) {
            userRpcService.delete(eDo.getUserId());
        }


        return true;
    }

    //@GlobalTransactional
    @Override
    public boolean resetEmployeePawword(Long userId) {
        //sysUserRpcService.changePasswordNoSec(userId, default_password);
        userRpcService.updatePwd(userId,default_password);
        return true;
    }

    @Override
    public void downloadPlus(HttpServletResponse response, PrdOrgEmployeeQuery query) {
        ClassPathResource classPathResource = new ClassPathResource("template/employeeBatch.xlsx");

        List<PrdOrgEmployeeVO> list = new ArrayList<>();
        if (StringUtils.hasText(query.getDownloadType()) && query.getDownloadType().equals("data")) {
            PagingVO<PrdOrgEmployeeVO> evo = paging(query);
            list = evo.getRecords();
        }
        try {
            InputStream inputStream = classPathResource.getInputStream();
            Workbook workbook = WorkbookFactory.create(inputStream);
            XSSFSheet batchProjectSheet = (XSSFSheet) workbook.getSheet("员工数据");

            excelUtil.generateRangeList(batchProjectSheet, 3, 1, "LOV", 2, "A"); // 最终客户 数据验证
            excelUtil.generateRangeList(batchProjectSheet, 8, 1, "LOV", 2, "C"); // 销售大类 数据验证
            excelUtil.generateRangeList(batchProjectSheet, 11, 1, "公司数据", 2, "A"); // 来源属性 数据验证
            excelUtil.generateRangeList(batchProjectSheet, 13, 1, "组织数据", 2, "A"); // 来源属性 数据验证
            excelUtil.generateRangeList(batchProjectSheet, 17, 1, "岗位数据", 2, "A"); // 来源属性 数据验证
            if (batchProjectSheet != null) {
                if (list.size() > 0) {
                    int nextRow = 1;
                    for (PrdOrgEmployeeVO dataPayload : list) {
                        Row row = batchProjectSheet.createRow(nextRow);
                        excelUtil.setCellValue(row, 0, nextRow); // 序号
                        excelUtil.setCellValue(row, 1, dataPayload.getUserName());// 账号
                        excelUtil.setCellValue(row, 2, dataPayload.getPersonName());// 姓名
                        excelUtil.setCellValue(row, 3, dataPayload.getSexName());// 性别
                        excelUtil.setCellFormulas(row, 4, "VLOOKUP(D" + ExcelUtil.formulasReplace + ",LOV!A:B,2,FALSE)");//性别编号
                        excelUtil.setCellValue(row, 5, dataPayload.getEmail());// 邮件
                        excelUtil.setCellValue(row, 6, dataPayload.getMobile());// 电话
                        excelUtil.setCellValue(row, 7, dataPayload.getEmployeeNo());// 员工编号
                        excelUtil.setCellValue(row, 8, dataPayload.getIdTypeName());//证件类型
                        excelUtil.setCellFormulas(row, 9, "VLOOKUP(I" + ExcelUtil.formulasReplace + ",LOV!C:D,2,FALSE)");//证件编号
                        excelUtil.setCellValue(row, 10, dataPayload.getIdNo());// 证件号
                        excelUtil.setCellValue(row, 11, dataPayload.getCompanyName());// 公司名称
                        excelUtil.setCellFormulas(row, 12, "VLOOKUP(L" + ExcelUtil.formulasReplace + ",公司数据!A:B,2,FALSE)");//证件编号
                        excelUtil.setCellValue(row, 13, dataPayload.getOrgName());//组织
                        excelUtil.setCellFormulas(row, 14, "VLOOKUP(N" + ExcelUtil.formulasReplace + ",组织数据!A:B,2,FALSE)");//证件编号
                        excelUtil.setCellValue(row, 15, dataPayload.getParentName());//上级名称
                        excelUtil.setCellValue(row, 16, dataPayload.getParentNo());//上级编号
                        excelUtil.setCellValue(row, 17, dataPayload.getJobsName());//上级编号
                        excelUtil.setCellFormulas(row, 18, "VLOOKUP(R" + ExcelUtil.formulasReplace + ",岗位数据!A:B,2,FALSE)");//证件编号
                        nextRow++;
                    }
                } else {
                    excelUtil.setColumnFormulas(batchProjectSheet, 4, "VLOOKUP(D" + ExcelUtil.formulasReplace + ",LOV!A:B,2,FALSE)");//性别编号
                    excelUtil.setColumnFormulas(batchProjectSheet, 9, "VLOOKUP(I" + ExcelUtil.formulasReplace + ",LOV!C:D,2,FALSE)");//证件编号
                    excelUtil.setColumnFormulas(batchProjectSheet, 12, "VLOOKUP(L" + ExcelUtil.formulasReplace + ",公司数据!A:B,2,FALSE)");//证件编号
                    excelUtil.setColumnFormulas(batchProjectSheet, 14, "VLOOKUP(N" + ExcelUtil.formulasReplace + ",组织数据!A:B,2,FALSE)");//证件编号
                    excelUtil.setColumnFormulas(batchProjectSheet, 18, "VLOOKUP(R" + ExcelUtil.formulasReplace + ",岗位数据!A:B,2,FALSE)");//证件编号
                }
            }
            // 组织数据
            List<PrdOrgOrganizationRefVO> orgList = daoOrg.queryAll(null, null, null);
            Sheet orgSheet = workbook.getSheet("组织数据");
            if (!CollectionUtils.isEmpty(orgList) && orgSheet != null) {
//                防止数据为空时断行
                int nextRow = 1;
                for (PrdOrgOrganizationRefVO org : orgList) {
                    Long addrNo = org.getOrgId();
                    String addrName = org.getOrgName();
                    if (addrNo != null && StringUtils.hasText(addrName)) {
                        Row row = orgSheet.createRow(nextRow);
                        excelUtil.setCellValue(row, 0, addrName);
                        excelUtil.setCellValue(row, 1, addrNo);
                        nextRow++;
                    }
                }
            }

            List<PrdSystemSelectionVO> jobList = service.selectByCondition(FunctionSelectionEnum.EmployeeJobs.getCode());
            Sheet jobSheet = workbook.getSheet("岗位数据");
            if (!CollectionUtils.isEmpty(jobList) && jobSheet != null) {
                int nextRow = 1;
                for (PrdSystemSelectionVO job : jobList) {
                    String selectionValue = job.getSelectionValue();
                    String selectionName = job.getSelectionName();
                    if (StringUtils.hasText(selectionName) && StringUtils.hasText(selectionValue)) {
                        Row row = jobSheet.createRow(nextRow);
                        excelUtil.setCellValue(row, 0, selectionName);
                        excelUtil.setCellValue(row, 1, selectionValue);
                        nextRow++;
                    }
                }
            }
            List<PrdOrgCompanyVO> companyList = daoComppany.queryList(AddressBookEnum.RelateIntercompany.getCode());
            Sheet companySheet = workbook.getSheet("公司数据");
            if (!CollectionUtils.isEmpty(companyList) && companySheet != null) {
                int nextRow = 1;
                for (PrdOrgCompanyVO company : companyList) {
                    Long selectionValue = company.getId();
                    String selectionName = company.getCompanyName();
                    if (StringUtils.hasText(selectionName) && selectionValue != null) {
                        Row row = companySheet.createRow(nextRow);
                        excelUtil.setCellValue(row, 0, selectionName);
                        excelUtil.setCellValue(row, 1, selectionValue + "");
                        nextRow++;
                    }
                }
            }
            String fileName = "员工批量数据-" + LocalDate.now();
            ExcelUtil.writeResponse(response, fileName, workbook);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Transactional
    @Override
    public boolean importEmployees(MultipartFile file) {

        if (file == null) {
            throw TwException.error("", "上传文件异常");
        }
        Workbook workbook = null;
        try {
            workbook = WorkbookFactory.create(file.getInputStream());
        } catch (Exception e) {
            e.printStackTrace();
            log.error(e.getMessage());
            throw TwException.error("", "文件解析异常");
        }
        Sheet sheet = workbook.getSheet("员工数据");
        if (sheet == null) {
            throw TwException.error("", "表结构错误");
        }
        int dataStartRow = 1;
        List<PrdOrgEmployeePayload> employeePayloads = new ArrayList<>();
        List<String> employeeCodes = new ArrayList<>();
        List<String> emails = new ArrayList<>();
        List<String> mobiles = new ArrayList<>();
        List<String> parentNos = new ArrayList<>();
        for (int i = dataStartRow; i <= sheet.getLastRowNum(); i++) {
            Row row = sheet.getRow(i);
            PrdOrgEmployeePayload employeePayload = new PrdOrgEmployeePayload();
            String email = ExcelUtil.getCellFormatValue(row.getCell(5));
            if (StringUtils.hasText(email)) {
                if (emails.contains(email)) {
                    throw TwException.error("", "邮箱不可重复");
                } else {
                    emails.add(email);
                }
            } else {
                throw TwException.error("", "邮箱不可为空");
            }
            employeePayload.setUserName(email);
            employeePayload.setEmail(email);
            String mobile = ExcelUtil.getCellFormatValue(row.getCell(6));
            if (StringUtils.hasText(mobile)) {
                if (mobiles.contains(mobile)) {
                    throw TwException.error("", "电话不可重复");
                } else {
                    mobiles.add(mobile);
                }
            } else {
                throw TwException.error("", "电话不可为空");
            }
            employeePayload.setMobile(mobile);
            employeePayload.setEmployeeName(ExcelUtil.getCellFormatValue(row.getCell(2)));
            employeePayload.setPersonName(employeePayload.getEmployeeName());
            //   employeePayload.setEmployeeName(ExcelUtil.getCellFormatValue(row.getCell(2)));
            employeePayload.setSex(ExcelUtil.getCellFormatValue(row.getCell(4)));
            String code = ExcelUtil.getCellFormatValue(row.getCell(7));
            if (StringUtils.hasText(code)) {
                if (employeeCodes.contains(code)) {
                    throw TwException.error("", "编号不可重复");
                } else {
                    employeeCodes.add(code);
                }
            } else {
                throw TwException.error("", "员工编号不可为空");
            }
            employeePayload.setEmployeeNo(code);
            employeePayload.setIdType(ExcelUtil.getCellFormatValue(row.getCell(9)));
            employeePayload.setIdNo(ExcelUtil.getCellFormatValue(row.getCell(10)));
            String companyId = ExcelUtil.getCellFormatValue(row.getCell(12));
            if (StringUtil.isInteger(companyId)) {
                employeePayload.setCompanyId(Long.valueOf(companyId));
            }
            String orgId = ExcelUtil.getCellFormatValue(row.getCell(14));
            if (StringUtil.isInteger(orgId)) {
                employeePayload.setOrgId(Long.valueOf(orgId));
            }
            String parentNo = ExcelUtil.getCellFormatValue(row.getCell(16));
            if (StringUtils.hasText(parentNo)) {
//                if (code.equals(parentNo)) {
//                    throw TwException.error("", "上下级关系存在不合理操作");
//                }
                parentNos.add(parentNo);
                employeePayload.setParentNo(parentNo);
            }
            employeePayload.setJobs(ExcelUtil.getCellFormatValue(row.getCell(18)));
            employeePayloads.add(employeePayload);
        }
        //父级编号对应的父级id
        Map<String, Long> parentMap = new HashMap<>();
        //自己的id对应的父级编号
        Map<Long, String> employeeMap = new HashMap<>();

        String shortcutIds = getDefultShortcut();
        List<PrdOrgEmployeeRefDO> refDOs = new ArrayList<>();
        for (PrdOrgEmployeePayload employeePayload : employeePayloads) {
            PrdOrgEmployeeDO edo = insertEmployee(employeePayload, shortcutIds);
            //先看父级编号里是否包含了这个员工的编号
            if (parentNos.contains(edo.getEmployeeNo())) {
                parentMap.put(edo.getEmployeeNo(), edo.getUserId());
                parentNos.remove(edo.getEmployeeNo());
            }
            PrdOrgEmployeeRefDO refDo = new PrdOrgEmployeeRefDO();
            refDo.setJoinDate(LocalDate.now());
            refDo.setOrgId(employeePayload.getOrgId());
            refDo.setUserId(edo.getUserId());
            // refDo.setParentId(payload.getParentId());
            refDo.setIsDefault(0);
            refDOs.add(refDo);
            employeeMap.put(edo.getUserId(), employeePayload.getParentNo());
        }
        List<PrdOrgEmployeeDO> employeeList = dao.queryListByCode(parentNos);
        employeeList.forEach(employeeDO -> parentMap.put(employeeDO.getEmployeeNo(), employeeDO.getUserId()));

        refDOs.forEach(refDo -> refDo.setParentId(parentMap.get(employeeMap.get(refDo.getUserId()))));
        dao.saveAllRef(refDOs);
        return true;
    }

    @Transactional
    @Override
    public boolean deleteOrgRefSoft(Long userId, List<Long> orgIds) {
        long num = dao.deleteEmployeeRefSoft(userId, orgIds);
        if (num > orgIds.size()) {
            throw TwException.error("", "员工默认组织不可被移除");
        }
        return true;
    }

    @Transactional(propagation = Propagation.REQUIRED)
    @Override
    public boolean updateWecomId(List<Long> userIds) {
        List<PrdOrgEmployeeVO> employeeVOS = dao.queryMobileList(userIds);
        for (PrdOrgEmployeeVO employeeVO : employeeVOS) {
            serviceAsync.queryWecomId(employeeVO);
        }
        return true;
    }


    @Override
    public Map<Long, Long> getV4AndV5UserIds() {
        Map<Long, Long> userMap = new HashMap<>();
        //查询用户列表
        List<Map<String, Object>> v4AndV5UserIds = dao.getV4AndV5UserIds();
        for (Map<String, Object> v4AndV5UserId : v4AndV5UserIds) {
            Long userId = (Long) v4AndV5UserId.get("userId");
            Long userIdV4 = (Long) v4AndV5UserId.get("userIdV4");
            if (userId != null && userIdV4 != null) {
                userMap.put(userIdV4, userId);
            }
        }
        return userMap;
    }

    @Override
    public PrdOrgEmployeeRefVO queryEmployeeRef(Long userId){
        return dao.queryEmployeeRef(userId);
    }


//    @Override
//    public boolean updateAllWecomId() {
//        List<PrdOrgEmployeeVO> employeeVOS = dao.queryMobileList(null);
//        employeeVOS.forEach(employeeVO -> serviceAsync.queryWecomId(employeeVO));
//        return true;
//    }

    private PrdOrgEmployeeDO insertEmployee(PrdOrgEmployeePayload payload, String shortcutIds) {
        if (dao.queryByCode(payload.getEmployeeNo()) == null) {
            if (StringUtils.hasText(payload.getMobile())) {
                //设置最终名称为员工名称
                payload.setLastName(payload.getEmployeeName());
                //获取企业微信账号
                String wecom = qyWxCommunicationService.getQyWxuserid(payload.getMobile());
                UserCreateDTO param = new UserCreateDTO();
                param.setUsername(payload.getUserName());
                param.setPassword(default_password);
                //param.setLastName(payload.getLastName());
                param.setFullName(payload.getEmployeeName());
                param.setMobile(payload.getMobile());
                param.setEmail(payload.getEmail());
                param.setEnabled(payload.getEnabled());
                //param.setRoleIds(new ArrayList<>());
                //param.setDataRoleIds(new ArrayList<>());
                //param.setFlowRoleIds(new ArrayList<>());
                param.setSourceType("sys");
                //param.setTerminals(new HashSet<>());
                ApiResult<Long> obj = userRpcService.upsert(param);

                if (obj == null || obj.getCode() != 200) {
                    throw TwException.error(obj.getCode()+"", obj.getMsg());
                }

                PrdOrgPersonDO pDO = PrdOrgPersonConvert.INSTANCE.toDo(payload);
                pDO = dao.savePerson(pDO);
                PrdOrgEmployeeDO ado = PrdOrgEmployeeConvert.INSTANCE.toDo(payload);
                ado.setWecomId(wecom);
                ado.setPersonId(pDO.getId());
                ado.setUserId(Long.valueOf(obj.getData() + ""));
                ado.setShortcutIds(shortcutIds);
                ado = dao.save(ado);
                //抱保存用户角色
                List<PrdSystemUserRoleDO> userRoleDOS = new ArrayList<>();
                if (payload.getRoleIds() != null && payload.getRoleIds().size() > 0) {
                    for (Long roleId : payload.getRoleIds()) {
                        PrdSystemUserRoleDO roleDO = new PrdSystemUserRoleDO();
                        roleDO.setRoleId(roleId);
                        roleDO.setUserId(ado.getUserId());
                        userRoleDOS.add(roleDO);
                    }
                } else {
                    PrdSystemUserRoleDO roleDO = new PrdSystemUserRoleDO();
                    roleDO.setRoleId(default_role_id);
                    roleDO.setUserId(ado.getUserId());
                    userRoleDOS.add(roleDO);
                }
                dao.saveUserRoleAll(userRoleDOS);

                return ado;
            } else {
                throw TwException.error("", "电话不可为空");
            }

        } else {
            throw TwException.error("", "编号不可重复");
        }
    }

    /**
     * 核对员工组织关系
     *
     * @param orgId
     * @param parentId
     * @param userId
     */
    void checkEmployeeRef(Long orgId, Long parentId, Long userId) {

        if (!ObjectUtils.isEmpty(parentId) && parentId.longValue() != 0) {
//            if (parentId.longValue() == userId.longValue()) {
//                throw TwException.error("", "上下级关系存在不合理操作");
//            }
            PrdOrgEmployeeRefDO employeeRefDO = dao.queryByOrgIdAndUserId(orgId, parentId);
            if (employeeRefDO != null && employeeRefDO.getParentId().longValue() != 0 && employeeRefDO.getParentId().longValue() == userId.longValue()) {
                throw TwException.error("", "上下级关系存在不合理操作");
            }
        }
    }

    //获取默认快捷入口
    String getDefultShortcut() {
        List<Long> shortcutIds = dao.getShortcuts(shortcutSize);
        return org.apache.commons.lang3.StringUtils.join(shortcutIds.toArray(), ",");
    }


}
