package com.elitesland.tw.tw5.server.prd.org.service;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.param.SysUserUpdateParam;
import com.elitescloud.cloudt.system.provider.SysUserRpcService;
import com.elitescloud.cloudt.system.provider.param.SysUserRpcSaveParam;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmOpportunityService;
import com.elitesland.tw.tw5.api.prd.my.service.*;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgEmployeeService;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgOrganizationService;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgSyncDataService;
import com.elitesland.tw.tw5.server.common.HttpUtil;
import com.elitesland.tw.tw5.server.common.QyWx.service.QyWxCommunicationService;
import com.elitesland.tw.tw5.server.common.dao.TransferUtilDAO;
import com.elitesland.tw.tw5.server.common.util.BeanUtil;
import com.elitesland.tw.tw5.server.prd.crm.repo.CrmOpportunityRepo;
import com.elitesland.tw.tw5.server.prd.my.entity.*;
import com.elitesland.tw.tw5.server.prd.my.repo.*;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgEmployeeDAO;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgOrganizationDAO;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgSyncDataDAO;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgSyncLogDAO;
import com.elitesland.tw.tw5.server.prd.org.entity.PrdOrgEmployeeDO;
import com.elitesland.tw.tw5.server.prd.org.entity.PrdOrgEmployeeRefDO;
import com.elitesland.tw.tw5.server.prd.org.entity.PrdOrgOrganizationDO;
import com.elitesland.tw.tw5.server.prd.org.entity.PrdOrgPersonDO;
import com.elitesland.tw.tw5.server.prd.system.entity.PrdSystemUserRoleDO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.*;

/**
 * org模块数据同步service
 *
 * @author wangding
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class PrdOrgSyncDataImpl implements PrdOrgSyncDataService {
    private final PrdOrgSyncLogDAO daoLog;
    private final PrdOrgEmployeeDAO daoEmployee;
    private final PrdOrgSyncDataDAO dao;
    private final TransferUtilDAO transferUtilDAO;
    private final PrdOrgOrganizationDAO orgDao;
    private final ProjectRepo projectRepo;
    private final CrmOpportunityRepo opportunityRepo;
    private final PrdOrgOrganizationDAO orgOrganizationDAO;
    private final TaskRepo taskRepo;
    private final TaskService taskService;
    private final PrdOrgEmployeeDAO employeeDAO;
    private final PrdOrgEmployeeService employeeService;
    private final ProjectService projectService;
    private final ResActivityService resActivityService;
    private final ResActivityRepo resActivityRepo;
    private final PrdOrgOrganizationService orgService;
    private final CrmOpportunityService oppoService;
    private final TaskAuthorizedRepo taskAuthorizedRepo;
    private final TaskAuthorizedService taskAuthorizedService;
    private final TaskAuthorizedDetailsRepo taskAuthorizedDetailsRepo;
    private final ProjShRepo projShRepo;
    private final TimesheetService timesheetService;
    private final TimesheetRepo timesheetRepo;
    private final TimesheetPlanRepo timesheetPlanRepo;
    private final TimesheetPlanTempRepo timesheetPlanTempRepo;


    private final HttpUtil httpUtil;
    private final QyWxCommunicationService qyWxCommunicationService;
    // @DubboReference
//    @Autowired
//    private SysUserRpcService sysUserRpcService;

    @Autowired
    private SysUserRpcService sysUserService;

    @Value("${tw5.shortcut.size}")
    private Integer shortcutSize = 5;

    @Value("${tw5.sys_default.dimensionId}")
    private Long default_dimension_id;

    @Value("${tw5.user_default.password}")
    private String default_password = "111111";

    @Value("${tw5.user_default.role_id}")
    private Long default_role_id;

    @Value("${tw4.sync.crmUser}")
    private String sync_crmUser;

    @Value("${tw4.sync.crmOrg}")
    private String sync_crmOrg;

    @Value("${tw4.sync.crmBuRes}")
    private String sync_crmBuRes;

    @Value("${tw4.sync.project}")
    private String sync_project;

    @Value("${tw4.sync.task}")
    private String sync_task;

    @Value("${tw4.sync.taskAuthorized}")
    private String sync_taskAuthorized;

    @Value("${tw4.sync.taskAuthorizedDetail}")
    private String sync_taskAuthorizedDetail;

    @Value("${tw4.sync.projSh}")
    private String sync_projSh;

    @Value("${tw4.sync.activity:api/openReport/v1/sync/activity}")
    private String sync_activity;

    @Value("${tw4.sync.timesheeet_to4:api/openReport/v1/sync/timesheet_to4}")
    private String sync_timesheet_to4;

    @Value("${tw4.sync.timesheet_vacation_to5:api/openReport/v1/sync/timesheet_vacation_to5}")
    private String timesheet_vacation_to5;

    final String default_role_Code = "ORG-LEADER";

    @Value("${tw4.url}")
    private String tw4_url;

    /**
     * 同步用户
     *///    //@GlobalTransactional
    @Transactional(propagation = Propagation.REQUIRED)
    @Override
    public void syncUsers() {
        //String syncType = "user";
        //LocalDateTime localDateTime = daoLog.queryOrgSyncLog(syncType);
        //if (localDateTime == null) {
        //    localDateTime = LocalDateTime.of(1970, 1, 1, 0, 0);
        //}
        //XxlJobLogger.log("同步用户开始...");
        //XxlJobLogger.log("syncUsers localDateTime：" + localDateTime);
        ////同步到4.0
        //Map<String, Long> map = new HashMap<>();
        //final long asyncTimeLong = localDateTime.toEpochSecond(ZoneOffset.of("+8"));
        //map.put("asyncTime", asyncTimeLong);
        //XxlJobLogger.log("syncUsers asyncTime：" + asyncTimeLong);
        //String result = httpUtil.sendSyncGet(sync_crmUser, map);
        //Map<String, Object> data = (Map) JSON.parse(result);
        //
        //PrdOrgSyncLogDO logDO = new PrdOrgSyncLogDO();
        //String syncData = "";
        //if ((data.get("ok") + "").equals("true")) {
        //    if (!ObjectUtils.isEmpty(data.get("datum"))) {
        //        List<Map<String, Object>> userDatas = (List<Map<String, Object>>) data.get("datum");
        //        // 调试单个资源  测试完注释
        //        //userDatas  = userDatas.stream().filter(userData ->( userData.get("id").toString().equals("1039"))).collect(Collectors.toList());
        //        //XxlJobLogger.log("syncUsers userDatas："+userDatas);
        //        List<Map<String, Long>> bookDatas = transferUtilDAO.queryInterCompanyTw5Maps(SystemDefaultEnum.DefaultAbType.getCode(), AddressBookEnum.RelateIntercompany.getCode());
        //        //通过mam存储公司id
        //        Map<Long, Long> bookDataMap = new HashMap<>();
        //        for (Map<String, Long> bookMap : bookDatas) {
        //            bookDataMap.put(Long.valueOf(bookMap.get("bookIdV4") + ""), Long.valueOf(bookMap.get("id") + ""));
        //        }
        //        String shortcutIds = getDefultShortcut();
        //        List<Long> tw4UserIds = userDatas.stream().map(userData -> ((Integer) (userData.get("userId") == null ? 0 : userData.get("userId"))).longValue()).collect(Collectors.toList());
        //        List<Map<String, Object>> oldUserDatas = transferUtilDAO.queryEmployeeTw5Maps(tw4UserIds);
        //
        //
        //        boolean isHave = true;
        //        if (oldUserDatas == null || oldUserDatas.size() <= 0) {
        //            isHave = false;
        //        }
        //        List<PrdOrgEmployeeDO> employeeDOS = new ArrayList<>();
        //        List<PrdSystemUserRoleDO> userRoleDOS = new ArrayList<>();
        //        List<PrdOrgPersonDO> personDOS = new ArrayList<>();
        //        for (Map<String, Object> userData : userDatas) {
        //            Map<String, Object> old = null;
        //            if (isHave) {
        //                List<Map<String, Object>> olds = oldUserDatas.stream().filter(oldUser -> Long.valueOf(oldUser.get("userIdV4") + "").longValue() == ((Integer) userData.get("userId")).longValue()).collect(Collectors.toList());
        //                if (olds != null && olds.size() > 0) {
        //                    old = olds.get(0);
        //                }
        //            }
        //            saveUser(userData, old, shortcutIds, employeeDOS, userRoleDOS, personDOS, bookDataMap);
        //        }
        //
        //        dao.saveEmployeeAll(employeeDOS);
        //        dao.saveUserRoleAll(userRoleDOS);
        //        if (personDOS.size() > 0) {
        //            dao.savePersonAll(personDOS);
        //        }
        //        syncData = "更新了" + userDatas.size() + "数据";
        //    } else {
        //        syncData = "员工数据未变化";
        //    }
        //
        //} else {
        //    syncData = data.get("reason") + "";
        //}
        //logDO.setSyncType(syncType);
        //logDO.setSyncData(syncData);
        //daoLog.save(logDO);
        //log.info("【人员同步，同步日志：{}】", logDO);
        //XxlJobLogger.log("同步用户结束..." + logDO);
    }

    /**
     * 同步组织
     */
    @Transactional
    @Override
    public void syncOrgs() {
        //String syncType = "org";
        //LocalDateTime localDateTime = daoLog.queryOrgSyncLog(syncType);
        //if (localDateTime == null) {
        //    localDateTime = LocalDateTime.of(1970, 1, 1, 0, 0);
        //}
        ////获取4.0组织数据
        //Map<String, Long> map = new HashMap<>();
        //map.put("asyncTime", localDateTime.toEpochSecond(ZoneOffset.of("+8")));
        //String result = httpUtil.sendSyncGet(sync_crmOrg, map);
        //Map<String, Object> data = (Map) JSON.parse(result);
        //PrdOrgSyncLogDO logDO = new PrdOrgSyncLogDO();
        //String syncData = "";
        //if ((data.get("ok") + "").equals("true")) {
        //    if (!ObjectUtils.isEmpty(data.get("datum"))) {
        //        List<Map<String, Object>> orgDatas = (List<Map<String, Object>>) data.get("datum");
        //        List<PrdOrgOrganizationDO> orgList = new ArrayList<>();
        //        Map<Long, Long> parentMap = new HashMap<>();//存储上下级关系的map
        //        List<PrdOrgOrganizationRefDO> orgRefList = new ArrayList<>();//新建或更新的组织关系
        //        List<PrdOrgRoleDO> orgRoleList = new ArrayList<>();
        //
        //        //获取4.0组织负责人对应的5.0的userid
        //        List<Long> tw4UserIds = orgDatas.stream().map(orgData -> ((Integer) (orgData.get("inchargeUserId") == null ? 0 : (orgData.get("inchargeUserId")))).longValue()).collect(Collectors.toList());
        //        List<Map<String, Object>> userDatas = transferUtilDAO.queryEmployeeTw5Maps(tw4UserIds);
        //        //通过mam存储负责人id
        //        Map<Long, Long> userDataMap = new HashMap<>();
        //        for (Map<String, Object> userMap : userDatas) {
        //            userDataMap.put(Long.valueOf(userMap.get("userIdV4") + ""), Long.valueOf(userMap.get("userId") + ""));
        //        }
        //        //获取需要更新的数据
        //        List<Long> tw4OrgIds = orgDatas.stream().map(orgData -> ((Integer) orgData.get("id")).longValue()).collect(Collectors.toList());
        //        List<Map<String, Long>> oldOrgDatas = transferUtilDAO.queryOrgTw5Maps(tw4OrgIds);
        //        boolean isHave = true;
        //        if (oldOrgDatas == null || oldOrgDatas.size() <= 0) {
        //            isHave = false;
        //        }
        //        //需要更新的组织主键集合
        //        List<Long> updateOrgIds = new ArrayList<>();
        //        //遍历拉取到的4.0组织数据
        //        for (Map<String, Object> orgData : orgDatas) {
        //            //判断是更新还是新增
        //            Map<String, Long> old = null;
        //            if (isHave) {
        //                List<Map<String, Long>> olds = oldOrgDatas.stream().filter(oldOrg -> Long.valueOf(oldOrg.get("orgIdV4") + "").longValue() == ((Integer) orgData.get("id")).longValue()).collect(Collectors.toList());
        //                if (olds != null && olds.size() > 0) {
        //                    old = olds.get(0);
        //                }
        //            }
        //            translateOrg(orgData, orgList, parentMap, userDataMap, old, updateOrgIds);
        //        }
        //        //保存或更新所有组织
        //        List<PrdOrgOrganizationDO> norgList = dao.saveOrganizationAll(orgList);
        //
        //        //查询所有的组织
        //        List<PrdOrgOrganizationDO> allOrgList = dao.queryOrgAll();
        //        //获取需要更新的组织关系
        //        List<PrdOrgOrganizationRefDO> orgRefDOs = null;
        //        if (updateOrgIds.size() > 0) {
        //            orgRefDOs = dao.queryOrgRefs(default_dimension_id, updateOrgIds);
        //        }
        //        for (PrdOrgOrganizationDO orgDO : norgList) {
        //            Long parentId = 0L;
        //            List<PrdOrgOrganizationDO> parents = allOrgList.stream().filter(parentOrg -> (parentOrg.getOrgIdV4() != null && parentMap.get(orgDO.getOrgIdV4()).longValue() == parentOrg.getOrgIdV4().longValue())).collect(Collectors.toList());
        //            if (parents != null && parents.size() > 0) {
        //                parentId = parents.get(0).getId();
        //            }
        //            if (updateOrgIds.size() == 0 || !updateOrgIds.contains(orgDO.getId())) {
        //                //需要新建的组织关系和组织角色
        //                PrdOrgOrganizationRefDO refDao = new PrdOrgOrganizationRefDO();
        //                refDao.setOrgId(orgDO.getId());
        //                refDao.setDimensionId(default_dimension_id);
        //                refDao.setOrgType(1);
        //                refDao.setParentId(parentId);
        //                refDao.setTenantId(orgDO.getTenantId());
        //                orgRefList.add(refDao);
        //
        //                PrdOrgRoleDO roleDO = new PrdOrgRoleDO();
        //                roleDO.setOrgId(orgDO.getId());
        //                roleDO.setRoleCode(default_role_Code);
        //                roleDO.setTenantId(orgDO.getTenantId());
        //                roleDO.setRoleName("组织负责人");
        //                if (orgDO.getManageId() != null && orgDO.getManageId().longValue() != 0) {
        //                    roleDO.setRoleEmployees(orgDO.getManageId() + "");
        //                }
        //                orgRoleList.add(roleDO);
        //            } else {
        //                //需要更细的组织关系
        //                if (orgRefDOs != null) {
        //                    PrdOrgOrganizationRefDO oldRef = orgRefDOs.stream().filter(orgRefDO -> orgRefDO.getOrgId().longValue() == orgDO.getId().longValue()).findFirst().get();
        //                    if (oldRef.getParentId().longValue() != parentId.longValue()) {
        //                        oldRef.setParentId(parentId);
        //                        orgRefList.add(oldRef);
        //                    }
        //                }
        //
        //            }
        //
        //        }
        //        dao.saveOrganizationRefAll(orgRefList);
        //        dao.saveOrgRoleAll(orgRoleList);
        //
        //        syncData = "更新了" + orgDatas.size() + "数据";
        //    } else {
        //        syncData = "组织数据未变化";
        //    }
        //
        //} else {
        //    syncData = data.get("reason") + "";
        //}
        //logDO.setSyncType(syncType);
        //logDO.setSyncData(syncData);
        //daoLog.save(logDO);
    }

    /**
     * 同步组织员工关系
     */
    @Transactional
    @Override
    public void syncOrgRefUsers() {
        //String syncType = "orgRefUser";
        //LocalDateTime localDateTime = daoLog.queryOrgSyncLog(syncType);
        //if (localDateTime == null) {
        //    localDateTime = LocalDateTime.of(1970, 1, 1, 0, 0);
        //}
        //XxlJobLogger.log("组织员工关系同步开始...");
        //XxlJobLogger.log("syncOrgRefUsers localDateTime：" + localDateTime);
        ////获取4.0组织数据
        //Map<String, Long> map = new HashMap<>();
        //final long asyncTimeLong = localDateTime.toEpochSecond(ZoneOffset.of("+8"));
        //map.put("asyncTime", asyncTimeLong);
        //XxlJobLogger.log("syncOrgRefUsers asyncTime：" + asyncTimeLong);
        //String result = httpUtil.sendSyncGet(sync_crmBuRes, map);
        //Map<String, Object> data = (Map) JSON.parse(result);
        //
        //PrdOrgSyncLogDO logDO = new PrdOrgSyncLogDO();
        //String syncData = "";
        //if ((data.get("ok") + "").equals("true")) {
        //    if (!ObjectUtils.isEmpty(data.get("datum"))) {
        //        List<Map<String, Object>> orgRefDatas = (List<Map<String, Object>>) data.get("datum");
        //        List<Long> tw4OrgIds = new ArrayList<>();
        //        List<Long> tw4UserIds = new ArrayList<>();
        //        List<Long> tw4OrgRefUserIds = new ArrayList<>();
        //        for (Map<String, Object> orgRefData : orgRefDatas) {
        //            if (!ObjectUtils.isEmpty(orgRefData.get("buId"))) {
        //                tw4OrgIds.add(((Integer) orgRefData.get("buId")).longValue());
        //            }
        //            if (!ObjectUtils.isEmpty(orgRefData.get("userId"))) {
        //                tw4UserIds.add(((Integer) orgRefData.get("userId")).longValue());
        //            }
        //            if (!ObjectUtils.isEmpty(orgRefData.get("puserId"))) {
        //                tw4UserIds.add(((Integer) orgRefData.get("puserId")).longValue());
        //            }
        //            if (!ObjectUtils.isEmpty(orgRefData.get("id"))) {
        //                tw4OrgRefUserIds.add(((Integer) orgRefData.get("id")).longValue());
        //            }
        //        }
        //        // 查询4.0组织和5.0组织对应关系  5.0里多条数据时，只匹配change_id =0的数据
        //        List<Map<String, Long>> orgDatas = transferUtilDAO.queryOrgTw5Maps(tw4OrgIds);
        //        //通过mam存储tw4.0和5.0对应关系组织id
        //        Map<Long, Long> orgDataMap = new HashMap<>();
        //        for (Map<String, Long> orgMap : orgDatas) {
        //            orgDataMap.put(Long.valueOf(orgMap.get("orgIdV4") + ""), Long.valueOf(orgMap.get("id") + ""));
        //        }
        //        List<Map<String, Object>> userDatas = transferUtilDAO.queryEmployeeTw5Maps(tw4UserIds);
        //        //通过mam存储tw4.0和5.0对应关系用户id
        //        Map<Long, Long> userDataMap = new HashMap<>();
        //        for (Map<String, Object> userMap : userDatas) {
        //            userDataMap.put(Long.valueOf(userMap.get("userIdV4") + ""), Long.valueOf(userMap.get("userId") + ""));
        //        }
        //        //获取需要更新的数据
        //        List<Map<String, Long>> oldOrgRefUserDatas = transferUtilDAO.queryOrgRefUserTw5Maps(tw4OrgRefUserIds);
        //        boolean isHave = true;
        //        if (oldOrgRefUserDatas == null || oldOrgRefUserDatas.size() <= 0) {
        //            isHave = false;
        //        }
        //        List<PrdOrgEmployeeRefDO> orgEmployeeRefDOs = new ArrayList<>();
        //        for (Map<String, Object> orgRefData : orgRefDatas) {
        //            Map<String, Long> old = null;
        //            if (isHave) {
        //                List<Map<String, Long>> olds = oldOrgRefUserDatas.stream().filter(oldOrgRefUser -> Long.valueOf(oldOrgRefUser.get("refIdV4") + "").longValue() == ((Integer) orgRefData.get("id")).longValue()).collect(Collectors.toList());
        //                if (olds != null && olds.size() > 0) {
        //                    old = olds.get(0);
        //                }
        //
        //            }
        //            translateOrgRefUser(orgRefData, orgDataMap, userDataMap, old, orgEmployeeRefDOs);
        //        }
        //        dao.saveOrgEmployeeRefAll(orgEmployeeRefDOs);
        //        syncData = "更新了" + orgRefDatas.size() + "数据";
        //    } else {
        //        syncData = "组织员工关系数据未变化";
        //    }
        //
        //} else {
        //    syncData = data.get("reason") + "";
        //}
        //logDO.setSyncType(syncType);
        //logDO.setSyncData(syncData);
        //daoLog.save(logDO);
        //XxlJobLogger.log("组织员工关系同步结束...:" + syncData);

    }

    /**
     * 同步项目
     */
    @Override
    @Transactional
    public void syncProjects() {
        //String syncType = "project";
        //LocalDateTime localDateTime = daoLog.queryOrgSyncLog(syncType);
        //if (localDateTime == null) {
        //    localDateTime = LocalDateTime.of(1970, 1, 1, 0, 0);
        //}
        //XxlJobLogger.log("项目同步开始...");
        //XxlJobLogger.log("syncUsers localDateTime：" + localDateTime);
        ////同步到4.0
        //Map<String, Long> map = new HashMap<>();
        //final long asyncTimeLong = localDateTime.toEpochSecond(ZoneOffset.of("+8"));
        //map.put("asyncTime", asyncTimeLong);
        //XxlJobLogger.log("syncUsers asyncTime：" + asyncTimeLong);
        //String result = httpUtil.sendSyncGet(sync_project, map);
        //Map<String, Object> data = (Map) JSON.parse(result);
        //PrdOrgSyncLogDO logDO = new PrdOrgSyncLogDO();
        //String syncData = "";
        //Map<Long, Long> v4AndV5UserIds = employeeService.getV4AndV5UserIds();
        //Map<Long, Long> v4AndV5OrgIds = orgService.getV4AndV5OrgIds();
        //if ((data.get("ok") + "").equals("true")) {
        //    if (!ObjectUtils.isEmpty(data.get("datum"))) {
        //        List<Map<String, Object>> projectDatas = (List<Map<String, Object>>) data.get("datum");
        //        //查询5.0已有的数据，进行更新操作
        //        List<ProjectDO> oldProjectDos = new ArrayList<>();
        //        List<Long> tw4ProjectIds = projectDatas.stream().map(projectData -> ((Integer) (projectData.get("id") == null ? 0 : projectData.get("id"))).longValue()).collect(Collectors.toList());
        //        List<ProjectDO> projectDOS = projectRepo.queryByProjIdV4In(tw4ProjectIds);
        //        for (ProjectDO projectDO : projectDOS) {
        //            Long projIdV4 = projectDO.getProjIdV4();
        //            for (Map<String, Object> projectData : projectDatas) {
        //                Long projectId = ((Integer) (projectData.get("id") == null ? 0 : projectData.get("id"))).longValue();
        //                if (projectId.equals(projIdV4)) {
        //                    //将传进来的值和当前值进行对比并更新
        //                    ProjectDO updatedProjectDO = transProjectFromV4(projectData, v4AndV5UserIds, v4AndV5OrgIds);
        //                    updatedProjectDO.setId(projectDO.getId());
        //                    oldProjectDos.add(updatedProjectDO);
        //                    break;
        //                }
        //            }
        //        }
        //        if (!oldProjectDos.isEmpty()) {
        //            projectRepo.saveAll(oldProjectDos);
        //        }
        //
        //        List<Map<String, Object>> newProjectDatas = projectDatas.stream().filter(projectData -> {
        //            boolean flag = true;
        //            Long projectId = ((Integer) (projectData.get("id") == null ? 0 : projectData.get("id"))).longValue();
        //            for (ProjectDO projectDO : projectDOS) {
        //                if (projectDO.getProjIdV4().equals(projectId)) {
        //                    flag = false;
        //                }
        //            }
        //            return flag;
        //        }).collect(Collectors.toList());
        //
        //        //插入新数据
        //        List<ProjectDO> newProjectDos = new ArrayList<>();
        //        for (Map<String, Object> newProjectData : newProjectDatas) {
        //            ProjectDO projectDO = transProjectFromV4(newProjectData, v4AndV5UserIds, v4AndV5OrgIds);
        //            newProjectDos.add(projectDO);
        //        }
        //        if (!newProjectDos.isEmpty()) {
        //            projectRepo.saveAll(newProjectDos);
        //        }
        //        syncData = "更新了" + projectDatas.size() + "数据";
        //    } else {
        //        syncData = "项目数据未变化";
        //    }
        //} else {
        //    syncData = data.get("reason") + "";
        //}
        //logDO.setSyncType(syncType);
        //logDO.setSyncData(syncData);
        //daoLog.save(logDO);
        //log.info("【项目同步，同步日志：{}】", logDO);
        //XxlJobLogger.log("同步项目结束..." + logDO);
    }

    /**
     * 转换项目字段
     *
     * @param newProjectData
     */
    private ProjectDO transProjectFromV4(Map<String, Object> newProjectData, Map<Long, Long> userMap, Map<Long, Long> v4AndV5OrgIds) {
        ProjectDO projectDO = BeanUtil.mapToBean(ProjectDO.class, newProjectData, Arrays.asList("id", "createTime", "createUserId"));
        if (newProjectData.get("id") != null) {
            projectDO.setProjIdV4(Long.valueOf((Integer) newProjectData.get("id")));
        }
        if (newProjectData.get("contractId") != null) {
            projectDO.setContractIdV4(Long.valueOf((Integer) newProjectData.get("contractId")));
        }
        if (newProjectData.get("createUserId") != null) {
            Long createUserId = Long.valueOf((Integer) newProjectData.get("createUserId"));
            projectDO.setCreateUserId(userMap.get(createUserId));
        }
        if (newProjectData.get("pmUserId") != null) {
            Long pmUserId = Long.valueOf((Integer) newProjectData.get("pmUserId"));
            projectDO.setPmUserId(userMap.get(pmUserId));
        }
        if (newProjectData.get("ext2") != null) {
            long ext2 = Long.parseLong(newProjectData.get("ext2").toString());
            projectDO.setExt2(v4AndV5OrgIds.get(ext2).toString());
        }
        return projectDO;
    }


    /**
     * 同步任务
     */
    @Override
    @Transactional
    public void syncTasks(String param) {
        ////初始化数据时用到
        //boolean updateFlag = false;
        //if (StringUtils.hasText(param) && param.equals("update")) {
        //    updateFlag = true;
        //}
        //String syncType = "tasks";
        //LocalDateTime localDateTime = daoLog.queryOrgSyncLog(syncType);
        //if (localDateTime == null) {
        //    localDateTime = LocalDateTime.of(1970, 1, 1, 0, 0);
        //}
        //XxlJobLogger.log("任务同步开始...");
        //XxlJobLogger.log("syncUsers localDateTime：" + localDateTime);
        ////同步到4.0
        //Map<String, Long> map = new HashMap<>();
        //final long asyncTimeLong = localDateTime.toEpochSecond(ZoneOffset.of("+8"));
        //map.put("asyncTime", asyncTimeLong);
        //XxlJobLogger.log("syncUsers asyncTime：" + asyncTimeLong);
        //String result = httpUtil.sendSyncGet(sync_task, map);
        //XxlJobLogger.log("0000");
        //Map<String, Object> data = (Map) JSON.parse(result);
        //XxlJobLogger.log("查询到" + data.size() + "条数据");
        //PrdOrgSyncLogDO logDO = new PrdOrgSyncLogDO();
        //String syncData = "";
        //if ((data.get("ok") + "").equals("true")) {
        //    if (!ObjectUtils.isEmpty(data.get("datum"))) {
        //        Map<Long, Long> v4AndV5UserIds = employeeService.getV4AndV5UserIds();
        //        Map<Long, Long> v4AndV5ProjectIds = projectService.getV4AndV5ProjectIds();
        //        Map<Long, Long> v4AndV5OppoIds = oppoService.getV4AndV5OppoIds();
        //        Map<Long, Long> v4AndV5OrgIds = orgService.getV4AndV5OrgIds();
        //        List<Map<String, Object>> taskDatas = (List<Map<String, Object>>) data.get("datum");
        //        List<TaskDO> oldTaskDOs = new ArrayList<>();
        //        List<TaskDO> taskDOS = new ArrayList<>();
        //        XxlJobLogger.log("11111");
        //        //查询5.0已有的数据，进行更新操作
        //        if (!updateFlag) {
        //            List<Long> tw4TaskIds = taskDatas.stream().map(taskData -> ((Integer) (taskData.get("id") == null ? 0 : taskData.get("id"))).longValue()).collect(Collectors.toList());
        //            taskDOS = taskRepo.queryByTaskIdV4In(tw4TaskIds);
        //            XxlJobLogger.log("2222");
        //            for (TaskDO taskDO : taskDOS) {
        //                Long taskIdV4 = taskDO.getTaskIdV4();
        //                for (Map<String, Object> taskData : taskDatas) {
        //                    Long taskId = ((Integer) (taskData.get("id") == null ? 0 : taskData.get("id"))).longValue();
        //                    if (taskId.equals(taskIdV4)) {
        //                        //直接将新值覆盖旧值
        //                        TaskDO updatedTaskDO = transTaskFromV4(taskData, v4AndV5UserIds, v4AndV5ProjectIds, v4AndV5OppoIds, v4AndV5OrgIds);
        //                        updatedTaskDO.setId(taskDO.getId());
        //                        oldTaskDOs.add(updatedTaskDO);
        //                        break;
        //                    }
        //                }
        //            }
        //            XxlJobLogger.log("3333");
        //            if (!oldTaskDOs.isEmpty()) {
        //                taskRepo.saveAll(oldTaskDOs);
        //                //TODO:同步更新t_timesheet_plan\t_timesheet_plan_temp
        //                for (TaskDO taskDO : taskDOS) {
        //                    timesheetPlanRepo.updateByTaskId(taskDO.getTaskIdV4(), taskDO.getTaskName(), taskDO.getTaskStatus(), taskDO.getEffectiveEqva());
        //                    timesheetPlanTempRepo.updateByTaskId(taskDO.getTaskIdV4(), taskDO.getTaskName(), taskDO.getTaskStatus(), taskDO.getEffectiveEqva());
        //                }
        //            }
        //        }
        //        XxlJobLogger.log("4444");
        //        //筛选出新值，进行插入操作
        //        List<TaskDO> finalTaskDOS = taskDOS;
        //        List<Map<String, Object>> newTaskDatas = taskDatas.stream().filter(taskData -> {
        //            boolean flag = true;
        //            Long taskId = ((Integer) (taskData.get("id") == null ? 0 : taskData.get("id"))).longValue();
        //            for (TaskDO taskDO : finalTaskDOS) {
        //                if (taskDO.getTaskIdV4().equals(taskId)) {
        //                    flag = false;
        //                }
        //            }
        //            return flag;
        //        }).collect(Collectors.toList());
        //        List<TaskDO> newTaskDOs = new ArrayList<>();
        //        //插入新数据
        //        for (Map<String, Object> newTasktData : newTaskDatas) {
        //            TaskDO taskDO = transTaskFromV4(newTasktData, v4AndV5UserIds, v4AndV5ProjectIds, v4AndV5OppoIds, v4AndV5OrgIds);
        //            newTaskDOs.add(taskDO);
        //        }
        //        if (!newTaskDOs.isEmpty()) {
        //            XxlJobLogger.log("5555");
        //            taskRepo.saveAll(newTaskDOs);
        //            XxlJobLogger.log("6666");
        //        }
        //
        //        syncData = "更新了" + taskDatas.size() + "数据";
        //    } else {
        //        syncData = "任务数据未变化";
        //    }
        //} else {
        //    syncData = data.get("reason") + "";
        //}
        //logDO.setSyncType(syncType);
        //logDO.setSyncData(syncData);
        //daoLog.save(logDO);
        //log.info("【任务同步，同步日志：{}】", logDO);
        //XxlJobLogger.log("同步任务结束..." + logDO);
    }

    /**
     * 转换任务字段
     * 工时数据同步to4
     */
    @Override
    @Transactional
    public void syncTimesheetDataTo4() {
//        String syncType = "timesheet";
//        LocalDateTime localDateTime = daoLog.queryOrgSyncLog(syncType);
//        if (localDateTime == null) {
//            localDateTime = LocalDateTime.of(1970, 1, 1, 0, 0);
//        }
//        XxlJobLogger.log("工时同步到4.0开始...");
//        XxlJobLogger.log("syncTimesheetDataTo4 localDateTime：" + localDateTime);
//        //同步到4.0
//        Map<String, Object> map = new HashMap<>();
//        // 查询待同步数据
//        TimesheetQuery query = new TimesheetQuery();
//        query.setModifyTimeStart(localDateTime);
////        List<TimesheetDO> timesheetDoList = timesheetRepo.findAll((root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, query, criteriaBuilder));
//        List<TimesheetDO> timesheetDoList = timesheetRepo.findByModifyTimeAfter(localDateTime);
//        List<TimesheetDO> timesheetDOListCopy = new ArrayList<>();
//        for (TimesheetDO timesheetDO : timesheetDoList) {
//            TimesheetDO timesheetDOCopy = new TimesheetDO();
//            BeanUtils.copyProperties(timesheetDO, timesheetDOCopy);
//            timesheetDOListCopy.add(timesheetDOCopy);
//        }
//        //过滤调未审批完成的运维类项目
////        timesheetDOListCopy = timesheetDOListCopy.stream().filter(e -> {
////            Long projId = e.getProjId();
////            String tsStatus = e.getTsStatus();
////            //非审批完成状态
////            if(!tsStatus.equals("APPROVED")){
////                ProjectDO projectDO = projectRepo.findByProjIdV4(projId).orElse(null);
////                //过滤掉运维类型项目工时
////                if(projectDO!=null && projectDO.getExt1()!=null && projectDO.getExt1().equals(ProjectEnum.DEV_OPS.getCode())){
////                    return false;
////                }else{
////                    return true;
////                }
////            }
////            return true;
////        }).collect(Collectors.toList());
//        String syncData = "";
//        if (timesheetDOListCopy != null && !timesheetDOListCopy.isEmpty()) {
//            Map<Long, Long> v4AndV5UserIds = employeeService.getV4AndV5UserIds().entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
//            Map<Long, Long> v4AndV5OrgIds = orgService.getV4AndV5OrgIds().entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
//            DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss");
//            timesheetDOListCopy.stream().forEach(e -> {
//                e.setTsUserId(v4AndV5UserIds.get(e.getTsUserId()));
//                e.setTsUserBuId(v4AndV5OrgIds.get(e.getTsUserBuId()));
//                e.setApprUserId(v4AndV5UserIds.get(e.getApprUserId()));
//                e.setDelFlag(Byte.valueOf(e.getDeleteFlag().toString()));
//                String approvalTimeStr = e.getApprovalTime() == null ? "" : dateTimeFormatter.format(e.getApprovalTime());
//                ;
//                String submitTimeStr = e.getSubmitTime() == null ? "" : dateTimeFormatter.format(e.getSubmitTime());
//                ;
//                e.setApprovalTime(null);
//                e.setSubmitTime(null);
//                e.setApprovalTimeStr(approvalTimeStr);
//                e.setSubmitTimeStr(submitTimeStr);
//            });
//            //分批处理，每次请求500条
//            List<List<TimesheetDO>> newList = Lists.partition(timesheetDOListCopy, 100);
//            log.warn("分成了" + newList == null ? "0" : newList.size() + "片進行同步");
//            for (List<TimesheetDO> timesheetDOS : newList) {
//                map.put("entityList", timesheetDOS);
//                String result = httpUtil.sendPost(tw4_url + sync_timesheet_to4, map);
//                Map<String, Object> data = (Map) JSON.parse(result);
//                if ((data.get("ok") + "").equals("true")) {
////                    syncData = "更新了" + timesheetDOListCopy.size() + "数据";
//                    List<Map<String, Object>> timeSheetListFromV4 = (List<Map<String, Object>>) data.get("datum");
//                    for (Map<String, Object> timeSheetMap : timeSheetListFromV4) {
//                        Long projId = Long.parseLong(timeSheetMap.get("projId").toString());
//                        ProjectDO projectDO = projectRepo.findByProjIdV4(projId).orElse(null);
//                        Long taskIdV4 = timeSheetMap.get("taskId") == null ? null : Long.parseLong(timeSheetMap.get("taskId").toString());
//                        if (projectDO != null && projectDO.getExt1() != null && projectDO.getExt1().equals(ProjectEnum.DEV_OPS.getCode()) && taskIdV4 != null) {
//                            Long timesheetId = Long.parseLong(timeSheetMap.get("timesheetIdV5").toString());
//                            String taskNo = (String) timeSheetMap.get("taskNo");
//                            String taskName = (String) timeSheetMap.get("taskName");
//                            Long actIdV4 = timeSheetMap.get("actId") == null ? null : Long.parseLong(timeSheetMap.get("actId").toString());
//                            String actNo = (String) timeSheetMap.get("actNo");
//                            String actName = (String) timeSheetMap.get("actName");
//                            //更新工时绑定的任务
//                            timesheetRepo.updateByTaskId(timesheetId, taskIdV4, taskNo, taskName, actIdV4, actNo, actName);
//                        }
//                    }
//                } else {
//                    syncData = data.get("reason") + "";
//                }
//            }
//            syncData = "更新了" + timesheetDOListCopy.size() + "数据";
//
//        } else {
//            syncData = "工时数据未变化";
//        }
//        PrdOrgSyncLogDO logDO = new PrdOrgSyncLogDO();
//        logDO.setSyncType(syncType);
//        logDO.setSyncData(syncData);
//        daoLog.save(logDO);
//        log.info("【工时同步，同步日志：{}】", logDO);
//        XxlJobLogger.log("同步工时结束..." + logDO);

    }

    /**
     * 同步假期工时到5.0
     */
    @Override
    @Transactional
    public void syncVacationTimesheetDataTo5() {
        //String syncType = "timesheet_v";
        //LocalDateTime localDateTime = daoLog.queryOrgSyncLog(syncType);
        //if (localDateTime == null) {
        //    localDateTime = LocalDateTime.of(2023, 1, 1, 0, 0);
        //}
        //XxlJobLogger.log("假期工时同步开始...");
        //XxlJobLogger.log("syncActivity localDateTime：" + localDateTime);
        ////同步到5.0
        //Map<String, Long> map = new HashMap<>();
        //final long asyncTimeLong = localDateTime.toEpochSecond(ZoneOffset.of("+8"));
        //map.put("asyncTime", asyncTimeLong);
        //XxlJobLogger.log("syncActivity asyncTime：" + asyncTimeLong);
        //String result = httpUtil.sendSyncGet(timesheet_vacation_to5, map);
        //Map<String, Object> data = (Map) JSONObject.parse(result);
        //PrdOrgSyncLogDO logDO = new PrdOrgSyncLogDO();
        //String syncData = "";
        //if ((data.get("ok") + "").equals("true")) {
        //    if (!ObjectUtils.isEmpty(data.get("datum"))) {
        //        Map<Long, Long> v4AndV5UserIds = employeeService.getV4AndV5UserIds();
        //        Map<Long, Long> v4AndV5OrgIds = orgService.getV4AndV5OrgIds();
        //        Map<Long, Long> v4AndV5TimesheetIds = timesheetService.getV4AndV5TimesheetIds();
        //        Map<Long, Long> timesheetAndPlanIds = timesheetService.getTimesheetAndPlanIds();
        //        final Object datum = data.get("datum");
        //        List<Map<String, Object>> timesheetDatas = (List<Map<String, Object>>) datum;
        //        //查询5.0已有的数据，进行更新操作
        //        List<TimesheetDO> oldTimesheet = new ArrayList<>();
        //        //查询5.0已有的数据，对新旧数据进行对比，如有变动，进行更新操作
        //        List<Long> tw4TimesheetIds = timesheetDatas.stream().map(activity -> ((Integer) (activity.get("id") == null ? 0 : activity.get("id"))).longValue()).collect(Collectors.toList());
        //        List<TimesheetDO> timesheetDOS = timesheetRepo.queryByTimesheetIdV4In(tw4TimesheetIds);
        //        for (TimesheetDO timesheetDO : timesheetDOS) {
        //            Long timesheetIdV4 = timesheetDO.getTimesheetIdV4();
        //            for (Map<String, Object> timesheet : timesheetDatas) {
        //                Long timesheetId = ((Integer) (timesheet.get("id") == null ? 0 : timesheet.get("id"))).longValue();
        //                if (timesheetId.equals(timesheetIdV4)) {
        //                    //直接将新值覆盖旧值
        //                    TimesheetDO updatedTimesheetDO = transTimesheetFromV4(timesheet, v4AndV5UserIds, v4AndV5OrgIds, v4AndV5TimesheetIds, timesheetAndPlanIds);
        //                    updatedTimesheetDO.setId(updatedTimesheetDO.getId());
        //                    getWorkType(updatedTimesheetDO);
        //                    oldTimesheet.add(updatedTimesheetDO);
        //                    break;
        //                }
        //            }
        //        }
        //        if (!oldTimesheet.isEmpty()) {
        //            timesheetRepo.saveAll(oldTimesheet);
        //            //同步更新计划
        //            List<TimesheetPlanDO> timesheetPlanDOS = TimesheetConvert.INSTANCE.toTimesheetPlanDo(oldTimesheet);
        //            timesheetPlanDOS = timesheetPlanDOS.stream().map(e -> {
        //                e.setId(Long.parseLong(e.getWorkPlanId().toString()));
        //                e.setTsTaskIden("NOTASK");
        //                e.setTsActIden("VACATION");
        //                return e;
        //            }).collect(Collectors.toList());
        //            timesheetPlanRepo.saveAll(timesheetPlanDOS);
        //        }
        //        List<Map<String, Object>> newTimesheetDatas = timesheetDatas.stream().filter(timesheet -> {
        //            boolean flag = true;
        //            Long timesheetId = ((Integer) (timesheet.get("id") == null ? 0 : timesheet.get("id"))).longValue();
        //            for (TimesheetDO timesheetDO : timesheetDOS) {
        //                if (timesheetDO.getTimesheetIdV4().equals(timesheetId)) {
        //                    flag = false;
        //                }
        //            }
        //            return flag;
        //        }).collect(Collectors.toList());
        //        List<TimesheetDO> newTimesheetDOs = new ArrayList<>();
        //        //插入新数据
        //        for (Map<String, Object> newTimesheetData : newTimesheetDatas) {
        //            TimesheetDO timesheetDO = transTimesheetFromV4(newTimesheetData, v4AndV5UserIds, v4AndV5OrgIds, v4AndV5TimesheetIds, timesheetAndPlanIds);
        //            getWorkType(timesheetDO);
        //            newTimesheetDOs.add(timesheetDO);
        //        }
        //        timesheetRepo.saveAll(newTimesheetDOs);
        //        for (TimesheetDO newTimesheetDO : newTimesheetDOs) {
        //            newTimesheetDO.setTimesheetId(newTimesheetDO.getId());
        //        }
        //        //同步插入计划
        //        List<TimesheetPlanDO> timesheetPlanDOS = TimesheetConvert.INSTANCE.toTimesheetPlanDo(newTimesheetDOs);
        //        timesheetPlanDOS = timesheetPlanDOS.stream().map(e -> {
        //            e.setTsTaskIden("NOTASK");
        //            e.setTsActIden("VACATION");
        //            e.setId(null);
        //            return e;
        //        }).collect(Collectors.toList());
        //        timesheetPlanRepo.saveAll(timesheetPlanDOS);
        //        for (TimesheetPlanDO timesheetPlanDO : timesheetPlanDOS) {
        //            Long timesheetId = timesheetPlanDO.getTimesheetId();
        //            for (TimesheetDO newTimesheetDO : newTimesheetDOs) {
        //                if (newTimesheetDO.getId().equals(timesheetId)) {
        //                    timesheetRepo.updatePlan(newTimesheetDO.getId(), timesheetPlanDO.getId());
        //                }
        //            }
        //        }
        //        syncData = "更新了" + timesheetDatas.size() + "数据";
        //    } else {
        //        syncData = "假期工时数据未变化";
        //    }
        //} else {
        //    syncData = data.get("reason") + "";
        //}
        //logDO.setSyncType(syncType);
        //logDO.setSyncData(syncData);
        //daoLog.save(logDO);
        //log.info("【活动同步，同步日志：{}】", logDO);
        //XxlJobLogger.log("同步活动结束..." + logDO);
    }

    private void getWorkType(TimesheetDO timesheetDO) {
        String vInterval = timesheetDO.getVInterval();//上午or下午
        LocalDate workDate = timesheetDO.getWorkDate();
        if (StringUtils.hasText(vInterval)) {
            if (vInterval.equals("AM")) {
                timesheetDO.setWorkType(workDate.toString() + " 09:00:00," + workDate.toString() + " 14:00:00");
            } else {
                timesheetDO.setWorkType(workDate.toString() + " 14:00:00," + workDate.toString() + " 18:00:00");
            }
        } else {
            timesheetDO.setWorkType(workDate.toString() + " 09:00:00," + workDate.toString() + " 18:00:00");
        }
    }


    /**
     * @param timesheetData
     */
    private TimesheetDO transTimesheetFromV4(Map<String, Object> timesheetData, Map<Long, Long> v4AndV5UserIds, Map<Long, Long> v4AndV5OrgIds, Map<Long, Long> v4AndV5TimesheetIds, Map<Long, Long> timesheetAndPlanIds) {
        TimesheetDO timesheetDo = BeanUtil.mapToBean(TimesheetDO.class, timesheetData, Arrays.asList("id", "createTime", "createUserId"));
//        if(timesheetData.get("timesheetIdV5")!=null){
//            Long timesheetIdV5 = Long.valueOf((Integer) timesheetData.get("timesheetIdV5"));
//            if(timesheetIdV5!=null){
////                timesheetDo.setId(timesheetIdV5);
//                timesheetDo.setTimesheetId(timesheetIdV5);
//                if(timesheetAndPlanIds.get(timesheetIdV5)!=null){
//                    timesheetDo.setWorkPlanId(Integer.parseInt(timesheetAndPlanIds.get(timesheetIdV5).toString()));
//                }
//            }
//        }
        if (timesheetData.get("id") != null) {
            Long timesheetIdV4 = Long.valueOf((Integer) timesheetData.get("id"));
            timesheetDo.setTimesheetIdV4(timesheetIdV4);
            Long timesheetIdV5 = v4AndV5TimesheetIds.get(timesheetIdV4);
            //更新态
            if (timesheetIdV5 != null) {
                timesheetDo.setId(timesheetIdV5);
                timesheetDo.setTimesheetId(timesheetIdV5);
                if (timesheetAndPlanIds.get(timesheetIdV5) != null) {
                    timesheetDo.setWorkPlanId(timesheetAndPlanIds.get(timesheetIdV5));
                }
            }
        }
        if (timesheetData.get("createUserId") != null) {
            Long createUserId = Long.valueOf((Integer) timesheetData.get("createUserId"));
            timesheetDo.setCreateUserId(v4AndV5UserIds.get(createUserId));
        }
        if (timesheetData.get("apprUserId") != null) {
            Long apprUserId = Long.valueOf((Integer) timesheetData.get("apprUserId"));
            timesheetDo.setApprUserId(v4AndV5UserIds.get(apprUserId));
        }
        if (timesheetData.get("tsUserId") != null) {
            Long tsUserId = Long.valueOf((Integer) timesheetData.get("tsUserId"));
            timesheetDo.setTsUserId(v4AndV5UserIds.get(tsUserId));
        }
        if (timesheetData.get("tsUserBuId") != null) {
            Long expenseBuId = Long.valueOf((Integer) timesheetData.get("tsUserBuId"));
            timesheetDo.setTsUserBuId(v4AndV5OrgIds.get(expenseBuId));
        }
        return timesheetDo;
    }


    /**
     * 同步活动
     */
    @Override
    @Transactional
    public void syncActivity() {
        //String syncType = "activity";
        //LocalDateTime localDateTime = daoLog.queryOrgSyncLog(syncType);
        //if (localDateTime == null) {
        //    localDateTime = LocalDateTime.of(1970, 1, 1, 0, 0);
        //}
        //XxlJobLogger.log("活动同步开始...");
        //XxlJobLogger.log("syncActivity localDateTime：" + localDateTime);
        ////同步到5.0
        //Map<String, Long> map = new HashMap<>();
        //final long asyncTimeLong = localDateTime.toEpochSecond(ZoneOffset.of("+8"));
        //map.put("asyncTime", asyncTimeLong);
        //XxlJobLogger.log("syncActivity asyncTime：" + asyncTimeLong);
        //String result = httpUtil.sendSyncGet(sync_activity, map);
        //Map<String, Object> data = (Map) JSONObject.parse(result);
        //PrdOrgSyncLogDO logDO = new PrdOrgSyncLogDO();
        //String syncData = "";
        //if ((data.get("ok") + "").equals("true")) {
        //    if (!ObjectUtils.isEmpty(data.get("datum"))) {
        //        Map<Long, Long> v4AndV5UserIds = employeeService.getV4AndV5UserIds();
        //        Map<Long, Long> v4AndV5ActivityIds = resActivityService.getV4AndV5ActivityIds();
        //        Map<Long, Long> v4AndV5OppoIds = oppoService.getV4AndV5OppoIds();
        //        Map<Long, Long> v4AndV5OrgIds = orgService.getV4AndV5OrgIds();
        //        final Object datum = data.get("datum");
        //        List<Map<String, Object>> activityDatas = (List<Map<String, Object>>) datum;
        //        //查询5.0已有的数据，进行更新操作
        //        List<ResActivityDO> oldResActivity = new ArrayList<>();
        //        //查询5.0已有的数据，对新旧数据进行对比，如有变动，进行更新操作
        //        List<Long> tw4ActivityIds = activityDatas.stream().map(activity -> ((Integer) (activity.get("id") == null ? 0 : activity.get("id"))).longValue()).collect(Collectors.toList());
        //        List<ResActivityDO> resActivityDOS = resActivityRepo.queryByActivityIdV4In(tw4ActivityIds);
        //        for (ResActivityDO activityDO : resActivityDOS) {
        //            Long activityIdV4 = activityDO.getActivityIdV4();
        //            for (Map<String, Object> activity : activityDatas) {
        //                Long activityId = ((Integer) (activity.get("id") == null ? 0 : activity.get("id"))).longValue();
        //                if (activityId.equals(activityIdV4)) {
        //                    //直接将新值覆盖旧值
        //                    ResActivityDO updatedTaskDO = transActivityFromV4(activity, v4AndV5UserIds, v4AndV5ActivityIds, v4AndV5OppoIds, v4AndV5OrgIds);
        //                    updatedTaskDO.setId(activityDO.getId());
        //                    oldResActivity.add(updatedTaskDO);
        //                    break;
        //                }
        //            }
        //        }
        //        if (!oldResActivity.isEmpty()) {
        //            resActivityRepo.saveAll(oldResActivity);
        //        }
        //        List<Map<String, Object>> newTaskDatas = activityDatas.stream().filter(activity -> {
        //            boolean flag = true;
        //            Long activityId = ((Integer) (activity.get("id") == null ? 0 : activity.get("id"))).longValue();
        //            for (ResActivityDO activityDO : resActivityDOS) {
        //                if (activityDO.getActivityIdV4().equals(activityId)) {
        //                    flag = false;
        //                }
        //            }
        //            return flag;
        //        }).collect(Collectors.toList());
        //        List<ResActivityDO> newResActivityDOs = new ArrayList<>();
        //        //插入新数据
        //        for (Map<String, Object> newTasktData : newTaskDatas) {
        //            ResActivityDO taskDO = transActivityFromV4(newTasktData, v4AndV5UserIds, v4AndV5ActivityIds, v4AndV5OppoIds, v4AndV5OrgIds);
        //            newResActivityDOs.add(taskDO);
        //        }
        //        resActivityRepo.saveAll(newResActivityDOs);
        //        syncData = "更新了" + activityDatas.size() + "数据";
        //    } else {
        //        syncData = "活动数据未变化";
        //    }
        //} else {
        //    syncData = data.get("reason") + "";
        //}
        //logDO.setSyncType(syncType);
        //logDO.setSyncData(syncData);
        //daoLog.save(logDO);
        //log.info("【活动同步，同步日志：{}】", logDO);
        //XxlJobLogger.log("同步活动结束..." + logDO);
    }

    /**
     * 插入新任务
     *
     * @param newTaskData
     */
    private TaskDO transTaskFromV4(Map<String, Object> newTaskData, Map<Long, Long> v4AndV5UserIds, Map<Long, Long> v4AndV5ProjectIds, Map<Long, Long> v4AndV5OppoIds, Map<Long, Long> v4AndV5OrgIds) {
        TaskDO taskDO = BeanUtil.mapToBean(TaskDO.class, newTaskData, Arrays.asList("id", "createTime", "createUserId"));
        if (newTaskData.get("id") != null) {
            taskDO.setTaskIdV4(Long.valueOf((Integer) newTaskData.get("id")));
        }
        //if (taskDO.getUsedEqva() == null) {
        //    taskDO.setUsedEqva(BigDecimal.ZERO);
        //}
        //if (taskDO.getEffectiveEqva() == null) {
        //    taskDO.setEffectiveEqva(BigDecimal.ZERO);
        //}
        Long taskReasonId = getTaskReasonId(newTaskData, v4AndV5ProjectIds, v4AndV5OppoIds, v4AndV5OrgIds);
        taskDO.setReasonId(taskReasonId);
        if (newTaskData.get("reasonId") != null) {
            taskDO.setReasonIdv4(Long.valueOf((Integer) newTaskData.get("reasonId")));
        }
        if (newTaskData.get("createUserId") != null) {
            Long createUserId = Long.valueOf((Integer) newTaskData.get("createUserId"));
            taskDO.setCreateUserId(v4AndV5UserIds.get(createUserId));
        }
        if (newTaskData.get("disterUserId") != null) {
            Long disterUserId = Long.valueOf((Integer) newTaskData.get("disterUserId"));
            taskDO.setDisterUserId(v4AndV5UserIds.get(disterUserId));
        }
        if (newTaskData.get("receiverUserId") != null) {
            Long receiverUserId = Long.valueOf((Integer) newTaskData.get("receiverUserId"));
            taskDO.setReceiverUserId(v4AndV5UserIds.get(receiverUserId));
        }
        return taskDO;
    }


    /**
     * 同步任务包授权
     */
    @Override
    @Transactional
    public void syncTaskAuthorized() {
//        String syncType = "taskAuthorized";
//        LocalDateTime localDateTime = daoLog.queryOrgSyncLog(syncType);
//        if (localDateTime == null) {
//            localDateTime = LocalDateTime.of(1970, 1, 1, 0, 0);
//        }
//        XxlJobLogger.log("任务包授权同步开始...");
//        XxlJobLogger.log("syncUsers localDateTime：" + localDateTime);
//        //同步到4.0
//        Map<String, Long> map = new HashMap<>();
//        final long asyncTimeLong = localDateTime.toEpochSecond(ZoneOffset.of("+8"));
//        map.put("asyncTime", asyncTimeLong);
//        XxlJobLogger.log("syncUsers asyncTime：" + asyncTimeLong);
//        String result = httpUtil.sendSyncGet(sync_taskAuthorized, map);
//        Map<String, Object> data = (Map) JSON.parse(result);
//        PrdOrgSyncLogDO logDO = new PrdOrgSyncLogDO();
//        String syncData = "";
//        Map<Long, Long> v4AndV5UserIds = employeeService.getV4AndV5UserIds();
//        Map<Long, Long> v4AndV5OrgIds = orgService.getV4AndV5OrgIds();
//        if ((data.get("ok") + "").equals("true")) {
//            if (!ObjectUtils.isEmpty(data.get("datum"))) {
//                List<Map<String, Object>> taskAuthorizedDatas = (List<Map<String, Object>>) data.get("datum");
//                //查询5.0已有的数据，进行更新操作
//                List<TaskAuthorizedDO> oldTaskAuthorizedDos = new ArrayList<>();
//                List<Long> tw4TaskAuthorizedIds = taskAuthorizedDatas.stream().map(taskAuthorizedData -> ((Integer) (taskAuthorizedData.get("id") == null ? 0 : taskAuthorizedData.get("id"))).longValue()).collect(Collectors.toList());
//                List<TaskAuthorizedDO> taskAuthorizedDOS = taskAuthorizedRepo.queryByTaskAuthorizedV4In(tw4TaskAuthorizedIds);
//                for (TaskAuthorizedDO taskAuthorizedDO : taskAuthorizedDOS) {
//                    Long taskAuthorizedIdV4 = taskAuthorizedDO.getTaskAuthorizedV4();
//                    for (Map<String, Object> taskAuthorizedData : taskAuthorizedDatas) {
//                        Long taskAuthorizedId = ((Integer) (taskAuthorizedData.get("id") == null ? 0 : taskAuthorizedData.get("id"))).longValue();
//                        if (taskAuthorizedId.equals(taskAuthorizedIdV4)) {
//                            //将传进来的值和当前值进行对比并更新
//                            TaskAuthorizedDO updatedTaskAuthorizedDO = transTaskAuthorizedFromV4(taskAuthorizedData, v4AndV5UserIds, v4AndV5OrgIds);
//                            updatedTaskAuthorizedDO.setId(taskAuthorizedDO.getId());
//                            oldTaskAuthorizedDos.add(updatedTaskAuthorizedDO);
//                            break;
//                        }
//                    }
//                }
//                if (!oldTaskAuthorizedDos.isEmpty()) {
//                    taskAuthorizedRepo.saveAll(oldTaskAuthorizedDos);
//                }
//
//                List<Map<String, Object>> newTaskAuthorizedDatas = taskAuthorizedDatas.stream().filter(taskAuthorizedData -> {
//                    boolean flag = true;
//                    Long taskAuthorizedId = ((Integer) (taskAuthorizedData.get("id") == null ? 0 : taskAuthorizedData.get("id"))).longValue();
//                    for (TaskAuthorizedDO taskAuthorizedDO : taskAuthorizedDOS) {
//                        if (taskAuthorizedDO.getTaskAuthorizedV4().equals(taskAuthorizedId)) {
//                            flag = false;
//                        }
//                    }
//                    return flag;
//                }).collect(Collectors.toList());
//
//                //插入新数据
//                List<TaskAuthorizedDO> newTaskAuthorizedDos = new ArrayList<>();
//                for (Map<String, Object> newTaskAuthorizedData : newTaskAuthorizedDatas) {
//                    TaskAuthorizedDO taskAuthorizedDO = transTaskAuthorizedFromV4(newTaskAuthorizedData, v4AndV5UserIds, v4AndV5OrgIds);
//                    newTaskAuthorizedDos.add(taskAuthorizedDO);
//                }
//                if (!newTaskAuthorizedDos.isEmpty()) {
//                    taskAuthorizedRepo.saveAll(newTaskAuthorizedDos);
//                }
//                syncData = "更新了" + taskAuthorizedDatas.size() + "数据";
//            } else {
//                syncData = "任务包授权数据未变化";
//            }
//        } else {
//            syncData = data.get("reason") + "";
//        }
//        logDO.setSyncType(syncType);
//        logDO.setSyncData(syncData);
//        daoLog.save(logDO);
//        log.info("【任务包授权同步，同步日志：{}】", logDO);
//        XxlJobLogger.log("同步任务包授权结束..." + logDO);
//        //同步明细
////        syncTaskAuthorizedDetails();
    }

    /**
     * 转换任务包授权字段
     *
     * @param newTaskAuthorizedData
     */
    private TaskAuthorizedDO transTaskAuthorizedFromV4(Map<String, Object> newTaskAuthorizedData, Map<Long, Long> userMap, Map<Long, Long> orgMap) {
        TaskAuthorizedDO taskAuthorizedDO = BeanUtil.mapToBean(TaskAuthorizedDO.class, newTaskAuthorizedData, Arrays.asList("id", "createTime", "createUserId"));
        if (newTaskAuthorizedData.get("id") != null) {
            taskAuthorizedDO.setTaskAuthorizedV4(Long.valueOf((Integer) newTaskAuthorizedData.get("id")));
        }
        if (newTaskAuthorizedData.get("createUserId") != null) {
            Long createUserId = Long.valueOf((Integer) newTaskAuthorizedData.get("createUserId"));
            taskAuthorizedDO.setCreateUserId(userMap.get(createUserId));
        }
        if (newTaskAuthorizedData.get("disterUserId") != null) {
            Long disterUserId = Long.valueOf((Integer) newTaskAuthorizedData.get("disterUserId"));
            taskAuthorizedDO.setDisterUserId(userMap.get(disterUserId));
        }
        if (newTaskAuthorizedData.get("receiverUserId") != null) {
            Long receiverUserId = Long.valueOf((Integer) newTaskAuthorizedData.get("receiverUserId"));
            taskAuthorizedDO.setReceiverUserId(userMap.get(receiverUserId));
        }
        if (newTaskAuthorizedData.get("receiverBuId") != null) {
            Long receiverBuId = Long.valueOf((Integer) newTaskAuthorizedData.get("receiverBuId"));
            taskAuthorizedDO.setReceiverOrgId(orgMap.get(receiverBuId));
        }
        if (newTaskAuthorizedData.get("expenseBuId") != null) {
            Long expenseBuId = Long.valueOf((Integer) newTaskAuthorizedData.get("expenseBuId"));
            taskAuthorizedDO.setExpenseOrgId(orgMap.get(expenseBuId));
        }
        return taskAuthorizedDO;
    }


    /**
     * 同步任务包授权
     */
    @Override
    @Transactional
    public void syncTaskAuthorizedDetails() {
        //String syncType = "taskAuthorizedDetails";
        //LocalDateTime localDateTime = daoLog.queryOrgSyncLog(syncType);
        //if (localDateTime == null) {
        //    localDateTime = LocalDateTime.of(1970, 1, 1, 0, 0);
        //}
        //XxlJobLogger.log("任务包授权同步开始...");
        //XxlJobLogger.log("syncUsers localDateTime：" + localDateTime);
        ////同步到4.0
        //Map<String, Long> map = new HashMap<>();
        //final long asyncTimeLong = localDateTime.toEpochSecond(ZoneOffset.of("+8"));
        //map.put("asyncTime", asyncTimeLong);
        //XxlJobLogger.log("syncUsers asyncTime：" + asyncTimeLong);
        //String result = httpUtil.sendSyncGet(sync_taskAuthorizedDetail, map);
        //Map<String, Object> data = (Map) JSON.parse(result);
        //PrdOrgSyncLogDO logDO = new PrdOrgSyncLogDO();
        //String syncData = "";
        //Map<Long, Long> v4AndV5UserIds = employeeService.getV4AndV5UserIds();
        //Map<Long, Long> authMap = taskAuthorizedService.getV4AndV5AuthIds();
        //Map<Long, Long> taskMap = taskService.getV4AndV5TaskIds();
        //Map<Long, Long> orgMap = orgService.getV4AndV5OrgIds();
        //if ((data.get("ok") + "").equals("true")) {
        //    if (!ObjectUtils.isEmpty(data.get("datum"))) {
        //        List<Map<String, Object>> taskAuthorizedDetailsDatas = (List<Map<String, Object>>) data.get("datum");
        //        //查询5.0已有的数据，进行更新操作
        //        List<TaskAuthorizedDetailsDO> oldTaskAuthorizedDetailsDos = new ArrayList<>();
        //        List<Long> tw4TaskAuthorizedDetailsIds = taskAuthorizedDetailsDatas.stream().map(taskAuthorizedDetailsData -> ((Integer) (taskAuthorizedDetailsData.get("id") == null ? 0 : taskAuthorizedDetailsData.get("id"))).longValue()).collect(Collectors.toList());
        //        List<TaskAuthorizedDetailsDO> taskAuthorizedDetailsDOS = taskAuthorizedDetailsRepo.queryByTaskAuthorizedDetailIdV4In(tw4TaskAuthorizedDetailsIds);
        //        for (TaskAuthorizedDetailsDO taskAuthorizedDetailsDO : taskAuthorizedDetailsDOS) {
        //            Long taskAuthorizedDetailsIdV4 = taskAuthorizedDetailsDO.getTaskAuthorizedDetailIdV4();
        //            for (Map<String, Object> taskAuthorizedDetailsData : taskAuthorizedDetailsDatas) {
        //                Long taskAuthorizedDetailsId = ((Integer) (taskAuthorizedDetailsData.get("id") == null ? 0 : taskAuthorizedDetailsData.get("id"))).longValue();
        //                if (taskAuthorizedDetailsId.equals(taskAuthorizedDetailsIdV4)) {
        //                    //将传进来的值和当前值进行对比并更新
        //                    TaskAuthorizedDetailsDO updatedTaskAuthorizedDetailsDO = transTaskAuthorizedDetailsFromV4(taskAuthorizedDetailsData, v4AndV5UserIds, authMap, taskMap, orgMap);
        //                    updatedTaskAuthorizedDetailsDO.setId(taskAuthorizedDetailsDO.getId());
        //                    oldTaskAuthorizedDetailsDos.add(updatedTaskAuthorizedDetailsDO);
        //                    break;
        //                }
        //            }
        //        }
        //        if (!oldTaskAuthorizedDetailsDos.isEmpty()) {
        //            taskAuthorizedDetailsRepo.saveAll(oldTaskAuthorizedDetailsDos);
        //        }
        //
        //        List<Map<String, Object>> newTaskAuthorizedDetailsDatas = taskAuthorizedDetailsDatas.stream().filter(taskAuthorizedDetailsData -> {
        //            boolean flag = true;
        //            Long taskAuthorizedDetailsId = ((Integer) (taskAuthorizedDetailsData.get("id") == null ? 0 : taskAuthorizedDetailsData.get("id"))).longValue();
        //            for (TaskAuthorizedDetailsDO taskAuthorizedDetailsDO : taskAuthorizedDetailsDOS) {
        //                if (taskAuthorizedDetailsDO.getTaskAuthorizedDetailIdV4().equals(taskAuthorizedDetailsId)) {
        //                    flag = false;
        //                }
        //            }
        //            return flag;
        //        }).collect(Collectors.toList());
        //
        //        //插入新数据
        //        List<TaskAuthorizedDetailsDO> newTaskAuthorizedDetailsDos = new ArrayList<>();
        //        for (Map<String, Object> newTaskAuthorizedDetailsData : newTaskAuthorizedDetailsDatas) {
        //            TaskAuthorizedDetailsDO taskAuthorizedDetailsDO = transTaskAuthorizedDetailsFromV4(newTaskAuthorizedDetailsData, v4AndV5UserIds, authMap, taskMap, orgMap);
        //            newTaskAuthorizedDetailsDos.add(taskAuthorizedDetailsDO);
        //        }
        //        if (!newTaskAuthorizedDetailsDos.isEmpty()) {
        //            taskAuthorizedDetailsRepo.saveAll(newTaskAuthorizedDetailsDos);
        //        }
        //        syncData = "更新了" + taskAuthorizedDetailsDatas.size() + "数据";
        //    } else {
        //        syncData = "任务包授权数据未变化";
        //    }
        //} else {
        //    syncData = data.get("reason") + "";
        //}
        //logDO.setSyncType(syncType);
        //logDO.setSyncData(syncData);
        //daoLog.save(logDO);
        //log.info("【任务包授权同步，同步日志：{}】", logDO);
        //XxlJobLogger.log("同步任务包授权结束..." + logDO);
    }

    /**
     * 转换任务包授权字段
     *
     * @param newTaskAuthorizedDetailsData
     */
    private TaskAuthorizedDetailsDO transTaskAuthorizedDetailsFromV4(Map<String, Object> newTaskAuthorizedDetailsData, Map<Long, Long> userMap, Map<Long, Long> authMap, Map<Long, Long> taskMap, Map<Long, Long> orgMap) {
        TaskAuthorizedDetailsDO taskAuthorizedDetailsDO = BeanUtil.mapToBean(TaskAuthorizedDetailsDO.class, newTaskAuthorizedDetailsData, Arrays.asList("id", "createTime", "createUserId"));
        if (newTaskAuthorizedDetailsData.get("id") != null) {
            taskAuthorizedDetailsDO.setTaskAuthorizedDetailIdV4(Long.valueOf((Integer) newTaskAuthorizedDetailsData.get("id")));
        }
        if (newTaskAuthorizedDetailsData.get("authId") != null) {
            Long authId = Long.valueOf((Integer) newTaskAuthorizedDetailsData.get("authId"));
            taskAuthorizedDetailsDO.setAuthId(authId);
            taskAuthorizedDetailsDO.setAuthIdV5(authMap.get(authId));
        }
        if (newTaskAuthorizedDetailsData.get("taskId") != null) {
            Long taskId = Long.valueOf((Integer) newTaskAuthorizedDetailsData.get("taskId"));
            taskAuthorizedDetailsDO.setTaskId(taskId);
            taskAuthorizedDetailsDO.setTaskIdV5(taskMap.get(taskId));
        }
        if (newTaskAuthorizedDetailsData.get("receiverUserId") != null) {
            Long receiverUserId = Long.valueOf((Integer) newTaskAuthorizedDetailsData.get("receiverUserId"));
            taskAuthorizedDetailsDO.setReceiverUserId(userMap.get(receiverUserId));
        }
        if (newTaskAuthorizedDetailsData.get("receiverBuId") != null) {
            Long receiverBuId = Long.valueOf((Integer) newTaskAuthorizedDetailsData.get("receiverBuId"));
            taskAuthorizedDetailsDO.setReceiverOrgId(orgMap.get(receiverBuId));
        }
        if (newTaskAuthorizedDetailsData.get("createUserId") != null) {
            Long createUserId = Long.valueOf((Integer) newTaskAuthorizedDetailsData.get("createUserId"));
            taskAuthorizedDetailsDO.setCreateUserId(userMap.get(createUserId));
        }
        return taskAuthorizedDetailsDO;
    }

    /**
     * 同步项目成员
     */
    @Override
    @Transactional
    public void syncProjSh() {
        //String syncType = "projSh";
        //LocalDateTime localDateTime = daoLog.queryOrgSyncLog(syncType);
        //if (localDateTime == null) {
        //    localDateTime = LocalDateTime.of(1970, 1, 1, 0, 0);
        //}
        //XxlJobLogger.log("项目成员同步开始...");
        //XxlJobLogger.log("syncUsers localDateTime：" + localDateTime);
        ////同步到4.0
        //Map<String, Long> map = new HashMap<>();
        //final long asyncTimeLong = localDateTime.toEpochSecond(ZoneOffset.of("+8"));
        //map.put("asyncTime", asyncTimeLong);
        //XxlJobLogger.log("syncUsers asyncTime：" + asyncTimeLong);
        //String result = httpUtil.sendSyncGet(sync_projSh, map);
        //Map<String, Object> data = (Map) JSON.parse(result);
        //PrdOrgSyncLogDO logDO = new PrdOrgSyncLogDO();
        //String syncData = "";
        //Map<Long, Long> v4AndV5UserIds = employeeService.getV4AndV5UserIds();
        //Map<Long, Long> v4AndV5ProjIds = projectService.getV4AndV5ProjectIds();
        //if ((data.get("ok") + "").equals("true")) {
        //    if (!ObjectUtils.isEmpty(data.get("datum"))) {
        //        List<Map<String, Object>> projShDatas = (List<Map<String, Object>>) data.get("datum");
        //        //查询5.0已有的数据，进行更新操作
        //        List<ProjShDO> oldProjShDos = new ArrayList<>();
        //        List<Long> tw4ProjShIds = projShDatas.stream().map(projShData -> ((Integer) (projShData.get("id") == null ? 0 : projShData.get("id"))).longValue()).collect(Collectors.toList());
        //        List<ProjShDO> projShDOS = projShRepo.queryByProjShIdV4In(tw4ProjShIds);
        //        for (ProjShDO projShDO : projShDOS) {
        //            Long projIdV4 = projShDO.getProjShIdV4();
        //            for (Map<String, Object> projShData : projShDatas) {
        //                Long projShId = ((Integer) (projShData.get("id") == null ? 0 : projShData.get("id"))).longValue();
        //                if (projShId.equals(projIdV4)) {
        //                    //将传进来的值和当前值进行对比并更新
        //                    ProjShDO updatedProjShDO = transProjShFromV4(projShData, v4AndV5UserIds, v4AndV5ProjIds);
        //                    updatedProjShDO.setId(projShDO.getId());
        //                    oldProjShDos.add(updatedProjShDO);
        //                    break;
        //                }
        //            }
        //        }
        //        if (!oldProjShDos.isEmpty()) {
        //            projShRepo.saveAll(oldProjShDos);
        //        }
        //
        //        List<Map<String, Object>> newProjShDatas = projShDatas.stream().filter(projShData -> {
        //            boolean flag = true;
        //            Long projShId = ((Integer) (projShData.get("id") == null ? 0 : projShData.get("id"))).longValue();
        //            for (ProjShDO projShDO : projShDOS) {
        //                if (projShDO.getProjShIdV4().equals(projShId)) {
        //                    flag = false;
        //                }
        //            }
        //            return flag;
        //        }).collect(Collectors.toList());
        //
        //        //插入新数据
        //        List<ProjShDO> newProjShDos = new ArrayList<>();
        //        for (Map<String, Object> newProjShData : newProjShDatas) {
        //            ProjShDO projShDO = transProjShFromV4(newProjShData, v4AndV5UserIds, v4AndV5ProjIds);
        //            newProjShDos.add(projShDO);
        //        }
        //        if (!newProjShDos.isEmpty()) {
        //            projShRepo.saveAll(newProjShDos);
        //        }
        //        syncData = "更新了" + projShDatas.size() + "数据";
        //    } else {
        //        syncData = "项目成员数据未变化";
        //    }
        //} else {
        //    syncData = data.get("reason") + "";
        //}
        //logDO.setSyncType(syncType);
        //logDO.setSyncData(syncData);
        //daoLog.save(logDO);
        //log.info("【项目成员同步，同步日志：{}】", logDO);
        //XxlJobLogger.log("同步项目成员结束..." + logDO);
    }

    /**
     * 转换项目成员字段
     *
     * @param newProjShData
     */
    private ProjShDO transProjShFromV4(Map<String, Object> newProjShData, Map<Long, Long> userMap, Map<Long, Long> v4AndV5ProjIds) {
        ProjShDO projShDO = BeanUtil.mapToBean(ProjShDO.class, newProjShData, Arrays.asList("id", "createTime", "createUserId"));
        if (newProjShData.get("id") != null) {
            projShDO.setProjShIdV4(Long.valueOf((Integer) newProjShData.get("id")));
        }
        if (newProjShData.get("projId") != null) {
            Long projectId = Long.valueOf((Integer) newProjShData.get("projId"));
            projShDO.setProjId(projectId);
            projShDO.setProjIdV5(v4AndV5ProjIds.get(projectId));
        }
        if (newProjShData.get("createUserId") != null) {
            Long createUserId = Long.valueOf((Integer) newProjShData.get("createUserId"));
            projShDO.setCreateUserId(userMap.get(createUserId));
        }
        if (newProjShData.get("userId") != null) {
            Long pmUserId = Long.valueOf((Integer) newProjShData.get("userId"));
            projShDO.setUserId(userMap.get(pmUserId));
        }
        return projShDO;
    }


    /**
     * 插入新活动
     *
     * @param newTaskData
     */
    private ResActivityDO transActivityFromV4(Map<String, Object> newTaskData, Map<Long, Long> v4AndV5UserIds, Map<Long, Long> v4AndV5ProjectIds, Map<Long, Long> v4AndV5OppoIds, Map<Long, Long> v4AndV5OrgIds) {
        ResActivityDO resActivityDO = BeanUtil.mapToBean(ResActivityDO.class, newTaskData, Arrays.asList("id", "createTime", "createUserId"));
        if (newTaskData.get("id") != null) {
            resActivityDO.setActivityIdV4(Long.valueOf((Integer) newTaskData.get("id")));
        }
        if (newTaskData.get("createUserId") != null) {
            Long createUserId = Long.valueOf((Integer) newTaskData.get("createUserId"));
            resActivityDO.setCreateUserId(v4AndV5UserIds.get(createUserId));
        }
        return resActivityDO;
    }


    private void updateActivityFromV4(ResActivityDO activityDO, Map<String, Object> activityData) {
        ResActivityDO doV4 = BeanUtil.mapToBean(ResActivityDO.class, activityData, Arrays.asList("id", "createTime"));
        if (activityData.get("id") != null) {
            activityDO.setActivityIdV4(Long.valueOf((Integer) activityData.get("id")));
        }
        doV4.setId(activityDO.getId());
        boolean isChanged = BeanUtil.compareObject(activityDO, doV4);
        if (isChanged) {
            resActivityRepo.save(doV4);
        }
    }

    private Long getTaskReasonId(Map<String, Object> taskData, Map<Long, Long> v4AndV5ProjectIds, Map<Long, Long> v4AndV5OppoIds, Map<Long, Long> v4AndV5OrgIds) {
        Long taskReasonId = -1L;
        if (taskData.get("reasonType") != null) {
            String reasonType = (String) taskData.get("reasonType");
            if (taskData.get("reasonId") != null) {
                Long reasonId = Long.valueOf((Integer) taskData.get("reasonId"));
                switch (reasonType) {
                    case "01"://项目
                        taskReasonId = v4AndV5ProjectIds.get(reasonId);
                        break;
                    case "02"://售前(商机id)
                        taskReasonId = v4AndV5OppoIds.get(reasonId);
                        break;
                    case "03"://BU
                        taskReasonId = v4AndV5OrgIds.get(reasonId);
                        break;
                }
            }
        }
        return taskReasonId;
    }


    /**
     * tw4.0翻译成5.0组织员工关系数据
     *
     * @param map               4.0源数据
     * @param orgDataMap        tw4.0和5.0对应关系组织id
     * @param userDataMap       tw4.0和5.0对应关系用户id
     * @param old               变更之前的数据
     * @param orgEmployeeRefDOs 新建或更新的数据容器
     */
    public void translateOrgRefUser(Map<String, Object> map, Map<Long, Long> orgDataMap, Map<Long, Long> userDataMap, Map<String, Long> old, List<PrdOrgEmployeeRefDO> orgEmployeeRefDOs) {
        PrdOrgEmployeeRefDO orgEmployeeRef = new PrdOrgEmployeeRefDO();
        if (old != null) {
            orgEmployeeRef.setId(Long.valueOf(old.get("id") + ""));
        }
        orgEmployeeRef.setIsCopy(0);
        if (!ObjectUtils.isEmpty(map.get("tenantId"))) {
            orgEmployeeRef.setTenantId((Long.valueOf(map.get("tenantId") + "")));
        } else {
            orgEmployeeRef.setTenantId(1L);
        }
//        if (ObjectUtils.isEmpty(userDataMap.get(((Integer) map.get("userId")).longValue()))) {
//            System.out.println(" map.get(\"buId\")::" + map.get("buId"));
//            System.out.println(" map.get(\"buId\")::" + map.get("userId"));
//        }
//        if (ObjectUtils.isEmpty(orgDataMap.get(((Integer) map.get("buId")).longValue()))) {
//            System.out.println(" map.get(\"buId\");::" + map.get("buId"));
//            System.out.println(" map.get(\"buId\");::" + map.get("userId"));
//        }
        orgEmployeeRef.setOrgId(orgDataMap.get(((Integer) map.get("buId")).longValue()));
        orgEmployeeRef.setUserId(userDataMap.get(((Integer) map.get("userId")).longValue()));
        if ((map.get("isBaseBuId") + "").equals("true")) {
            orgEmployeeRef.setIsDefault(0);
        } else {
            orgEmployeeRef.setIsDefault(1);
        }
        if (!ObjectUtils.isEmpty(map.get("puserId"))) {
            orgEmployeeRef.setParentId(userDataMap.get(((Integer) map.get("puserId")).longValue()));
        }
        orgEmployeeRef.setRefIdV4(((Integer) map.get("id")).longValue());
        if (!ObjectUtils.isEmpty(map.get("dateFrom"))) {
            orgEmployeeRef.setJoinDate(LocalDate.parse(map.get("dateFrom") + ""));
        }
        if (!ObjectUtils.isEmpty(map.get("dateTo"))) {
            orgEmployeeRef.setJoinDate(LocalDate.parse(map.get("dateTo") + ""));
        }
        if (!ObjectUtils.isEmpty(map.get("resStatus")) && (map.get("resStatus") + "").equals("INACTIVE")) {
            orgEmployeeRef.setDeleteFlag(1);
        }
        if (orgEmployeeRef.getOrgId() != null && orgEmployeeRef.getUserId() != null) {
            orgEmployeeRefDOs.add(orgEmployeeRef);
        }
    }

    /**
     * tw4.0翻译成5.0组织数据
     *
     * @param map         4.0源数据
     * @param orgList     需要保存的组织数据
     * @param parentMap   组织和上级组织关系存储容器
     * @param userDataMap 负责人数据
     * @param old         变更之前的组织数据
     * @param updateOrgs  需要更新的组织数据容器
     */

    public void translateOrg(Map<String, Object> map, List<PrdOrgOrganizationDO> orgList, Map<Long, Long> parentMap, Map<Long, Long> userDataMap, Map<String, Long> old, List<Long> updateOrgs) {
        PrdOrgOrganizationDO organizationDO = new PrdOrgOrganizationDO();
        if (old != null) {
            organizationDO.setId(Long.valueOf(old.get("id") + ""));
            updateOrgs.add(Long.valueOf(old.get("id") + ""));
        }
        organizationDO.setChangeId(0L);
        organizationDO.setDimensionId(default_dimension_id);
        organizationDO.setOrgIdV4(((Integer) map.get("id")).longValue());
        organizationDO.setOrgName(map.get("buName") == null ? null : map.get("buName") + "");
        organizationDO.setOrgCode(map.get("buNo") == null ? null : map.get("buNo") + "");
        organizationDO.setOrgStatus(map.get("buStatus") == null ? null : map.get("buStatus") + "");
        organizationDO.setIsCopy(0);
        if (((Integer) (map.get("inchargeUserId") == null ? 0 : (map.get("inchargeUserId")))).longValue() != 0) {
            organizationDO.setManageId(userDataMap.get(((Integer) map.get("inchargeUserId")).longValue()));
        }
        if (!ObjectUtils.isEmpty(map.get("pid"))) {

            parentMap.put(((Integer) map.get("id")).longValue(), ((Integer) map.get("pid")).longValue());
        }
        if (!ObjectUtils.isEmpty(map.get("tenantId"))) {
            organizationDO.setTenantId((Long.valueOf(map.get("tenantId") + "")));
        } else {
            organizationDO.setTenantId(1L);
        }

        orgList.add(organizationDO);
    }

    /**
     * 保存用户数据
     *
     * @param map
     * @param shortcutIds
     */
    @Transactional
    public void saveUser(Map<String, Object> map, Map<String, Object> oldUser, String shortcutIds, List<PrdOrgEmployeeDO> employeeDOS, List<PrdSystemUserRoleDO> userRoleDOS, List<PrdOrgPersonDO> personDOS, Map<Long, Long> bookDataMap) {
        boolean enabled = true;
        if ((map.get("isDisabled") + "").equals("1")) {
            enabled = false;
        }
        PrdOrgPersonDO personDO = new PrdOrgPersonDO();
        if (!ObjectUtils.isEmpty(map.get("tenantId"))) {
            personDO.setTenantId((Long.valueOf(map.get("tenantId") + "")));
        } else {
            personDO.setTenantId(1L);
        }

        personDO.setUserName(map.get("personalEmail") + "");
        personDO.setMobile(map.get("mobile") + "");
        personDO.setEnabled(enabled);
        personDO.setEmail(map.get("personalEmail") + "");
        personDO.setPersonName(map.get("resName") == null ? null : map.get("resName") + "");
        personDO.setForeignName(map.get("englishName") == null ? null : map.get("englishName") + "");
        personDO.setIdType(map.get("idType") == null ? null : map.get("idType") + "");
        personDO.setIdNo(map.get("idNo") == null ? null : map.get("idNo") + "");
        if (!ObjectUtils.isEmpty(map.get("idValidFrom"))) {
            personDO.setIdValidFrom(LocalDate.parse(map.get("idValidFrom") + ""));
        }
        if (!ObjectUtils.isEmpty(map.get("idValidTo"))) {
            personDO.setIdValidTo(LocalDate.parse(map.get("idValidTo") + ""));
        }
        personDO.setIdValidCodes("");
        if (!ObjectUtils.isEmpty(map.get("birthday"))) {
            personDO.setBirthday(LocalDate.parse(map.get("birthday") + ""));
        }
        personDO.setSex(map.get("resGender") == null ? null : map.get("resGender") + "");
//        personDO.setNationality(map.get("nationality") == null ? null : map.get("nationality") + "");
        personDO.setNationality("中国");
        personDO.setBirthplace(map.get("birthplace") == null ? null : map.get("birthplace") + "");
        personDO.setNation(map.get("nation") == null ? null : map.get("nation") + "");
        Integer marital = null;
        if ((map.get("marital") + "").equals("MARRIED")) {
            marital = 0;
        }
        if ((map.get("marital") + "").equals("UNMARRIED")) {
            marital = 1;
        }
        personDO.setMarital(marital);
        String addr = "";
        if (map.get("contactProvinceName") != null) {
            addr += map.get("contactProvinceName");
        }
        if (map.get("contactCityName") != null) {
            addr += map.get("contactCityName");
        }
        if (map.get("contactDistrict") != null) {
            addr += map.get("contactDistrict");
        }
        if (map.get("contactAddress") != null) {
            addr += map.get("contactAddress");
        }
        personDO.setAddr(addr);
        personDO.setUrgency_name(map.get("emContactName") == null ? null : map.get("emContactName") + "");
        personDO.setUrgency_mobile(map.get("emContactMobile") == null ? null : map.get("emContactMobile") + "");
        personDO.setUrgency_ref(map.get("emContactRelation") == null ? null : map.get("emContactRelation") + "");

        PrdOrgEmployeeDO ado = new PrdOrgEmployeeDO();
        if (oldUser == null) {
            SysUserRpcSaveParam param = new SysUserRpcSaveParam();
            param.setTenantId(personDO.getTenantId());
            param.setUsername(map.get("personalEmail") == null ? null : map.get("personalEmail") + "");
            param.setPassword(default_password);
            param.setLastName("");
            param.setFirstName(map.get("accName") == null ? null : map.get("accName") + "");
            param.setMobile(map.get("mobile") + "");
            param.setEmail(map.get("personalEmail") + "");
            param.setEnabled(enabled);
            param.setRoleIds(new ArrayList<>());
            param.setDataRoleIds(new ArrayList<>());
            param.setFlowRoleIds(new ArrayList<>());
            param.setSourceType("sys");
            param.setTerminals(new HashSet<>());
            ApiResult<Object> obj = sysUserService.sysUserAccountCreate(param);
            log.info("【人员同步：创建用户返回结果：{}】", obj);
            Long userId = Long.valueOf(obj.getData() + "");
            String wecom = qyWxCommunicationService.getQyWxuserid(map.get("mobile") + "");
            ado.setWecomId(wecom);
            ado.setUserId(userId);

            PrdSystemUserRoleDO roleDO = new PrdSystemUserRoleDO();
            roleDO.setRoleId(default_role_id);
            roleDO.setTenantId(personDO.getTenantId());
            roleDO.setUserId(userId);
            userRoleDOS.add(roleDO);

            personDO = daoEmployee.savePerson(personDO);
            log.info("【人员同步：创建自然人：{}】", personDO);
        } else {
            if (!(map.get("personalEmail") + "").equals(oldUser.get("email") + "") || !(map.get("accName") + "").equals(oldUser.get("employeeName") + "") || !(map.get("mobile") + "").equals(oldUser.get("mobile") + "") || (enabled != Boolean.valueOf(oldUser.get("enabled") + ""))) {
                SysUserUpdateParam param = new SysUserUpdateParam();
                param.setEmail(map.get("personalEmail") + "");
                param.setEnabled(enabled);
                param.setId(Long.valueOf(oldUser.get("userId") + ""));
                param.setLastName("");
                param.setFirstName(map.get("accName") + "");
                param.setMobile(map.get("mobile") + "");
                sysUserService.update(param);
            }
            ado.setUserId(Long.valueOf(oldUser.get("userId") + ""));
            ado.setId(Long.valueOf(oldUser.get("id") + ""));
            if (oldUser.get("wecomId") != null) {
                ado.setWecomId(oldUser.get("wecomId") + "");
            }
            personDO.setId(Long.valueOf(oldUser.get("personId") + ""));
            personDOS.add(personDO);
        }
        ado.setTenantId(personDO.getTenantId());
        ado.setPersonId(personDO.getId());
        ado.setUserIdV4(((Integer) map.get("userId")).longValue());
        if (map.get("ouAbId") != null) {
            ado.setCompanyId(bookDataMap.get(((Integer) map.get("ouAbId")).longValue()));
        }
        ado.setEmployeeNo(map.get("empNo") == null ? null : map.get("empNo") + "");
        ado.setEmployeeName(map.get("accName") + "");
        ado.setResourceStatus(map.get("resStatus") == null ? null : map.get("resStatus") + "");
        ado.setHrStatus(map.get("hrStatus") == null ? null : map.get("hrStatus") + "");
        ado.setDeleteFlag((Integer) map.get("delFlag"));
        if (!ObjectUtils.isEmpty(map.get("enrollDate"))) {
            ado.setEnrollDate(LocalDate.parse(map.get("enrollDate") + ""));
        }
        ado.setAccessLevel((Integer) map.get("accessLevel"));
        ado.setJobs(map.get("job") == null ? null : map.get("job") + "");
        ado.setShortcutIds(shortcutIds);
        ado.setEqvaRatio(map.get("eqvaRatio") == null ? BigDecimal.ZERO : new BigDecimal(map.get("eqvaRatio") + ""));
        ado.setExtString1(map.get("jobGrade") == null ? null : map.get("jobGrade") + "");
        ado.setExtString2(map.get("managementGrade") == null ? null : map.get("managementGrade") + "");
        ado.setExtString3(map.get("professionalSequence") == null ? null : map.get("professionalSequence") + "");
        ado.setExtString4(map.get("positionSequence") == null ? null : map.get("positionSequence") + "");
        ado.setExtString5(map.get("baseCity") == null ? null : map.get("baseCity") + "");
        ado.setExtString6(map.get("resType1") == null ? null : map.get("resType1") + "");
        ado.setExtString7(map.get("telfeeQuota") == null ? null : map.get("telfeeQuota") + "");
        ado.setExtString8(map.get("compfeeQuota") == null ? null : map.get("compfeeQuota") + "");
        ado.setExtString9(map.get("resType2") == null ? null : map.get("resType2") + "");
//        if (!ObjectUtils.isEmpty(map.get("enrollDate"))) {
//            ado.setExtDate1(LocalDate.parse(map.get("enrollDate") + ""));
        ado.setExtDate1(null);
//        }

        if (!ObjectUtils.isEmpty(map.get("regularDate"))) {
            ado.setExtDate2(LocalDate.parse(map.get("regularDate") + ""));
        }
        if (!ObjectUtils.isEmpty(map.get("contractSignDate"))) {
            ado.setExtDate3(LocalDate.parse(map.get("contractSignDate") + ""));
        }
        if (!ObjectUtils.isEmpty(map.get("contractExpireDate"))) {
            ado.setExtDate4(LocalDate.parse(map.get("contractExpireDate") + ""));
        }
        if (!ObjectUtils.isEmpty(map.get("internDate"))) {
            ado.setExtDate5(LocalDate.parse(map.get("internDate") + ""));
        }
        if (!ObjectUtils.isEmpty(map.get("probationBeginDate"))) {
            ado.setExtDate6(LocalDate.parse(map.get("probationBeginDate") + ""));
        }
        if (!ObjectUtils.isEmpty(map.get("probationEndDate"))) {
            ado.setExtDate7(LocalDate.parse(map.get("probationEndDate") + ""));
        }

        employeeDOS.add(ado);
        //  ado = daoEmployee.save(ado);
//        if (oldUser == null) {
//            PrdSystemUserRoleDO roleDO = new PrdSystemUserRoleDO();
//            roleDO.setRoleId(default_role_id);
//            roleDO.setUserId(ado.getUserId());
//            daoEmployee.saveUserRole(roleDO);
//        }
    }


    //获取默认快捷入口
    String getDefultShortcut() {
        List<Long> shortcutIds = daoEmployee.getShortcuts(shortcutSize);
        return org.apache.commons.lang3.StringUtils.join(shortcutIds.toArray(), ",");
    }

}
