package com.elitesland.tw.tw5.server.prd.system.controller;

import com.elitesland.tw.tw5.api.prd.system.payload.PrdFsmFileRefPayload;
import com.elitesland.tw.tw5.api.prd.system.query.PrdFsmFileRefQuery;
import com.elitesland.tw.tw5.api.prd.system.service.PrdFsmFileRefService;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdFsmFileRefVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitescloud.cloudt.common.base.PagingVO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;

/**
 * 附件业务关系表
 *
 * @author duwh
 * @date 2022/11/23
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/system")
@Slf4j
public class PrdFsmFileRefController {

    private final PrdFsmFileRefService service;

    /**
     * 新增
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping("/fmsFileRef")
    public TwOutputUtil insert(PrdFsmFileRefPayload payload) {
        return TwOutputUtil.ok(service.insert(payload));
    }


    /**
     * 更新
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping("/fmsFileRef")
    public TwOutputUtil update(PrdFsmFileRefPayload payload) {
        return TwOutputUtil.ok(service.update(payload));
    }

    /**
     * 主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/fmsFileRef/{key}")
    //@UdcNameClass
    public TwOutputUtil queryOneByKey(@PathVariable Long key) {
        PrdFsmFileRefVO vo = service.queryByKey(key);
        return TwOutputUtil.ok(vo);
    }

    /**
     * 分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/fmsFileRef/paging")
    //@UdcNameClass
    public TwOutputUtil paging(PrdFsmFileRefQuery query) {
        PagingVO<PrdFsmFileRefVO> paging = service.paging(query);
        return TwOutputUtil.ok(paging);
    }

    /**
     * 查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/fmsFileRef/list")
    //@UdcNameClass
    public TwOutputUtil queryList(PrdFsmFileRefQuery query) {
        List<PrdFsmFileRefVO> vos = service.queryList(query);
        return TwOutputUtil.ok(vos);
    }

    /**
     * 删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/fmsFileRef/deleteSoft")
    public TwOutputUtil deleteSoft(Long[] keys) {
        service.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    /**
     * 根据fileCode删除
     *
     * @param fileCode fileCode
     * @return result
     */
    @DeleteMapping("/fmsFileRef/deleteSoftByFileCode")
    public TwOutputUtil deleteSoftByFileCode(String fileCode) {
        service.deleteSoftByFileCode(fileCode);
        return TwOutputUtil.ok();
    }

}
