package com.elitesland.tw.tw5.server.prd.workflow;

import com.elitesland.tw.tw5.api.common.change.service.PrdSystemBusinessChangeService;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmActPlanPayload;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmActPlanService;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmActPlanDetailVO;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmActPlanVO;
import com.elitesland.tw.tw5.server.common.change.changeEnum.ChangeTypeEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.WorkFlowStatusEnum;
import com.elitesland.tw.tw5.server.prd.crm.dao.CrmActPlanDAO;
import com.elitesland.workflow.WorkflowCallBack;
import com.elitesland.workflow.WorkflowConstant;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.workflow.payload.ProcessStatusChangePayload;
import com.elitesland.workflow.payload.TaskAssigneePayload;
import com.elitesland.workflow.payload.TaskCompletedPayload;
import com.elitesland.workflow.payload.TaskCreatedPayload;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * @author yangzhibin
 * @date 2022/12/16
 */
@Slf4j
@RestController
@RequestMapping(WorkflowConstant.WORKFLOW + "MARKET_PLAN" + WorkflowConstant.CALLBACK)
@Transactional
@RequiredArgsConstructor
public class MarketPlanWorkflowCallBackController implements WorkflowCallBack {

    private final CrmActPlanDAO actPlanDAO;
    private final PrdSystemBusinessChangeService changeService;
    private final CrmActPlanService actPlanService;

    /**
     * 动态指定任务负责人
     *
     * @return 任务负责人ID列表
     */
    @Override
    @PostMapping(WorkflowConstant.TASK_ASSIGNEE_PATH)
    public ArrayList<String> taskAssignee(@RequestBody TaskAssigneePayload payload) {
        log.info("动态指定任务负责人参数: {}", payload);
        return null;
    }

    /**
     * 任务创建回调
     *
     */
    @Override
    @PostMapping(WorkflowConstant.TASK_CREATED_PATH)
    public void taskCreated(@RequestBody TaskCreatedPayload payload) {
        log.info("任务创建后回调参数: {}", payload);
    }

    /**
     * 任务完成回调(只有正常推下一个节点,才算任务完成,其他从当前任务撤回/驳回都能不算当前任务完成,不会触发下面回调)
     *
     */
    @Override
    @PostMapping(WorkflowConstant.TASK_COMPLETED_PATH)
    public void taskCompleted(@RequestBody TaskCompletedPayload payload) {
        log.info("任务完成后回调参数: {}", payload);
    }

    /**
     * 流程状态变化回调
     *
     */
    @Override
    @PostMapping(WorkflowConstant.PROCESS_STATUS_CHANGE_PATH)
    public void processStatusChange(@RequestBody ProcessStatusChangePayload payload) {
        log.info("流程状态变化回调参数:{}", payload);
        String businessKey = payload.getBusinessKey();
        ProcInstStatus procInstStatus = payload.getProcInstStatus();
        CrmActPlanPayload actPlanPayload = new CrmActPlanPayload();
        actPlanPayload.setId(Long.parseLong(businessKey));
        //根据业务key查询当前业务对象
        CrmActPlanVO crmActPlanVO = actPlanService.queryByKey(Long.valueOf(businessKey));
        if (crmActPlanVO != null) {
            switch (procInstStatus) {
                case NOTSUBMIT://创建人提交节点
                    //一般情况将单据状态变成"新建",流程状态改为未提交
                    actPlanPayload.setPlanStatus(WorkFlowStatusEnum.CREATE_WORK.getCode());
                    actPlanPayload.setProcInstStatus(ProcInstStatus.NOTSUBMIT);
                    break;
                case INTERRUPT://中断（删除工作流，初始化单据，管理员操作）
                    //一般情况将单据状态变成"新建",并且将单据上的"流程实例状态"，"流程实例ID"清成null
                    actPlanPayload.setPlanStatus(WorkFlowStatusEnum.CREATE_WORK.getCode());
                    actPlanPayload.setNullFields(Arrays.asList("procInstStatus", "procInstId", "submitTime"));
                    break;
                case INVALID://先删除流程再删除单据
                    actPlanPayload.setPlanStatus(WorkFlowStatusEnum.INVALID.getCode());
                    actPlanPayload.setDeleteFlag(1);
                    actPlanPayload.setProcInstStatus(ProcInstStatus.INVALID);
                    break;
                case REJECTED://审批人拒绝，回到第一个节点
                    //将单据状态变为新建状态
                    actPlanPayload.setPlanStatus(WorkFlowStatusEnum.CREATE_WORK.getCode());
                    actPlanPayload.setProcInstStatus(ProcInstStatus.REJECTED);
                    break;
                case APPROVED:
                    //TODO:这里需要一个事务
                    //一般情况将单据状态变成"激活"
                    actPlanPayload.setPlanStatus(WorkFlowStatusEnum.APPROVED_WORK.getCode());
                    actPlanPayload.setProcInstStatus(ProcInstStatus.APPROVED);
                    actPlanPayload.setApprovedTime(LocalDateTime.now());
                    actPlanDAO.updateByKeyDynamic(actPlanPayload);
                    //重新查询
                    crmActPlanVO = actPlanService.queryByKey(Long.valueOf(businessKey));
                    //保存一个版本的初始数据
                    //保存主表changeLog
                    changeService.saveNewLog(ChangeTypeEnum.MARKET_PLAN.getCode(), crmActPlanVO, null, null, 1);
                    //保存子表changeLog
                    List<CrmActPlanDetailVO> crmActPlanDetailVOS = actPlanService.queryDetails(crmActPlanVO.getId(), null);
                    for (CrmActPlanDetailVO crmActPlanDetailVO : crmActPlanDetailVOS) {
                        changeService.saveNewLog(ChangeTypeEnum.MARKET_PLAN_DETAIL.getCode(), crmActPlanDetailVO, ChangeTypeEnum.MARKET_PLAN.getCode(), crmActPlanVO.getId().toString(), 1);
                    }
                    break;
                case APPROVING:
                    actPlanPayload.setProcInstStatus(ProcInstStatus.APPROVING);
                    actPlanPayload.setPlanStatus(WorkFlowStatusEnum.APPROVING_WORK.getCode());
            }
            if (!procInstStatus.equals(ProcInstStatus.APPROVED)) {
                actPlanDAO.updateByKeyDynamic(actPlanPayload);
            }
        }
    }

}
