package com.elitesland.tw.tw5.server.sso.controller;

import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitesland.tw.tw5.api.prd.my.service.PrdUserService;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.yeedoc.config.YeedocProperties;
import com.elitesland.tw.tw5.server.yeedoc.service.YeedocService;
import io.swagger.annotations.Api;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.HashMap;
import java.util.Map;

/**
 * yeedoc易稻壳
 *
 * @author duwh
 * @date 2022/11/09
 */
@Api("yeedoc易稻壳SSO")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/yeedocx/sso")
@Slf4j
public class YeedocSsoController {

    private final PrdUserService prdUserService;

    private final YeedocService yeedocService;

    private final YeedocProperties yeedocProperties;


    /**
     * 校验ticket合法性
     *
     * 重复see com.elitesland.tw.tw5crm.server.prd.my.controller.PrdUserController#queryUserByTicket(javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
     *
     * @param request  请求
     * @param response 响应
     */
    @GetMapping({"/authc/pc"})
    public void yePcLogin(HttpServletRequest request, HttpServletResponse response) {
        String ticket = request.getParameter("ticket");
        log.info("----------------------------------------");
        log.info("ticket:{}", ticket);
        prdUserService.queryUserByTicket(request, response);
    }

    /**
     * 单点登录获取易稻壳token和url
     *
     */
    @GetMapping({"/getTokenAndUrl"})
    public TwOutputUtil yeeDocLogin() {
        SysUserDTO loginUser = GlobalUtil.getLoginUser();
        String yeedocJwt = yeedocService.getYeedocJwt(loginUser);
        log.info(loginUser.getFirstName()+"调用易稻壳的jwt签名为："+yeedocJwt);
        Map resultMap = new HashMap<>();
        resultMap.put("yeedocJwt",yeedocJwt);
        resultMap.put("yeedocSsoUrl",yeedocProperties.getYeedocSsoUrl());
        resultMap.put("yeedocSource",yeedocProperties.getSource());
        return TwOutputUtil.ok(resultMap);
    }
}
