package com.elitesland.tw.tw5.server.yeedoc.config;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * yeedoc属性
 *
 * @author duwh
 * @date 2022/11/15
 */
@Data
@ConfigurationProperties("yeedoc")
public class YeedocProperties {

    /**
     * 易稻壳api地址
     * 测试环境：http://192.168.0.92
     * 生产环境：https://yeedoc.elitesland.com
     */
    private String yeeDocLinkUrl = "http://192.168.0.92";
    /**
     * 易稻壳识别标识
     * 测试环境 testshow
     * 生产环境 tw5
     */
    private String externalSource = "testshow";

    /**
     * 商机文档导入 相关配置
     */
    private CrmOpportunityFolder oppoFolder = new CrmOpportunityFolder();
    /**
     * 单点登录调用易稻壳的加密key
     */
    private String sercretKey ;
    /**
     * 单点登录跳转易稻壳的url
     */
    private String yeedocSsoUrl ;

    /**
     * 调用易稻壳传的系统来源
     */
    private String source ;
    public YeedocProperties() {
    }
}
