package com.elitesland.tw.tw5.server.yeedoc.service;

import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitesland.tw.tw5.server.yeedoc.dto.CreateFolderDTO;

import java.util.Map;

/**
 * yeedoc服务
 *
 * @author duwh
 * @date 2022/11/10
 */
public interface YeedocService {

    /**
     * 创建文件夹
     *
     * @param map 地图
     * @return {@link String}
     */
    String createFolder(Map<String, Object> map);

    /**
     * 创建文件夹
     *
     * @param createFolderDTO 创建文件夹dto
     * @return {@link String}
     */
    String createFolder(CreateFolderDTO createFolderDTO);

    /**
     * 设置权限
     *
     * @param itemId          项id
     * @param permissionLevel 权限级别
     * @return {@link String}
     */
    String setPermission(String itemId, Integer permissionLevel);

    /**
     * 获取文件链接uri
     *
     * @param itemId 项id
     * @return {@link String}
     */
    String preViewItem(String itemId);

    /**
     * 删除项目
     *
     * @param itemId 项id
     * @return {@link String}
     */
    String deleteItem(String itemId);

    /**
     * 通过用户信息生成易稻壳的jwt
     *
     * @param  loginUser
     */
    String getYeedocJwt(SysUserDTO loginUser);
}
