package com.elitesland.tw.tw5crm.server.common.change.contorller;

import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5crm.api.common.change.query.ComBusinessChangeQuery;
import com.elitesland.tw.tw5crm.api.common.change.service.ComBusinessChangeService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.*;

/**
 * @author carl
 */
@Api(tags = "通用变更信息")
@RestController
@RequestMapping("/api/com/businessChange")
@RequiredArgsConstructor
public class ComBusinessChangeController {

    private final ComBusinessChangeService service;

    /**
     * 变更历史
     *
     * @param query 查询条件
     * @return ApiResult
     */
    @PostMapping("/changeHistory")
    @ApiOperation("变更历史")
    public TwOutputUtil changeHistory(@RequestBody ComBusinessChangeQuery query) {
        return TwOutputUtil.ok(service.changeSearch(query));
    }


    /**
     * 数据比对
     *
     * @param id        比较目标值id
     * @param compareId 比较值id
     * @return dataStatus 1:表示被删除的数据，2：表示新增数据
     */
    @ApiOperation("数据比对")
    @GetMapping("/getCompareChange")
    public TwOutputUtil getCompareChange(Long id, Long compareId) {
        return TwOutputUtil.ok(service.getCompareChange(id, compareId));
    }
}
