package com.elitesland.tw.tw5crm.server.common.change.entity;


import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.cloudt.common.base.BaseModel;
import com.elitesland.workflow.enums.ProcInstStatus;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.hibernate.annotations.Where;

import javax.persistence.*;
import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * 通用变更信息表(com_business_change)实体类
 *
 * @author carl
 */

@Entity
@Table(name = "com_business_change")
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@org.hibernate.annotations.Table(appliesTo = "com_business_change", comment = "通用变更信息表")
@Where(clause = "delete_flag= 0")
public class ComBusinessChangeDO extends BaseModel implements Serializable {
    private static final long serialVersionUID = 1L;

    @Column()
    @Comment("变更类型")
    private String changeType;

    @Column()
    @Comment("变更信息")
    private String changeContent;

    @Column()
    @Comment("变更单据id")
    private String changeDocId;

    @Column()
    @Comment("版本号")
    private Integer versionNo;

    @Column()
    @Comment("变更状态")
    private String changeStatus;

    /**
     * 流程状态 see procInstStatus
     */
    @Comment("流程状态")
    @Column()
    @Deprecated
    private String apprStatus;

    /**
     * 流程实例ID see procInstId
     */
    @Comment("流程实例ID")
    @Column()
    @Deprecated
    private String apprProcInstId;

    /** 流程实例ID */
    @Comment("流程实例ID")
    @Column()
    private String procInstId;
    @Column
    @Comment("流程实例状态")
    @Enumerated(EnumType.STRING)
    private ProcInstStatus procInstStatus;
    /** 提交时间 */
    @Comment("提交时间")
    @Column()
    private LocalDateTime submitTime;
    /** 审批时间 */
    @Comment("审批时间")
    @Column()
    private LocalDateTime approvedTime;

}

