package com.elitesland.tw.tw5crm.server.common.change.repo;


import com.elitesland.tw.tw5crm.server.common.change.entity.ComBusinessChangeDO;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * @author carl
 */
@Repository
public interface ComBusinessChangeRepo extends JpaRepository<ComBusinessChangeDO, Long>, QuerydslPredicateExecutor<ComBusinessChangeDO> {
    /**
     * 查询变更记录
     *
     * @return list 实体
     */
    List<ComBusinessChangeDO> findByDeleteFlagAndChangeTypeAndChangeDocId(Integer deleteFlag, String changeType, String changeDocId);

    /**
     * @param deleteFlag
     * @param changeType
     * @param changeDocId
     * @param versionNo
     * @return
     */
    ComBusinessChangeDO findByDeleteFlagAndChangeTypeAndChangeDocIdAndVersionNo(Integer deleteFlag, String changeType, String changeDocId, Integer versionNo);

    /**
     * @param deleteFlag
     * @param changeType
     * @param changeDocId
     * @return
     */
    Long countByDeleteFlagAndChangeTypeAndChangeDocId(Integer deleteFlag, String changeType, String changeDocId);
//
//    ComBusinessChangeDO findByDeleteFlagAndId(Integer deleteFlag, Long id);
//
//    /**
//     * 删除所有变更
//     *
//     * @param id
//     */
//    @Query(value = "update ComBusinessChangeDO  set deleteFlag = 1  where id = ?1")
//    @Modifying
//    void delBusinessChangeById(Long id);
//
//    /**
//     * 修改变更记录的流程实例id
//     *
//     * @param apprProcInstId
//     * @param ids
//     */
//    @Query(value = "update ComBusinessChangeDO  set apprProcInstId = ?1 where id in (?2)")
//    @Modifying
//    void updateBusinessChangeApprProcInstId(String apprProcInstId, List<Long> ids);

}
