package com.elitesland.tw.tw5crm.server.common.constants;

import lombok.Getter;

/**
 * 开票状态枚举
 * udc[CRM:CONTRACT:BILLING_STATUS] 开票中、已开票、已作废
 *
 * @author wangly
 * @date 2023-04-25
 */
public enum ContractBillingApplyStatusEnum {
    BILLING("BILLING", "开票中"),
    INVOICED("INVOICED", "已开票"),
    VOIDED("VOIDED", "已作废");

    @Getter
    private final String code;
    @Getter
    private final String desc;

    ContractBillingApplyStatusEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }
}
