package com.elitesland.tw.tw5crm.server.common.constants;

import lombok.Getter;


/**
 * 合同收款计划 收款状态
 * udc[CRM:CONTRACT:COLLECTION_STATUS]未收款、部分收款、已完成
 *
 * @author duwh
 * @date 2023/05/04
 */
public enum ContractCollectionPlanPlanStatus {

    NO("NO", "未收款"),
    PART("PART", "部分收款"),
    OK("OK", "已完成")
    ;
    @Getter
    private final String code;
    @Getter
    private final String desc;

    ContractCollectionPlanPlanStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }
}
