package com.elitesland.tw.tw5crm.server.common.constants;

import lombok.Getter;

/**
 * Created with IntelliJ IDEA.
 *
 * @Author: kola
 * @Date: 2023/04/06
 */
public enum SaleTargetExamTargetEnum {

    // 人员目标
    USER_VISIT("crm:goal:goal_type:USER:VISIT", "拜访数(个)"),
    USER_CLUE("crm:goal:goal_type:USER:CLUE", "线索数A(个)"),
    USER_BUSINESS("crm:goal:goal_type:USER:BUSINESS", "商机金额(元)"),
    USER_CONTRACT("crm:goal:goal_type:USER:CONTRACT", "合同额(元)"),
    USER_CUSTOMER("crm:goal:goal_type:USER:CUSTOMER", "客户数(个)"),

    // 客户目标
    CUSTOMER_CONTRACT("crm:goal:goal_type:CUSTOMER:CONTRACT", "合同额(元)"),
    CUSTOMER_VISIT("crm:goal:goal_type:CUSTOMER:VISIT", "拜访数(个)"),
    CUSTOMER_PAYMENT("crm:goal:goal_type:CUSTOMER:PAYMENT", "回款额(元)"),

    //产品目标
    PRODUCT_SALE("crm:goal:goal_type:PRODUCT:SALE", "销售量(个)"),
    PRODUCT_CONTRACT("crm:goal:goal_type:PRODUCT:CONTRACT", "合同额(元)");

    @Getter
    private final String code;
    @Getter
    private final String desc;

    SaleTargetExamTargetEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }
}
