package com.elitesland.tw.tw5crm.server.common.constants;

import lombok.Getter;

/**
 * 销售拜访 拜访计划类型
 * 任务状态 udc[crm:visit:task_plan:type](访销计划 sell_visit_plan、周期计划 periodic_plan、常规计划 general_plan)
 *
 * @author duwh
 * @date 2023/03/13
 */
public enum VisitTaskPlanTypeEnum {

    general_plan("general_plan", "常规计划"),
    periodic_plan("periodic_plan", "周期计划"),
    sell_visit_plan("sell_visit_plan", "访销计划");

    @Getter
    private final String code;
    @Getter
    private final String desc;

    VisitTaskPlanTypeEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }
}
