package com.elitesland.tw.tw5crm.server.common.constants;

import lombok.Getter;

/**
 * 销售拜访 任务状态
 * 任务状态 udc[crm:visit:task_status](已完成OK、待提交READY、未开始NEW)
 *
 * @author duwh
 * @date 2023/03/13
 */
public enum VisitTaskStatusEnum {

    NEW("NEW", "未开始"),
    READY("READY", "待提交"),
    OK("OK", "已完成");


    @Getter
    private final String code;
    @Getter
    private final String desc;

    VisitTaskStatusEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }
}
