package com.elitesland.tw.tw5crm.server.contract.controller;

import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import com.elitesland.tw.tw5crm.api.contract.payload.ContractBillingApplyPayload;
import com.elitesland.tw.tw5crm.api.contract.query.ContractBillingApplyQuery;
import com.elitesland.tw.tw5crm.api.contract.service.ContractBillingApplyService;
import com.elitesland.tw.tw5crm.api.contract.vo.ContractBillingApplyVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;

/**
 * 合同管理-开票申请
 *
 * @author wangly
 * @date 2023-04-25
 */
@Api(tags = "合同管理-开票申请")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/crm/contract/billingApply")
@Slf4j
public class ContractBillingApplyController {

    private final ContractBillingApplyService contractBillingApplyService;

    /**
     * 新增
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("新增开票申请")
    public TwOutputUtil insert(@RequestBody ContractBillingApplyPayload payload){
        return TwOutputUtil.ok(contractBillingApplyService.insert(payload));
    }

    /**
     * 更新
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping
    @ApiOperation("更新")
    public TwOutputUtil update(@RequestBody ContractBillingApplyPayload payload){
        return TwOutputUtil.ok(contractBillingApplyService.update(payload));
    }

    /**
     * patch
     *
     * @param payload 发票录入
     * @return {@link TwOutputUtil}
     */
    @PostMapping("/invoiceEntry")
    @ApiOperation("发票录入")
    public TwOutputUtil invoiceEntry(@RequestBody ContractBillingApplyPayload payload){
        contractBillingApplyService.invoiceEntry(payload);
        return TwOutputUtil.ok();
    }
    /**
     * 开票详情查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/queryBillingInfoById/{key}")
    @UdcNameClass
    @ApiOperation("开票详情查询")
    public TwOutputUtil<ContractBillingApplyVO> queryBillingInfoById(@PathVariable Long key) {
        return  TwOutputUtil.ok(contractBillingApplyService.queryBillingInfoById(key));
    }

    /**
     * 主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
     @UdcNameClass
    @ApiOperation("主键查询")
    public TwOutputUtil queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(contractBillingApplyService.queryByKey(key));
    }

    /**
     * 分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    @UdcNameClass
    @ApiOperation("分页")
    public TwOutputUtil paging(ContractBillingApplyQuery query) {
        return TwOutputUtil.ok(contractBillingApplyService.queryPaging(query));
    }

    /**
     * 查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    // @UdcNameClass
    @ApiOperation("查询列表")
    public TwOutputUtil queryList(ContractBillingApplyQuery query) {
        return TwOutputUtil.ok(contractBillingApplyService.queryListDynamic(query));
    }

    /**
     * 删除
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
        contractBillingApplyService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }
    /**
     * patch
     *
     * @param keys 开票
     * @return {@link TwOutputUtil}
     */
    @PostMapping("/cancleInvoice")
    @ApiOperation("发票作废")
    public TwOutputUtil cancleInvoice(@RequestBody  String[]  keys){
        contractBillingApplyService.cancleInvoice(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }
}
