package com.elitesland.tw.tw5crm.server.contract.controller;

import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5crm.api.contract.payload.ContractBillingDetailPayload;
import com.elitesland.tw.tw5crm.api.contract.query.ContractBillingDetailQuery;
import com.elitesland.tw.tw5crm.api.contract.query.ContractInvoiceBillingDetailQuery;
import com.elitesland.tw.tw5crm.api.contract.service.ContractBillingDetailService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;

/**
 *  合同管理-开票明细
 *
 * @author wangly
 * @date 2023-04-25
 */
@Api(tags = "合同管理-开票明细")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/crm/contract/billingDetail")
@Slf4j
public class ContractBillingDetailController {

    private final ContractBillingDetailService contractBillingDetailService;

    /**
     * 新增
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("新增")
    public TwOutputUtil insert(@RequestBody ContractBillingDetailPayload payload){
        return TwOutputUtil.ok(contractBillingDetailService.insert(payload));
    }

    /**
     * 更新
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping
    @ApiOperation("更新")
    public TwOutputUtil update(@RequestBody ContractBillingDetailPayload payload){
        return TwOutputUtil.ok(contractBillingDetailService.update(payload));
    }

    /**
     * 主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    // @UdcNameClass
    @ApiOperation("主键查询")
    public TwOutputUtil queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(contractBillingDetailService.queryByKey(key));
    }

    /**
     * 分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    // @UdcNameClass
    @ApiOperation("分页")
    public TwOutputUtil paging(ContractBillingDetailQuery query) {
        return TwOutputUtil.ok(contractBillingDetailService.queryPaging(query));
    }

    /**
     * 查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    // @UdcNameClass
    @ApiOperation("查询列表")
    public TwOutputUtil queryList(ContractBillingDetailQuery query) {
        return TwOutputUtil.ok(contractBillingDetailService.queryListDynamic(query));
    }

    /**
     * 查询列表
     *
     * @param query 发票管理首页开票明细查询 因需求原因页面查询为申请列表
     * @return {@link TwOutputUtil}
     */
//    @GetMapping("/queryInvoiceBillingDetailList")
//     @UdcNameClass
//    @ApiOperation("发票管理首页开票明细查询")

    public TwOutputUtil queryBillingDetailList(ContractInvoiceBillingDetailQuery query) {
        query.setCreateUserId(GlobalUtil.getLoginUser().getId());
        return TwOutputUtil.ok(contractBillingDetailService.queryBillingDetailList(query));
    }

    /**
     * 删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
        contractBillingDetailService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

}
