package com.elitesland.tw.tw5crm.server.contract.controller;

import com.alibaba.fastjson.JSONObject;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import com.elitesland.tw.tw5crm.api.contract.payload.ContractCollectionPlanPayload;
import com.elitesland.tw.tw5crm.api.contract.query.ContractCollectionPlanQuery;
import com.elitesland.tw.tw5crm.api.contract.service.ContractCollectionPlanService;
import com.elitesland.tw.tw5crm.api.contract.vo.ContractCollectionPlanSimpleVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 合同管理-合同收款计划
 *
 * @author duwh
 * @date 2023-04-24
 */
@Api(tags = "合同管理-合同收款计划")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/crm/contract/collectionPlan")
@Slf4j
public class ContractCollectionPlanController {

    private final ContractCollectionPlanService contractCollectionPlanService;

    /**
     * 新增
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("新增")
    public TwOutputUtil insert(@RequestBody ContractCollectionPlanPayload payload){
        return TwOutputUtil.ok(contractCollectionPlanService.insert(payload));
    }

    /**
     * 更新
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping
    @ApiOperation("更新")
    public TwOutputUtil update(@RequestBody ContractCollectionPlanPayload payload){
        return TwOutputUtil.ok(contractCollectionPlanService.update(payload));
    }

    /**
     * 主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    @UdcNameClass
    @ApiOperation("主键查询")
    public TwOutputUtil queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(contractCollectionPlanService.queryByKey(key));
    }

    /**
     * 分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    @UdcNameClass
    @ApiOperation("分页")
    public TwOutputUtil paging(ContractCollectionPlanQuery query) {
        return TwOutputUtil.ok(contractCollectionPlanService.queryPaging(query));
    }

    /**
     * 查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    @UdcNameClass
    @ApiOperation("查询列表")
    public TwOutputUtil queryList(ContractCollectionPlanQuery query) {
        return TwOutputUtil.ok(contractCollectionPlanService.queryListDynamic(query));
    }

    /**
     * 收款计划下拉选择
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/listSimple")
//    @UdcNameClass
    @ApiOperation("收款计划下拉选择")
    public TwOutputUtil listSimple(ContractCollectionPlanQuery query) {
        return TwOutputUtil.ok(contractCollectionPlanService.queryListDynamicSimple(query));
    }

    /**
     * 删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
        contractCollectionPlanService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    /**
     * 通过收款计划id查询收款计划明细
     *
     * @param jsonObject 主键id 逗号分割
     * @return result
     */
    @PostMapping("/queryListByPlanId")
    @UdcNameClass
    @ApiOperation("通过收款计划id查询收款计划明细")
    public TwOutputUtil<ContractCollectionPlanSimpleVO> queryListByPlanId(@RequestBody JSONObject jsonObject) {
        String id = jsonObject.getString("id");
        String [] planIdArray = id.split(",");
        List<Long> planIdList =  Arrays.stream(planIdArray).map(planId-> Long.valueOf(planId)).collect(Collectors.toList());
        List<ContractCollectionPlanSimpleVO> contractCollectionPlanSimpleVOList = contractCollectionPlanService.queryListByContractId(planIdList);
        return TwOutputUtil.ok(contractCollectionPlanSimpleVOList);
    }
}
