package com.elitesland.tw.tw5crm.server.contract.controller;

import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import com.elitesland.tw.tw5crm.api.contract.payload.ContractPayload;
import com.elitesland.tw.tw5crm.api.contract.payload.ContractSignPayload;
import com.elitesland.tw.tw5crm.api.contract.query.ContractQuery;
import com.elitesland.tw.tw5crm.api.contract.service.ContractService;
import com.elitesland.tw.tw5crm.api.contract.service.ContractSignService;
import com.elitesland.tw.tw5crm.api.contract.vo.ContractSearchVO;
import com.elitesland.tw.tw5crm.api.contract.vo.ContractSimpleVO;
import com.elitesland.tw.tw5crm.api.contract.vo.ContractVO;
import com.elitesland.tw.tw5crm.server.common.constants.ContractStatus;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * 合同管理
 *
 * @author kola
 * @date 2023-04-24
 */
@Api(tags = "合同管理")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/crm/contract")
@Slf4j
public class ContractController {

    private final ContractService contractService;
    private final ContractSignService contractSignService;
    /**
     * 合同-新增
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("合同-新增")
    public TwOutputUtil<ContractVO> insert(@RequestBody ContractPayload payload){
        return TwOutputUtil.ok(contractService.insert(payload));
    }

    /**
     * 合同-新增
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping("sign")
    @ApiOperation("合同-合同签订")
    public TwOutputUtil sign(@RequestBody ContractSignPayload payload){
        return TwOutputUtil.ok(contractSignService.insert(payload));
    }

    /**
     * 合同-更新
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping
    @ApiOperation("合同-更新")
    public TwOutputUtil<ContractVO> update(@RequestBody ContractPayload payload){
        return TwOutputUtil.ok(contractService.update(payload));
    }

    /**
     * 合同-归档 上传附件
     * @param payload
     * @return
     */
    @PutMapping("updateFiled")
    @ApiOperation("合同-归档")
    public TwOutputUtil<ContractVO> updateFiled(@RequestBody ContractPayload payload){
        return TwOutputUtil.ok(contractService.updateFiled(payload));
    }

    /**
     * 合同-主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    @UdcNameClass
    @ApiOperation("合同-主键查询")
    public TwOutputUtil<ContractVO> queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(contractService.queryByKey(key));
    }

    /**
     * 合同-分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    @UdcNameClass
    @ApiOperation("合同-分页")
    public TwOutputUtil<ContractVO> paging(ContractQuery query) {
        return TwOutputUtil.ok(contractService.queryPaging(query));
    }

    /**
     * 合同-查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
//    @GetMapping("/list")
    // @UdcNameClass
    @ApiOperation("合同-查询列表")
    public TwOutputUtil<ContractVO> queryList(ContractQuery query) {
        return TwOutputUtil.ok(contractService.queryListDynamic(query));
    }

    @GetMapping("/listSimpleAll")
    @UdcNameClass
    @ApiOperation("合同-合同下拉选择（全部）")
    public TwOutputUtil<ContractSimpleVO> listSimpleAll(Long customerId) {
        ContractQuery query = new ContractQuery();
        if (null != customerId) {
            query.setCustomerId(customerId);
        }
        return TwOutputUtil.ok(contractService.listSimple(query));
    }

    @GetMapping("/listSimple")
    @UdcNameClass
    @ApiOperation("合同-合同下拉选择（激活数据）")
    public TwOutputUtil<ContractSimpleVO> listSimple(Long customerId) {
        ContractQuery query = new ContractQuery();
        query.setContractStatus(ContractStatus.ACTIVE.getCode());
        if (null != customerId) {
            query.setCustomerId(customerId);
        }
        return TwOutputUtil.ok(contractService.listSimple(query));
    }

    /**
     * 删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("合同-删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
        contractService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    @GetMapping("/listSimpleByKeyword")
    @UdcNameClass
    @ApiOperation("联想合同名称and编号")
    public TwOutputUtil<List<ContractSearchVO>> listSimpleByKeyword(ContractQuery query) {
        List<ContractVO> contractVOS = contractService.queryListDynamic(query);
        List<ContractSearchVO> contractSearchVOS = new ArrayList<>();
        contractVOS.stream().forEach(contractVO->{
            contractSearchVOS.add(new ContractSearchVO(contractVO.getId(), contractVO.getContractName()+"-"+contractVO.getContractCode()));
        });
        return TwOutputUtil.ok(contractSearchVOS);
    }


}
