package com.elitesland.tw.tw5crm.server.contract.controller;

import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5crm.api.contract.payload.ContractCountersidePayload;
import com.elitesland.tw.tw5crm.api.contract.query.ContractCountersideQuery;
import com.elitesland.tw.tw5crm.api.contract.service.ContractCountersideService;
import com.elitesland.tw.tw5crm.api.contract.vo.ContractCountersideVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;

/**
 * 合同管理-相对方信息
 *
 * @author zach.zhang
 * @date 2023-04-23
 */
@Api(tags = "合同管理-相对方信息")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/crm/contract/counterside")
@Slf4j
public class ContractCountersideController {

    private final ContractCountersideService contractCountersideService;

    /**
     * 新增
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("新增")
    public TwOutputUtil<ContractCountersideVO> insert(@RequestBody ContractCountersidePayload payload){
        return TwOutputUtil.ok(contractCountersideService.insert(payload));
    }

    /**
     * 更新
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping
    @ApiOperation("更新")
    public TwOutputUtil<ContractCountersideVO> update(@RequestBody ContractCountersidePayload payload){
        return TwOutputUtil.ok(contractCountersideService.update(payload));
    }

    /**
     * 主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    // @UdcNameClass
    @ApiOperation("主键查询")
    public TwOutputUtil<ContractCountersideVO> queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(contractCountersideService.queryByKey(key));
    }

    /**
     * 分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    // @UdcNameClass
    @ApiOperation("分页")
    public TwOutputUtil<ContractCountersideVO> paging(ContractCountersideQuery query) {
        return TwOutputUtil.ok(contractCountersideService.queryPaging(query));
    }

    /**
     * 查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    // @UdcNameClass
    @ApiOperation("查询列表")
    public TwOutputUtil<ContractCountersideVO> queryList(ContractCountersideQuery query) {
        return TwOutputUtil.ok(contractCountersideService.queryListDynamic(query));
    }

    /**
     * 删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
        contractCountersideService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }


}
