package com.elitesland.tw.tw5crm.server.contract.controller;

import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5crm.api.contract.payload.ContractInvoicePayload;
import com.elitesland.tw.tw5crm.api.contract.query.ContractInvoiceQuery;
import com.elitesland.tw.tw5crm.api.contract.service.ContractInvoiceService;
import com.elitesland.tw.tw5crm.api.contract.vo.ContractInvoiceVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;



import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;

import org.springframework.web.bind.annotation.*;

import java.util.Arrays;


/**
 * 合同管理-发票详情
 *
 * @author wangly
 * @date 2023-04-25
 */
@Api(tags = "合同管理-发票详情")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/crm/contract/invoice")
@Slf4j
public class ContractInvoiceController {

    private final ContractInvoiceService contractInvoiceService;

    /**
     * 新增
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("新增")
    public TwOutputUtil<ContractInvoiceVO> insert(@RequestBody ContractInvoicePayload payload){
        return TwOutputUtil.ok(contractInvoiceService.insert(payload));
    }

    /**
     * 更新
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping
    @ApiOperation("更新")
    public TwOutputUtil<ContractInvoiceVO> update(@RequestBody ContractInvoicePayload payload){
        return TwOutputUtil.ok(contractInvoiceService.update(payload));
    }

    /**
     * 主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    // @UdcNameClass
    @ApiOperation("主键查询")
    public TwOutputUtil<ContractInvoiceVO> queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(contractInvoiceService.queryByKey(key));
    }

    /**
     * 分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    // @UdcNameClass
    @ApiOperation("分页")
    public TwOutputUtil<ContractInvoiceVO> paging(ContractInvoiceQuery query) {
        return TwOutputUtil.ok(contractInvoiceService.queryPaging(query));
    }

    /**
     * 查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    // @UdcNameClass
    @ApiOperation("查询列表")
    public TwOutputUtil<ContractInvoiceVO> queryList(ContractInvoiceQuery query) {
        return TwOutputUtil.ok(contractInvoiceService.queryListDynamic(query));
    }

    /**
     * 删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
        contractInvoiceService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

}
