package com.elitesland.tw.tw5crm.server.contract.controller;

import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5crm.api.contract.payload.ContractProductRefPayload;
import com.elitesland.tw.tw5crm.api.contract.query.ContractProductRefQuery;
import com.elitesland.tw.tw5crm.api.contract.service.ContractProductRefService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;

/**
 * 合同管理-合同产品信息关系表
 *
 * @author duwh
 * @date 2023-04-25
 */
@Api(tags = "合同管理-合同产品信息关系表")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/crm/contract/productRef")
@Slf4j
public class ContractProductRefController {

    private final ContractProductRefService contractProductRefService;

    /**
     * 新增
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("新增")
    public TwOutputUtil insert(@RequestBody ContractProductRefPayload payload){
        return TwOutputUtil.ok(contractProductRefService.insert(payload));
    }

    /**
     * 更新
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping
    @ApiOperation("更新")
    public TwOutputUtil update(@RequestBody ContractProductRefPayload payload){
        return TwOutputUtil.ok(contractProductRefService.update(payload));
    }

    /**
     * 主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    // @UdcNameClass
    @ApiOperation("主键查询")
    public TwOutputUtil queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(contractProductRefService.queryByKey(key));
    }

    /**
     * 分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    // @UdcNameClass
    @ApiOperation("分页")
    public TwOutputUtil paging(ContractProductRefQuery query) {
        return TwOutputUtil.ok(contractProductRefService.queryPaging(query));
    }

    /**
     * 查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    // @UdcNameClass
    @ApiOperation("查询列表")
    public TwOutputUtil queryList(ContractProductRefQuery query) {
        return TwOutputUtil.ok(contractProductRefService.queryListDynamic(query));
    }

    /**
     * 删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
        contractProductRefService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

}
