package com.elitesland.tw.tw5crm.server.contract.controller;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5crm.api.contract.payload.ContractReceiveAccountPayload;
import com.elitesland.tw.tw5crm.api.contract.query.ContractReceiveAccountQuery;
import com.elitesland.tw.tw5crm.api.contract.service.ContractReceiveAccountService;
import com.elitesland.tw.tw5crm.api.contract.vo.ContractAccountNameVO;
import com.elitesland.tw.tw5crm.api.contract.vo.ContractReceiveAccountVO;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;

/**
 * 合同管理-到款录入
 *
 * @folder 合同管理
 * @author zach.zhang
 * @date 2023-04-19
 */
//@Api(tags = "合同管理-到款录入")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/crm/contract/receiveAccount")
@Slf4j
public class ContractReceiveAccountController {

    private final ContractReceiveAccountService crmContractReceiveAccountService;

    /**
     * 到款录入-新增
     *
     * @folder 合同管理
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("到款录入-新增")
    public TwOutputUtil<ContractReceiveAccountVO> insert(@RequestBody ContractReceiveAccountPayload payload) {
        return TwOutputUtil.ok(crmContractReceiveAccountService.insert(payload));
    }

    /**
     * 到款录入-更新
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping
    @ApiOperation("到款录入-更新")
    public TwOutputUtil<ContractReceiveAccountVO> update(@RequestBody ContractReceiveAccountPayload payload) {
        return TwOutputUtil.ok(crmContractReceiveAccountService.update(payload));
    }

    /**
     * 到款录入-主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    // @UdcNameClass
    @ApiOperation("到款录入-主键查询")
    public TwOutputUtil<ContractReceiveAccountVO> queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(crmContractReceiveAccountService.queryByKey(key));
    }

    /**
     * 到款录入-分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    // @UdcNameClass
    @ApiOperation("到款录入-分页")
    public TwOutputUtil<PagingVO<ContractReceiveAccountVO>> paging(ContractReceiveAccountQuery query) {
        return TwOutputUtil.ok(crmContractReceiveAccountService.queryPaging(query));
    }

    /**
     * 到款录入-查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    // @UdcNameClass
    @ApiOperation("到款录入-查询列表")
    public TwOutputUtil<List<ContractReceiveAccountVO>> queryList(ContractReceiveAccountQuery query) {
        return TwOutputUtil.ok(crmContractReceiveAccountService.queryListDynamic(query));
    }

    /**
     * 到款录入-删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("到款录入-删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
        crmContractReceiveAccountService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    /**
     * 到款录入-查询到款收入名称or编号
     *
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/accountList")
    @ApiOperation("到款录入-查询到款收入名称or编号")
    public TwOutputUtil<List<ContractAccountNameVO>> queryAccountNameList() {
        return TwOutputUtil.ok(crmContractReceiveAccountService.listSimple());
    }
}

