package com.elitesland.tw.tw5crm.server.contract.controller;

import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5crm.api.contract.service.ContractReceiveDetailsService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.Arrays;

/**
 * 合同管理-到款明细
 *
 * @author zach.zhang
 * @date 2023-04-25
 */
@Api(tags = "合同管理-到款明细")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/crm/contract/receiveDetails")
@Slf4j
public class ContractReceiveDetailsController {

    private final ContractReceiveDetailsService contractReceiveDetailsService;

//    /**
//     * 新增
//     *
//     * @param payload 有效载荷
//     * @return {@link TwOutputUtil}
//     */
//    @PostMapping
//    @ApiOperation("新增")
//    public TwOutputUtil insert(@RequestBody ContractReceiveDetailsPayload payload){
//        return TwOutputUtil.ok(contractReceiveDetailsService.insert(payload));
//    }

//    /**
//     * 更新
//     *
//     * @param payload 有效载荷
//     * @return {@link TwOutputUtil}
//     */
//    @PutMapping
//    @ApiOperation("更新")
//    public TwOutputUtil update(@RequestBody ContractReceiveDetailsPayload payload){
//        return TwOutputUtil.ok(contractReceiveDetailsService.update(payload));
//    }

//    /**
//     * 主键查询
//     *
//     * @param key 关键
//     * @return {@link TwOutputUtil}
//     */
//    @GetMapping("/{key}")
//    // @UdcNameClass
//    @ApiOperation("主键查询")
//    public TwOutputUtil queryOneByKey(@PathVariable Long key) {
//        return TwOutputUtil.ok(contractReceiveDetailsService.queryByKey(key));
//    }
//
//    /**
//     * 分页
//     *
//     * @param query 查询
//     * @return {@link TwOutputUtil}
//     */
//    @GetMapping("/paging")
//    // @UdcNameClass
//    @ApiOperation("分页")
//    public TwOutputUtil paging(ContractReceiveDetailsQuery query) {
//        return TwOutputUtil.ok(contractReceiveDetailsService.queryPaging(query));
//    }
//
//    /**
//     * 查询列表
//     *
//     * @param query 查询
//     * @return {@link TwOutputUtil}
//     */
//    @GetMapping("/list")
//    // @UdcNameClass
//    @ApiOperation("查询列表")
//    public TwOutputUtil queryList(ContractReceiveDetailsQuery query) {
//        return TwOutputUtil.ok(contractReceiveDetailsService.queryListDynamic(query));
//    }

    /**
     * 删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
        contractReceiveDetailsService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

}
