package com.elitesland.tw.tw5crm.server.contract.controller;

import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5crm.api.contract.query.ContractSignQuery;
import com.elitesland.tw.tw5crm.api.contract.service.ContractSignService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;

/**
 * 合同管理-合同签订
 *
 * @author zach.zhang
 * @date 2023-04-26
 */
@Api(tags = "合同管理-合同签订")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/crm/contractSign")
@Slf4j
public class ContractSignController {

    private final ContractSignService contractSignService;

//    /**
//     * 新增
//     *
//     * @param payload 有效载荷
//     * @return {@link TwOutputUtil}
//     */
//    @PostMapping
//    @ApiOperation("新增")
//    public TwOutputUtil insert(@RequestBody ContractSignPayload payload){
//        return TwOutputUtil.ok(contractSignService.insert(payload));
//    }
//    /**
//     * 签订
//     *
//     * @param payload 有效载荷
//     * @return {@link TwOutputUtil}
//     */
//    @PostMapping("/sign")
//    @ApiOperation("签订")
//    public TwOutputUtil<ContractSignVO> sign(@RequestBody ContractPayload payload){
//        return TwOutputUtil.ok(contractSignService.sign(payload));
//    }

//    /**
//     * 更新
//     *
//     * @param payload 有效载荷
//     * @return {@link TwOutputUtil}
//     */
//    @PutMapping
//    @ApiOperation("更新")
//    public TwOutputUtil update(@RequestBody ContractSignPayload payload){
//        return TwOutputUtil.ok(contractSignService.update(payload));
//    }

    /**
     * 主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    // @UdcNameClass
    @ApiOperation("主键查询")
    public TwOutputUtil queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(contractSignService.queryByKey(key));
    }

    /**
     * 分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    // @UdcNameClass
    @ApiOperation("分页")
    public TwOutputUtil paging(ContractSignQuery query) {
        return TwOutputUtil.ok(contractSignService.queryPaging(query));
    }

    /**
     * 查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    // @UdcNameClass
    @ApiOperation("查询列表")
    public TwOutputUtil queryList(ContractSignQuery query) {
        return TwOutputUtil.ok(contractSignService.queryListDynamic(query));
    }

    /**
     * 删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
        contractSignService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

}
