package com.elitesland.tw.tw5crm.server.contract.controller;

import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import com.elitesland.tw.tw5crm.api.contract.payload.ContractTemplatePayload;
import com.elitesland.tw.tw5crm.api.contract.query.ContractTemplateQuery;
import com.elitesland.tw.tw5crm.api.contract.service.ContractTemplateService;
import com.elitesland.tw.tw5crm.api.contract.vo.ContractTemplateSearchVO;
import com.elitesland.tw.tw5crm.api.contract.vo.ContractTemplateVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * 合同管理-合同模版
 *
 * @folder 合同管理
 * @author duwh
 * @date 2023-04-20
 */
@Api(tags = "合同管理-合同模版")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/crm/contract/template")
@Slf4j
public class ContractTemplateController {

    private final ContractTemplateService contractTemplateService;

    /**
     * 合同模版-新增
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("合同模版-新增")
    public TwOutputUtil insert(@RequestBody ContractTemplatePayload payload){
        return TwOutputUtil.ok(contractTemplateService.insert(payload));
    }

    /**
     * 合同模版-更新
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping
    @ApiOperation("合同模版-更新")
    public TwOutputUtil update(@RequestBody ContractTemplatePayload payload){
        return TwOutputUtil.ok(contractTemplateService.update(payload));
    }

    /**
     * 合同模版-变更审批
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping("change")
    @ApiOperation("合同模版-变更审批")
    public TwOutputUtil change(@RequestBody ContractTemplatePayload payload){
        return TwOutputUtil.ok(contractTemplateService.change(payload));
    }

    /**
     * 合同模版-变更更新
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping("changeUpdate")
    @ApiOperation("合同模版-变更更新")
    public TwOutputUtil changeUpdate(@RequestBody ContractTemplatePayload payload){
        return TwOutputUtil.ok(contractTemplateService.changeUpdate(payload));
    }

    /**
     * 合同模版-主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    @UdcNameClass
    @ApiOperation("合同模版-主键查询")
    public TwOutputUtil queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(contractTemplateService.queryByKey(key));
    }

    /**
     * 合同模版-分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    @UdcNameClass
    @ApiOperation("合同模版-分页")
    public TwOutputUtil paging(ContractTemplateQuery query) {
        return TwOutputUtil.ok(contractTemplateService.queryPaging(query));
    }

    /**
     * 合同模版-查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    @UdcNameClass
    @ApiOperation("合同模版-查询列表")
    public TwOutputUtil queryList(ContractTemplateQuery query) {
        return TwOutputUtil.ok(contractTemplateService.queryListDynamic(query));
    }

    @GetMapping("/listSimple")
    @ApiOperation("合同模版-联想模版名称and编号")
    public TwOutputUtil listNameAndCode(ContractTemplateQuery query) {
        final List<ContractTemplateVO> vos = contractTemplateService.queryListDynamic(query);
        List<ContractTemplateSearchVO> resultList = new ArrayList<>();
        vos.stream().forEach(contractTemplateVO -> {
            resultList.add(new ContractTemplateSearchVO(contractTemplateVO.getId(),contractTemplateVO.getName()+"-"+contractTemplateVO.getCode()));
        });
        return TwOutputUtil.ok(resultList);
    }

    /**
     * 合同模版-删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("合同模版-删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
        contractTemplateService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

}
