package com.elitesland.tw.tw5crm.server.contract.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5crm.api.contract.payload.ContractBillingApplyPayload;
import com.elitesland.tw.tw5crm.api.contract.query.ContractBillingApplyQuery;
import com.elitesland.tw.tw5crm.api.contract.vo.ContractBillingApplyVO;
import com.elitesland.tw.tw5crm.server.contract.entity.ContractBillingApplyDO;
import com.elitesland.tw.tw5crm.server.contract.entity.QContractBillingApplyDO;
import com.elitesland.tw.tw5crm.server.contract.repo.ContractBillingApplyRepo;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * 合同管理-开票申请
 *
 * @author wangly
 * @date 2023-04-25
 */
@Repository
@RequiredArgsConstructor
public class ContractBillingApplyDAO {

    private final JPAQueryFactory jpaQueryFactory;
    private final ContractBillingApplyRepo repo;
    private final QContractBillingApplyDO qdo = QContractBillingApplyDO.contractBillingApplyDO;

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<ContractBillingApplyVO> getJpaQuerySelect() {
        return jpaQueryFactory.select(Projections.bean(ContractBillingApplyVO.class,
                qdo.id,
                //qdo.remark,
                //qdo.createUserId,
                //qdo.creator,
                //qdo.createTime,
                //qdo.modifyUserId,
                //qdo.updater,
                //qdo.modifyTime,
                // 开票流水号
                qdo.billingCode,
                // 开票状态 udc[CRM:CONTRACT:BILLING_STATUS]
                qdo.billingStatus,
                // 客户名称
                qdo.customerName,
                // 开票主体
                qdo.billingMainbody,
                // 发票抬头名称(购买方名称)
                qdo.invoiceTitle,
                // 币种 udc[SYSTEM_BASIC:CURRENCY]
                qdo.currCode,
                // 开票总金额(冗余)
                qdo.billingTotalAmount,
                // 发票代码(冗余)
                qdo.invoiceCode,
                // 发票号码(冗余)
                qdo.invoiceTaxNum,
                // 开票日期
                qdo.invoiceDate,
                // 付款方式 udc[CRM:CONTRACT:PAYMENT_METHOD]
                qdo.paymentMethod,
                // 申请人Id
                qdo.applyUserId,
                // 申请人名称
                qdo.applyUserName,
                // 收件人名称
                qdo.receiveName,
                // 收件人地址
                qdo. receiveAddress,
                // 收件人电话
                qdo.receivePhone,
                // 收件人邮箱
                qdo.receiveEmail,
                // 流程实例ID
                qdo.procInstId,
                // 流程审批状态
                qdo.procInstStatus,
                // 提交时间
                qdo.submitTime,
                // 审批时间
                qdo.approvedTime,
                // 版本
                qdo.version,
                // 更新时间
                qdo.updateTime,
                // 附件
                qdo.fileCodes,
                // 排序号
                qdo.sortNo,
                // 拓展字段1
                qdo.ext1,
                // 拓展字段2
                qdo.ext2,
                // 拓展字段3
                qdo.ext3,
                // 拓展字段4
                qdo.ext4,
                // 拓展字段5
                qdo.ext5
        )).from(qdo);
    }

    /**
     * 拼装查询条件
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    private JPAQuery<ContractBillingApplyVO> getJpaQueryWhere(ContractBillingApplyQuery query) {
        JPAQuery<ContractBillingApplyVO> jpaQuery = getJpaQuerySelect();
        // 条件封装
        jpaQuery.where(where(query));
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        // 动态排序
        jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
        return jpaQuery;
    }

    /**
     * 统计
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    public long count(ContractBillingApplyQuery query) {
        long total = jpaQueryFactory
                .select(qdo.count())
                .from(qdo)
                .where(where(query))
                .fetchOne();
        return total;
    }

    /**
     * 查询条件封装
     *
     * @param query 条件
     * @return {@link Predicate}
     */
    private Predicate where(ContractBillingApplyQuery query){
        List<Predicate> list = new ArrayList<>();// 需要权限
        if (query.getDataPermissionFlag()) {
            BooleanExpression jpaQueryOr = qdo.createUserId.eq(query.getLoginUserId());
            list.add(jpaQueryOr);
        }
        /** 记录唯一ID 精确 */
        if (!ObjectUtils.isEmpty(query.getId())) {
            list.add(qdo.id.eq(query.getId()));
        }
        /** 开票流水号 精确 */
        if (!ObjectUtils.isEmpty(query.getBillingCode())) {
            list.add(qdo.billingCode.eq(query.getBillingCode()));
        }
        /** 开票状态 udc[CRM:CONTRACT:BILLING_STATUS] 精确 */
        if (!ObjectUtils.isEmpty(query.getBillingStatus())) {
            list.add(qdo.billingStatus.eq(query.getBillingStatus()));
        }
        /** 客户主键 精确 */
        if (!ObjectUtils.isEmpty(query.getCustomerId())) {
            list.add(qdo.customerId.eq(query.getCustomerId()));
        }
        /** 客户名称 精确 */
        if (!ObjectUtils.isEmpty(query.getCustomerName())) {
            list.add(qdo.customerName.eq(query.getCustomerName()));
        }
        /** 开票主体 精确 */
        if (!ObjectUtils.isEmpty(query.getBillingMainbody())) {
            list.add(qdo.billingMainbody.eq(query.getBillingMainbody()));
        }
        /** 发票抬头名称(购买方名称) 精确 */
        if (!ObjectUtils.isEmpty(query.getInvoiceTitle())) {
            list.add(qdo.invoiceTitle.eq(query.getInvoiceTitle()));
        }
        /** 币种 udc[SYSTEM_BASIC:CURRENCY] 精确 */
        if (!ObjectUtils.isEmpty(query.getCurrCode())) {
            list.add(qdo.currCode.eq(query.getCurrCode()));
        }
        /** 开票总金额(冗余) 精确 */
        if (!ObjectUtils.isEmpty(query.getBillingTotalAmount())) {
            list.add(qdo.billingTotalAmount.eq(query.getBillingTotalAmount()));
        }
        /** 发票代码(冗余) 精确 */
        if (!ObjectUtils.isEmpty(query.getInvoiceCode())) {
            list.add(qdo.invoiceCode.eq(query.getInvoiceCode()));
        }
        /** 发票号码(冗余) 精确 */
        if (!ObjectUtils.isEmpty(query.getInvoiceTaxNum())) {
            list.add(qdo.invoiceTaxNum.eq(query.getInvoiceTaxNum()));
        }
        /** 开票日期 精确 */
        if (!ObjectUtils.isEmpty(query.getInvoiceDate())) {
            list.add(qdo.invoiceDate.eq(query.getInvoiceDate()));
        }
        /** 付款方式 udc[CRM:CONTRACT:PAYMENT_METHOD] 精确 */
        if (!ObjectUtils.isEmpty(query.getPaymentMethod())) {
            list.add(qdo.paymentMethod.eq(query.getPaymentMethod()));
        }
        /** 申请人Id 精确 */
        if (!ObjectUtils.isEmpty(query.getApplyUserId())) {
            list.add(qdo.applyUserId.eq(query.getApplyUserId()));
        }
        /** 申请人名称 精确 */
        if (!ObjectUtils.isEmpty(query.getApplyUserName())) {
            list.add(qdo.applyUserName.eq(query.getApplyUserName()));
        }
        /** 收件人名称 精确 */
        if (!ObjectUtils.isEmpty(query.getReceiveName())) {
            list.add(qdo.receiveName.eq(query.getReceiveName()));
        }
        /** 收件人地址 精确 */
        if (!ObjectUtils.isEmpty(query.getReceiveAddress())) {
            list.add(qdo. receiveAddress.eq(query.getReceiveAddress()));
        }
        /** 收件人电话 精确 */
        if (!ObjectUtils.isEmpty(query.getReceivePhone())) {
            list.add(qdo.receivePhone.eq(query.getReceivePhone()));
        }
        /** 收件人邮箱 精确 */
        if (!ObjectUtils.isEmpty(query.getReceiveEmail())) {
            list.add(qdo.receiveEmail.eq(query.getReceiveEmail()));
        }
        /** 流程实例ID 精确 */
        if (!ObjectUtils.isEmpty(query.getProcInstId())) {
            list.add(qdo.procInstId.eq(query.getProcInstId()));
        }
        /** 流程审批状态 精确 */
        if (!ObjectUtils.isEmpty(query.getProcInstStatus())) {
            list.add(qdo.procInstStatus.eq(query.getProcInstStatus()));
        }
        /** 提交时间 精确 */
        if (!ObjectUtils.isEmpty(query.getSubmitTime())) {
            list.add(qdo.submitTime.eq(query.getSubmitTime()));
        }
        /** 审批时间 精确 */
        if (!ObjectUtils.isEmpty(query.getApprovedTime())) {
            list.add(qdo.approvedTime.eq(query.getApprovedTime()));
        }
        /** 版本 精确 */
        if (!ObjectUtils.isEmpty(query.getVersion())) {
            list.add(qdo.version.eq(query.getVersion()));
        }
        /** 更新时间 精确 */
        if (!ObjectUtils.isEmpty(query.getUpdateTime())) {
            list.add(qdo.updateTime.eq(query.getUpdateTime()));
        }
        /** 附件 精确 */
        if (!ObjectUtils.isEmpty(query.getFileCodes())) {
            list.add(qdo.fileCodes.eq(query.getFileCodes()));
        }
        /** 排序号 精确 */
        if (!ObjectUtils.isEmpty(query.getSortNo())) {
            list.add(qdo.sortNo.eq(query.getSortNo()));
        }
        /** 拓展字段1 精确 */
        if (!ObjectUtils.isEmpty(query.getExt1())) {
            list.add(qdo.ext1.eq(query.getExt1()));
        }
        /** 拓展字段2 精确 */
        if (!ObjectUtils.isEmpty(query.getExt2())) {
            list.add(qdo.ext2.eq(query.getExt2()));
        }
        /** 拓展字段3 精确 */
        if (!ObjectUtils.isEmpty(query.getExt3())) {
            list.add(qdo.ext3.eq(query.getExt3()));
        }
        /** 拓展字段4 精确 */
        if (!ObjectUtils.isEmpty(query.getExt4())) {
            list.add(qdo.ext4.eq(query.getExt4()));
        }
        /** 拓展字段5 精确 */
        if (!ObjectUtils.isEmpty(query.getExt5())) {
            list.add(qdo.ext5.eq(query.getExt5()));
        }
        return ExpressionUtils.allOf(list);
    }

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 结果
     */
    public ContractBillingApplyVO queryByKey(Long id) {
        JPAQuery<ContractBillingApplyVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.id.eq(id));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    /**
     * 动态查询集合
     *
     * @param query 查询参数
     * @return 结果集合
     */
    public List<ContractBillingApplyVO> queryListDynamic(ContractBillingApplyQuery query) {
        JPAQuery<ContractBillingApplyVO> jpaQuery = getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    /**
     * 分页查询
     *
     * @param query 查询参数
     * @return 分页结果
     */
    public PagingVO<ContractBillingApplyVO> queryPaging(ContractBillingApplyQuery query) {
        long total = count(query);
        if (total == 0) {
            return PagingVO.empty();
        }
        JPAQuery<ContractBillingApplyVO> jpaQuery = getJpaQueryWhere(query);
        List<ContractBillingApplyVO> result = jpaQuery
                .offset(query.getPageRequest().getOffset())
                .limit(query.getPageRequest().getPageSize())
                .fetch();
        return PagingVO.<ContractBillingApplyVO>builder().records(result).total(total).build();
    }

    /**
     * 调用jpa的保存
     *
     * @param ado do对象
     * @return 保存后的对象
     */
    public ContractBillingApplyDO save(ContractBillingApplyDO ado) {
        return repo.save(ado);
    }

    /**
     * 调用jpa的保存所有
     *
     * @param dos 多个do对象
     * @return 保存后的对象集合
     */
    public List<ContractBillingApplyDO> saveAll(List<ContractBillingApplyDO> dos) {
        return repo.saveAll(dos);
    }

    /**
     * 按主键动态修改（只修非null字段，如果需要将某些字段修改为null，请添加nullFields）
     *
     * @param payload 要修改的对象
     * @return 修改的行数
     */
    @Transactional
    public long updateByKeyDynamic(ContractBillingApplyPayload payload) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .where(qdo.id.eq(payload.getId()));
        // 记录唯一ID
        if (payload.getId() != null) {
            update.set(qdo.id, payload.getId());
        }
        // 开票流水号
        if (payload.getBillingCode() != null) {
            update.set(qdo.billingCode, payload.getBillingCode());
        }
        // 开票状态 udc[CRM:CONTRACT:BILLING_STATUS]
        if (payload.getBillingStatus() != null) {
            update.set(qdo.billingStatus, payload.getBillingStatus());
        }
        // 客户名称
        if (payload.getCustomerName() != null) {
            update.set(qdo.customerName, payload.getCustomerName());
        }
        // 开票主体
        if (payload.getBillingMainbody() != null) {
            update.set(qdo.billingMainbody, payload.getBillingMainbody());
        }
        // 发票抬头名称(购买方名称)
        if (payload.getInvoiceTitle() != null) {
            update.set(qdo.invoiceTitle, payload.getInvoiceTitle());
        }
        // 币种 udc[SYSTEM_BASIC:CURRENCY]
        if (payload.getCurrCode() != null) {
            update.set(qdo.currCode, payload.getCurrCode());
        }
        // 开票总金额(冗余)
        if (payload.getBillingTotalAmount() != null) {
            update.set(qdo.billingTotalAmount, payload.getBillingTotalAmount());
        }
        // 发票代码(冗余)
        if (payload.getInvoiceCode() != null) {
            update.set(qdo.invoiceCode, payload.getInvoiceCode());
        }
        // 发票号码(冗余)
        if (payload.getInvoiceTaxNum() != null) {
            update.set(qdo.invoiceTaxNum, payload.getInvoiceTaxNum());
        }
        // 开票日期
        if (payload.getInvoiceDate() != null) {
            update.set(qdo.invoiceDate, payload.getInvoiceDate());
        }
        // 付款方式 udc[CRM:CONTRACT:PAYMENT_METHOD]
        if (payload.getPaymentMethod() != null) {
            update.set(qdo.paymentMethod, payload.getPaymentMethod());
        }
        // 申请人Id
        if (payload.getApplyUserId() != null) {
            update.set(qdo.applyUserId, payload.getApplyUserId());
        }
        // 申请人名称
        if (payload.getApplyUserName() != null) {
            update.set(qdo.applyUserName, payload.getApplyUserName());
        }
        // 收件人名称
        if (payload.getReceiveName() != null) {
            update.set(qdo.receiveName, payload.getReceiveName());
        }
        // 收件人地址
        if (payload.getReceiveAddress() != null) {
            update.set(qdo. receiveAddress, payload.getReceiveAddress());
        }
        // 收件人电话
        if (payload.getReceivePhone() != null) {
            update.set(qdo.receivePhone, payload.getReceivePhone());
        }
        // 收件人邮箱
        if (payload.getReceiveEmail() != null) {
            update.set(qdo.receiveEmail, payload.getReceiveEmail());
        }
        // 流程实例ID
        if (payload.getProcInstId() != null) {
            update.set(qdo.procInstId, payload.getProcInstId());
        }
        // 流程审批状态
        if (payload.getProcInstStatus() != null) {
            update.set(qdo.procInstStatus, payload.getProcInstStatus());
        }
        // 提交时间
        if (payload.getSubmitTime() != null) {
            update.set(qdo.submitTime, payload.getSubmitTime());
        }
        // 审批时间
        if (payload.getApprovedTime() != null) {
            update.set(qdo.approvedTime, payload.getApprovedTime());
        }
        // 版本
        if (payload.getVersion() != null) {
            update.set(qdo.version, payload.getVersion());
        }
        // 更新时间
        if (payload.getUpdateTime() != null) {
            update.set(qdo.updateTime, payload.getUpdateTime());
        }
        // 附件
        if (payload.getFileCodes() != null) {
            update.set(qdo.fileCodes, payload.getFileCodes());
        }
        // 排序号
        if (payload.getSortNo() != null) {
            update.set(qdo.sortNo, payload.getSortNo());
        }
        // 拓展字段1
        if (payload.getExt1() != null) {
            update.set(qdo.ext1, payload.getExt1());
        }
        // 拓展字段2
        if (payload.getExt2() != null) {
            update.set(qdo.ext2, payload.getExt2());
        }
        // 拓展字段3
        if (payload.getExt3() != null) {
            update.set(qdo.ext3, payload.getExt3());
        }
        // 拓展字段4
        if (payload.getExt4() != null) {
            update.set(qdo.ext4, payload.getExt4());
        }
        // 拓展字段5
        if (payload.getExt5() != null) {
            update.set(qdo.ext5, payload.getExt5());
        }
        // 处理要设置成空的字段
        List<String> nullFields = payload.getNullFields();
        if (nullFields != null && nullFields.size() > 0) {
            // 记录唯一ID
            if (nullFields.contains("id")) {
                update.setNull(qdo.id);
            }
            // 开票流水号
            if (nullFields.contains("billingCode")) {
                update.setNull(qdo.billingCode);
            }
            // 开票状态 udc[CRM:CONTRACT:BILLING_STATUS]
            if (nullFields.contains("billingStatus")) {
                update.setNull(qdo.billingStatus);
            }
            // 客户名称
            if (nullFields.contains("customerName")) {
                update.setNull(qdo.customerName);
            }
            // 开票主体
            if (nullFields.contains("billingMainbody")) {
                update.setNull(qdo.billingMainbody);
            }
            // 发票抬头名称(购买方名称)
            if (nullFields.contains("invoiceTitle")) {
                update.setNull(qdo.invoiceTitle);
            }
            // 币种 udc[SYSTEM_BASIC:CURRENCY]
            if (nullFields.contains("currCode")) {
                update.setNull(qdo.currCode);
            }
            // 开票总金额(冗余)
            if (nullFields.contains("billingTotalAmount")) {
                update.setNull(qdo.billingTotalAmount);
            }
            // 发票代码(冗余)
            if (nullFields.contains("invoiceCode")) {
                update.setNull(qdo.invoiceCode);
            }
            // 发票号码(冗余)
            if (nullFields.contains("invoiceTaxNum")) {
                update.setNull(qdo.invoiceTaxNum);
            }
            // 开票日期
            if (nullFields.contains("invoiceDate")) {
                update.setNull(qdo.invoiceDate);
            }
            // 付款方式 udc[CRM:CONTRACT:PAYMENT_METHOD]
            if (nullFields.contains("paymentMethod")) {
                update.setNull(qdo.paymentMethod);
            }
            // 申请人Id
            if (nullFields.contains("applyUserId")) {
                update.setNull(qdo.applyUserId);
            }
            // 申请人名称
            if (nullFields.contains("applyUserName")) {
                update.setNull(qdo.applyUserName);
            }
            // 收件人名称
            if (nullFields.contains("receiveName")) {
                update.setNull(qdo.receiveName);
            }
            // 收件人地址
            if (nullFields.contains(" receiveAddress")) {
                update.setNull(qdo. receiveAddress);
            }
            // 收件人电话
            if (nullFields.contains("receivePhone")) {
                update.setNull(qdo.receivePhone);
            }
            // 收件人邮箱
            if (nullFields.contains("receiveEmail")) {
                update.setNull(qdo.receiveEmail);
            }
            // 流程实例ID
            if (nullFields.contains("procInstId")) {
                update.setNull(qdo.procInstId);
            }
            // 流程审批状态
            if (nullFields.contains("procInstStatus")) {
                update.setNull(qdo.procInstStatus);
            }
            // 提交时间
            if (nullFields.contains("submitTime")) {
                update.setNull(qdo.submitTime);
            }
            // 审批时间
            if (nullFields.contains("approvedTime")) {
                update.setNull(qdo.approvedTime);
            }
            // 版本
            if (nullFields.contains("version")) {
                update.setNull(qdo.version);
            }
            // 更新时间
            if (nullFields.contains("updateTime")) {
                update.setNull(qdo.updateTime);
            }
            // 附件
            if (nullFields.contains("fileCodes")) {
                update.setNull(qdo.fileCodes);
            }
            // 排序号
            if (nullFields.contains("sortNo")) {
                update.setNull(qdo.sortNo);
            }
            // 拓展字段1
            if (nullFields.contains("ext1")) {
                update.setNull(qdo.ext1);
            }
            // 拓展字段2
            if (nullFields.contains("ext2")) {
                update.setNull(qdo.ext2);
            }
            // 拓展字段3
            if (nullFields.contains("ext3")) {
                update.setNull(qdo.ext3);
            }
            // 拓展字段4
            if (nullFields.contains("ext4")) {
                update.setNull(qdo.ext4);
            }
            // 拓展字段5
            if (nullFields.contains("ext5")) {
                update.setNull(qdo.ext5);
            }
        }
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        // 执行修改
        return update.execute();
    }

    /**
     * 逻辑删除
     *
     * @param keys 主集合
     * @return 删除的行数
     */
    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .set(qdo.deleteFlag, 1)
                .where(qdo.id.in(keys));
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        return update.execute();
    }

}

