package com.elitesland.tw.tw5crm.server.contract.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5crm.api.contract.payload.ContractPayload;
import com.elitesland.tw.tw5crm.api.contract.query.ContractQuery;
import com.elitesland.tw.tw5crm.api.contract.vo.ContractSimpleVO;
import com.elitesland.tw.tw5crm.api.contract.vo.ContractVO;
import com.elitesland.tw.tw5crm.server.contract.entity.ContractDO;
import com.elitesland.tw.tw5crm.server.contract.entity.QContractDO;
import com.elitesland.tw.tw5crm.server.contract.repo.ContractRepo;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * 合同管理
 *
 * @author kola
 * @date 2023-04-24
 */
@Repository
@RequiredArgsConstructor
public class ContractDAO {

    private final JPAQueryFactory jpaQueryFactory;
    private final ContractRepo repo;
    private final QContractDO qdo = QContractDO.contractDO;
    private final QContractDO qdo1=new QContractDO("qdo1");

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<ContractVO> getJpaQuerySelect() {
        return jpaQueryFactory.select(Projections.bean(ContractVO.class,
                qdo.id,
                //qdo.remark,
                qdo.createUserId,
                qdo.creator,
                qdo.createTime,
                //qdo.modifyUserId,
                //qdo.updater,
                //qdo.modifyTime,
                // 主合同ID crm_contract.id
                qdo.parentId,
                // 合同编码
                qdo.contractCode,
                // 合同名称
                qdo.contractName,
                // 合同类型udc[CRM:CONTRACT:TYPE](销售合同、采购合同、框架协议)
                qdo.contractType,
                // 我方签约主体主键
                qdo.signCompanyId,
                // 我方签约主体名称(冗余)
                qdo.signCompanyName,
                // 我方主体类型udc[CRM:COMPANY:TYPE](甲方、乙方、丙方、丁方)
                qdo.signCompanyType,
                // 客户主键
                qdo.customerId,
                // 客户名称(冗余)
                qdo.customerName,
                // 供应商主键
                qdo.suppliersId,
                // 供应商名称(冗余)
                qdo.suppliersName,
                // 币种
                qdo.currency,
                // 合同金额
                qdo.contractAmount,
                // 合同状态udc[CRM:CONTRACT:STATUS](新建、被驳回、审批中、激活、暂挂、待补充合同、待归档、已归档)
                qdo.contractStatus,
                // 签订日期
                qdo.signDate,
                // 生效日期
                qdo.effectiveDate,
                // 失效日期
                qdo.expiryDate,
                // 销售负责人udc
                qdo.saleDutyId,
                // 采购负责人udc
                qdo.purchaseDutyId,
                // 交付负责人udc
                qdo.payDutyId,
                // 关联商机主键
                qdo.relateBusinessId,
                // 关联商机名称(冗余)
                qdo.relateBusinessName,
                // 关联合同主键
                qdo.relateContractId,
                // 关联合同名称(冗余)
                qdo.relateContractName,
                // 拓展字段1
                qdo.ext1,
                // 拓展字段2
                qdo.ext2,
                // 拓展字段3
                qdo.ext3,
                // 拓展字段4
                qdo.ext4,
                // 拓展字段5
                qdo.ext5,
                // 合同分类主键（预留后期用）
                qdo.categoryId,
                qdo.category,
                qdo.categoryValue,
                // 合同分类(冗余级联) udcName1/udcName2/udcName3
                qdo.categoryDesc,
                //财务期间主键（预留后期用)
                qdo.fiscalPeriodId,
                //财务期间(年+月的级联)
                qdo.fiscalPeriod,
                // 签单部门主键
                qdo.signOrgId,
                // 签单部门名称(冗余)
                qdo.signOrgName,
                // 采购部门主键
                qdo.purchaseOrgId,
                // 采购部门名称(冗余)
                qdo.purchaseOrgName,
                // 交付部门主键
                qdo.payOrgId,
                // 交付部门名称(冗余)
                qdo.payOrgName,
                // 合同附件1-归档附件
                qdo.contractFile1,
                // 合同附件2
                qdo.contractFile2,
                // 合同附件3
                qdo.contractFile3,
                // 合同附件4
                qdo.contractFile4,
                // 合同附件5
                qdo.contractFile5,
                // 流程实例ID
                qdo.procInstId,
                // 流程审批状态
                qdo.procInstStatus,
                // 提交时间
                qdo.submitTime,
                // 审批时间
                qdo.approvedTime,
                // 版本
                qdo.version,
                // 排序号
                qdo.sortNo,
                // 税率
                qdo.taxRate,
                // 有效合同金额
                qdo.effectiveAmt,
                // 拓展字段1
                qdo.ext6,
                // 拓展字段2
                qdo.ext7,
                // 拓展字段3
                qdo.ext8,
                // 拓展字段4
                qdo.ext9,
                // 拓展字段5
                qdo.ext10,
                //主从合同类型
                qdo.mainType
        )).from(qdo);
    }

    private JPAQuery<ContractSimpleVO> getJpaQuerySimpleSelect() {
        return jpaQueryFactory.select(Projections.bean(ContractSimpleVO.class,
                qdo.id,
                //主合同ID
                qdo.parentId,
                // 合同编码
                qdo.contractCode,
                // 合同名称
                qdo.contractName,
                // 客户主键
                qdo.customerId,
                // 客户名称(冗余)
                qdo.customerName,
                // 销售负责人udc
                qdo.saleDutyId
        )).from(qdo);
    }
    /**
     * 拼装查询条件
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    private JPAQuery<ContractVO> getJpaQueryWhere(ContractQuery query) {
        JPAQuery<ContractVO> jpaQuery = getJpaQuerySelect();
            // 条件封装
            jpaQuery.where(whereDataFilter(query));
            // 常用基础查询条件拼装
            SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
            // 动态排序
            jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
            return jpaQuery;
    }
    private JPAQuery<ContractSimpleVO> getJpaQuerySimpleWhere(ContractQuery query) {
        JPAQuery<ContractSimpleVO> jpaQuery = getJpaQuerySimpleSelect();
        // 条件封装
        jpaQuery.where(whereSimple(query));
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        // 动态排序
        jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
        return jpaQuery;
    }



    /**
     * 统计
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    public long count(ContractQuery query) {
        long total = jpaQueryFactory
            .select(qdo.count())
            .from(qdo)
            .where(where(query))
            .fetchOne();
        return total;
    }


    /**
     * 统计
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    public long countJoin(ContractQuery query) {
        JPAQuery<Long> jpaQuery = jpaQueryFactory
                .select(qdo.count())
                .from(qdo)
//                .leftJoin(qdo1)
                .where(whereJoin(query));
//                .on(qdo.id.eq(qdo1.parentId));
        // 查询从合同
        if (!ObjectUtils.isEmpty(query.getMainType()) && query.getMainType().equals("SUB")) {
        } else {
            // 查询全部  or 查询主合同
            jpaQuery= jpaQuery.where(qdo.parentId.isNull());
        }

        long total = jpaQuery
                .fetchOne();
        return total;
    }

    private Predicate whereJoin(ContractQuery query) {
        List<Predicate> list = new ArrayList<>();
        whereCommon(query, list);
        dataPermissionFilter(query, list);
        return ExpressionUtils.allOf(list);
    }

    /**
     * 数据权限过滤
     *
     * @param query 查询
     * @param list  列表
     */
    private void dataPermissionFilter(ContractQuery query, List<Predicate> list) {
        // 数据权限
        if (query.getDataPermissionFlag()) {

            final BooleanExpression booleanExpression = qdo.createUserId.eq(query.getLoginUserId())
                .or(qdo.saleDutyId.eq(query.getLoginUserId()));
            if (!CollectionUtils.isEmpty(query.getSignOrgIdList())) {
                booleanExpression.or(qdo.signOrgId.in(query.getSignOrgIdList()));
            }
            list.add(
                booleanExpression
            );

//            final BooleanExpression booleanExpression1 = qdo1.createUserId.eq(query.getLoginUserId())
//                .or(qdo1.saleDutyId.eq(query.getLoginUserId()));
//            if (!CollectionUtils.isEmpty(query.getSignOrgIdList())) {
//                booleanExpression.or(qdo1.signOrgId.in(query.getSignOrgIdList()));
//            }
//            list.add(
//                booleanExpression1
//            );
        }
    }

    /**
     * 查询条件封装
     *
     * @param query 条件
     * @return {@link Predicate}
     */
    private Predicate where(ContractQuery query){
        List<Predicate> list = new ArrayList<>();
        whereCommon(query, list);
        return ExpressionUtils.allOf(list);
    }

    /**
     * 查询条件封装
     *
     * @param query 条件
     * @return {@link Predicate}
     */
    private Predicate whereDataFilter(ContractQuery query){
        List<Predicate> list = new ArrayList<>();
        whereCommon(query, list);
        dataPermissionFilter(query, list);
        return ExpressionUtils.allOf(list);
    }

    /**
     * 查询条件封装
     *
     * @param query 条件
     * @return {@link Predicate}
     */
    private Predicate whereSimple(ContractQuery query){
        List<Predicate> list = new ArrayList<>();
        whereCommon(query, list);
        dataPermissionFilter(query, list);
        return ExpressionUtils.allOf(list);
    }

    private void whereCommon(ContractQuery query, List<Predicate> list) {
        /** 关键字 模糊 */
        if (!ObjectUtils.isEmpty(query.getKeyword())) {
            list.add(qdo.contractName.like(SqlUtil.toSqlLikeString(query.getKeyword())).or(qdo.contractCode.like(SqlUtil.toSqlLikeString(query.getKeyword()))));
        }
        /** 记录唯一ID 精确 */
        if (!ObjectUtils.isEmpty(query.getId())) {
            list.add(qdo.id.eq(query.getId()));
        }
        /** 主合同ID crm_contract.id 精确 */
        if (!ObjectUtils.isEmpty(query.getParentId())) {
            list.add(qdo.parentId.eq(query.getParentId()));
        }
        /** 主合同ID crm_contract.id 精确 */
        if (!ObjectUtils.isEmpty(query.getParentIdIsNull())) {
            list.add(qdo.parentId.isNull());
        }
        /** 合同编码 精确 */
        if (!ObjectUtils.isEmpty(query.getContractCode())) {
            list.add(qdo.contractCode.eq(query.getContractCode()));
        }
        /** 合同名称 精确 */
        if (!ObjectUtils.isEmpty(query.getContractName())) {
            list.add(qdo.contractName.eq(query.getContractName()));
        }
        /** 合同类型udc[CRM:CONTRACT:TYPE](销售合同、采购合同、框架协议) 精确 */
        if (!ObjectUtils.isEmpty(query.getContractType())) {
            list.add(qdo.contractType.eq(query.getContractType()));
        }
        /** 我方签约主体主键 精确 */
        if (!ObjectUtils.isEmpty(query.getSignCompanyId())) {
            list.add(qdo.signCompanyId.eq(query.getSignCompanyId()));
        }
        /** 我方签约主体名称(冗余) 精确 */
        if (!ObjectUtils.isEmpty(query.getSignCompanyName())) {
            list.add(qdo.signCompanyName.eq(query.getSignCompanyName()));
        }
        /** 我方主体类型udc[CRM:COMPANY:TYPE](甲方、乙方、丙方、丁方) 精确 */
        if (!ObjectUtils.isEmpty(query.getSignCompanyType())) {
            list.add(qdo.signCompanyType.eq(query.getSignCompanyType()));
        }
        /** 客户主键 精确 */
        if (!ObjectUtils.isEmpty(query.getCustomerId())) {
            list.add(qdo.customerId.eq(query.getCustomerId()));
        }
        /** 客户名称(冗余) 精确 */
        if (!ObjectUtils.isEmpty(query.getCustomerName())) {
            list.add(qdo.customerName.eq(query.getCustomerName()));
        }
        /** 供应商主键 精确 */
        if (!ObjectUtils.isEmpty(query.getSuppliersId())) {
            list.add(qdo.suppliersId.eq(query.getSuppliersId()));
        }
        /** 供应商名称(冗余) 精确 */
        if (!ObjectUtils.isEmpty(query.getSuppliersName())) {
            list.add(qdo.suppliersName.eq(query.getSuppliersName()));
        }
        /** 币种 精确 */
        if (!ObjectUtils.isEmpty(query.getCurrency())) {
            list.add(qdo.currency.eq(query.getCurrency()));
        }
        /** 合同金额 精确 */
        if (!ObjectUtils.isEmpty(query.getContractAmount())) {
            list.add(qdo.contractAmount.eq(query.getContractAmount()));
        }
        /** 合同状态udc[CRM:CONTRACT:STATUS](新建、被驳回、审批中、激活、暂挂、待补充合同、待归档、已归档) 精确 */
        if (!ObjectUtils.isEmpty(query.getContractStatus())) {
            list.add(qdo.contractStatus.eq(query.getContractStatus()));
        }
        if (!ObjectUtils.isEmpty(query.getContractLifeStatus())){
            String[] lifeStatus = query.getContractLifeStatus().split(",");
            list.add(qdo.contractStatus.in(lifeStatus));
        }
        /** 签订日期 精确 */
        if (!ObjectUtils.isEmpty(query.getSignDate())) {
            list.add(qdo.signDate.eq(query.getSignDate()));
        }
        if (!ObjectUtils.isEmpty(query.getSignDateStart())) {
            list.add(qdo.signDate.goe(query.getSignDateStart()));
        }
        if (!ObjectUtils.isEmpty(query.getSignDateEnd())) {
            list.add(qdo.signDate.loe(query.getSignDateEnd()));
        }
        /** 生效日期 精确 */
        if (!ObjectUtils.isEmpty(query.getEffectiveDate())) {
            list.add(qdo.effectiveDate.eq(query.getEffectiveDate()));
        }
        /** 失效日期 精确 */
        if (!ObjectUtils.isEmpty(query.getExpiryDate())) {
            list.add(qdo.expiryDate.eq(query.getExpiryDate()));
        }
        /** 销售负责人udc 精确 */
        if (!ObjectUtils.isEmpty(query.getSaleDutyId())) {
            list.add(qdo.saleDutyId.eq(query.getSaleDutyId()));
        }
        /** 采购负责人udc 精确 */
        if (!ObjectUtils.isEmpty(query.getPurchaseDutyId())) {
            list.add(qdo.purchaseDutyId.eq(query.getPurchaseDutyId()));
        }
        /** 交付负责人udc 精确 */
        if (!ObjectUtils.isEmpty(query.getPayDutyId())) {
            list.add(qdo.payDutyId.eq(query.getPayDutyId()));
        }
        /** 关联商机主键 精确 */
        if (!ObjectUtils.isEmpty(query.getRelateBusinessId())) {
            list.add(qdo.relateBusinessId.eq(query.getRelateBusinessId()));
        }
        /** 关联商机名称(冗余) 精确 */
        if (!ObjectUtils.isEmpty(query.getRelateBusinessName())) {
            list.add(qdo.relateBusinessName.eq(query.getRelateBusinessName()));
        }
        /** 关联合同主键 精确 */
        if (!ObjectUtils.isEmpty(query.getRelateContractId())) {
            list.add(qdo.relateContractId.eq(query.getRelateContractId()));
        }
        /** 关联合同名称(冗余) 精确 */
        if (!ObjectUtils.isEmpty(query.getRelateContractName())) {
            list.add(qdo.relateContractName.eq(query.getRelateContractName()));
        }
        /** 合同分类主键（预留后期用） 精确 */
        if (!ObjectUtils.isEmpty(query.getCategoryId())) {
            list.add(qdo.categoryId.eq(query.getCategoryId()));
        }
        if (!ObjectUtils.isEmpty(query.getCategory())) {
            list.add(qdo.category.eq(query.getCategory()));
        }
        if (!ObjectUtils.isEmpty(query.getCategoryValue())) {
            list.add(qdo.categoryValue.eq(query.getCategoryValue()));
        }
        /** 合同分类(冗余级联) udcName1/udcName2/udcName3 精确 */
        if (!ObjectUtils.isEmpty(query.getCategoryDesc())) {
            list.add(qdo.categoryDesc.eq(query.getCategoryDesc()));
        }
        /** 财务期间主键（预留后期用 精确 */
        if (!ObjectUtils.isEmpty(query.getFiscalPeriodId())) {
            list.add(qdo.fiscalPeriodId.eq(query.getFiscalPeriodId()));
        }
        /** 财务期间(年+月的级联) 精确 */
        if (!ObjectUtils.isEmpty(query.getFiscalPeriod())) {
            list.add(qdo.fiscalPeriod.eq(query.getFiscalPeriod()));
        }
        /** 签单部门主键 精确 */
        if (!ObjectUtils.isEmpty(query.getSignOrgId())) {
            list.add(qdo.signOrgId.eq(query.getSignOrgId()));
        }
        /** 签单部门名称(冗余) 精确 */
        if (!ObjectUtils.isEmpty(query.getSignOrgName())) {
            list.add(qdo.signOrgName.eq(query.getSignOrgName()));
        }
        /** 采购部门主键 精确 */
        if (!ObjectUtils.isEmpty(query.getPurchaseOrgId())) {
            list.add(qdo.purchaseOrgId.eq(query.getPurchaseOrgId()));
        }
        /** 采购部门名称(冗余) 精确 */
        if (!ObjectUtils.isEmpty(query.getPurchaseOrgName())) {
            list.add(qdo.purchaseOrgName.eq(query.getPurchaseOrgName()));
        }
        /** 交付部门主键 精确 */
        if (!ObjectUtils.isEmpty(query.getPayOrgId())) {
            list.add(qdo.payOrgId.eq(query.getPayOrgId()));
        }
        /** 交付部门名称(冗余) 精确 */
        if (!ObjectUtils.isEmpty(query.getPayOrgName())) {
            list.add(qdo.payOrgName.eq(query.getPayOrgName()));
        }
        /** 合同附件1 精确 */
        if (!ObjectUtils.isEmpty(query.getContractFile1())) {
            list.add(qdo.contractFile1.eq(query.getContractFile1()));
        }
        /** 合同附件2 精确 */
        if (!ObjectUtils.isEmpty(query.getContractFile2())) {
            list.add(qdo.contractFile2.eq(query.getContractFile2()));
        }
        /** 合同附件3 精确 */
        if (!ObjectUtils.isEmpty(query.getContractFile3())) {
            list.add(qdo.contractFile3.eq(query.getContractFile3()));
        }
        /** 合同附件4 精确 */
        if (!ObjectUtils.isEmpty(query.getContractFile4())) {
            list.add(qdo.contractFile4.eq(query.getContractFile4()));
        }
        /** 合同附件5 精确 */
        if (!ObjectUtils.isEmpty(query.getContractFile5())) {
            list.add(qdo.contractFile5.eq(query.getContractFile5()));
        }
        /** 流程实例ID 精确 */
        if (!ObjectUtils.isEmpty(query.getProcInstId())) {
            list.add(qdo.procInstId.eq(query.getProcInstId()));
        }
        /** 流程审批状态 精确 */
        if (!ObjectUtils.isEmpty(query.getProcInstStatus())) {
            list.add(qdo.procInstStatus.eq(query.getProcInstStatus()));
        }
        /** 提交时间 精确 */
        if (!ObjectUtils.isEmpty(query.getSubmitTime())) {
            list.add(qdo.submitTime.eq(query.getSubmitTime()));
        }
        /** 审批时间 精确 */
        if (!ObjectUtils.isEmpty(query.getApprovedTime())) {
            list.add(qdo.approvedTime.eq(query.getApprovedTime()));
        }
        /** 版本 精确 */
        if (!ObjectUtils.isEmpty(query.getVersion())) {
            list.add(qdo.version.eq(query.getVersion()));
        }
        /** 排序号 精确 */
        if (!ObjectUtils.isEmpty(query.getSortNo())) {
            list.add(qdo.sortNo.eq(query.getSortNo()));
        }
        /** 税率 精确 */
        if (!ObjectUtils.isEmpty(query.getTaxRate())) {
            list.add(qdo.taxRate.eq(query.getTaxRate()));
        }
        /** 有效合同金额 精确 */
        if (!ObjectUtils.isEmpty(query.getEffectiveAmt())) {
            list.add(qdo.effectiveAmt.eq(query.getEffectiveAmt()));
        }
        /** 主从合同类型 精确 */
        if (!ObjectUtils.isEmpty(query.getMainType())) {
            list.add(qdo.mainType.eq(query.getMainType()));
        }
        /** 拓展字段1 精确 */
        if (!ObjectUtils.isEmpty(query.getExt1())) {
            list.add(qdo.ext1.eq(query.getExt1()));
        }
        /** 拓展字段2 精确 */
        if (!ObjectUtils.isEmpty(query.getExt2())) {
            list.add(qdo.ext2.eq(query.getExt2()));
        }
        /** 拓展字段3 精确 */
        if (!ObjectUtils.isEmpty(query.getExt3())) {
            list.add(qdo.ext3.eq(query.getExt3()));
        }
        /** 拓展字段4 精确 */
        if (!ObjectUtils.isEmpty(query.getExt4())) {
            list.add(qdo.ext4.eq(query.getExt4()));
        }
        /** 拓展字段5 精确 */
        if (!ObjectUtils.isEmpty(query.getExt5())) {
            list.add(qdo.ext5.eq(query.getExt5()));
        }
        /** 拓展字段6 精确 */
        if (!ObjectUtils.isEmpty(query.getExt6())) {
            list.add(qdo.ext6.eq(query.getExt6()));
        }
        /** 拓展字段7 精确 */
        if (!ObjectUtils.isEmpty(query.getExt7())) {
            list.add(qdo.ext7.eq(query.getExt7()));
        }
        /** 拓展字段8 精确 */
        if (!ObjectUtils.isEmpty(query.getExt8())) {
            list.add(qdo.ext8.eq(query.getExt8()));
        }
        /** 拓展字段9 精确 */
        if (!ObjectUtils.isEmpty(query.getExt9())) {
            list.add(qdo.ext9.eq(query.getExt9()));
        }
        /** 拓展字段10 精确 */
        if (!ObjectUtils.isEmpty(query.getExt10())) {
            list.add(qdo.ext10.eq(query.getExt10()));
        }
    }

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 结果
     */
    public ContractVO queryByKey(Long id) {
        JPAQuery<ContractVO> jpaQuery = getJpaQuerySelect();
            jpaQuery.where(qdo.id.eq(id));
            jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }


    public PagingVO<ContractVO> queryPagingJoin(ContractQuery query) {
        long total = countJoin(query);
        if (total == 0) {
            return PagingVO.empty();
        }
        JPAQuery<ContractVO> jpaQuery = getJpaQuerySelectJoin();
        // 条件封装
        jpaQuery.where(whereJoin(query));
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        // 动态排序
        jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
        // 查询从合同
        if (!ObjectUtils.isEmpty(query.getMainType()) && query.getMainType().equals("SUB")) {
//            jpaQuery=jpaQuery.where(qdo.parentId.isNotNull());
        } else {
            // 查询全部  or 查询主合同
            jpaQuery = jpaQuery.where(qdo.parentId.isNull());
        }
        List<ContractVO> result = jpaQuery
//                .where(qdo.parentId.isNull())
                .offset(query.getPageRequest().getOffset())
                .limit(query.getPageRequest().getPageSize())
                .fetch();
        return PagingVO.<ContractVO>builder().records(result).total(total).build();
    }



    /**
     * 动态查询集合
     *
     * @param query 查询参数
     * @return 结果集合
     */
    public List<ContractVO> queryListDynamic(ContractQuery query) {
        JPAQuery<ContractVO> jpaQuery = getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    public List<ContractSimpleVO> queryListSimple(ContractQuery query) {
        JPAQuery<ContractSimpleVO> jpaQuery = getJpaQuerySimpleWhere(query);
        return jpaQuery
                .where(qdo.parentId.isNull())
                .fetch();
    }

    public List<ContractSimpleVO> queryReceiveList(ContractQuery query) {
        JPAQuery<ContractSimpleVO> jpaQuery = getJpaQuerySimpleWhere(query);
        return jpaQuery.fetch();
    }

    /**
     * 分页查询
     *
     * @param query 查询参数
     * @return 分页结果
     */
    public PagingVO<ContractVO> queryPaging(ContractQuery query) {
        long total = count(query);
        if (total == 0) {
             return PagingVO.empty();
        }
        JPAQuery<ContractVO> jpaQuery = getJpaQueryWhere(query);
        List<ContractVO> result = jpaQuery
                .offset(query.getPageRequest().getOffset())
                .limit(query.getPageRequest().getPageSize())
                .fetch();
        return PagingVO.<ContractVO>builder().records(result).total(total).build();
    }

    private JPAQuery<ContractVO> getJpaQuerySelectJoin() {
        return jpaQueryFactory.select(Projections.bean(ContractVO.class,
                qdo.id,
                qdo.remark,
                qdo.createUserId,
                qdo.creator,
                qdo.createTime,
                //qdo.modifyUserId,
                //qdo.updater,
                //qdo.modifyTime,
                // 主合同ID crm_contract.id
                qdo.parentId,
                // 合同编码
                qdo.contractCode,
                // 合同名称
                qdo.contractName,
                // 合同类型udc[CRM:CONTRACT:TYPE](销售合同、采购合同、框架协议)
                qdo.contractType,
                // 我方签约主体主键
                qdo.signCompanyId,
                // 我方签约主体名称(冗余)
                qdo.signCompanyName,
                // 我方主体类型udc[CRM:COMPANY:TYPE](甲方、乙方、丙方、丁方)
                qdo.signCompanyType,
                // 客户主键
                qdo.customerId,
                // 客户名称(冗余)
                qdo.customerName,
                // 供应商主键
                qdo.suppliersId,
                // 供应商名称(冗余)
                qdo.suppliersName,
                // 币种
                qdo.currency,
                // 合同金额
                qdo.contractAmount,
                // 合同状态udc[CRM:CONTRACT:STATUS](新建、被驳回、审批中、激活、暂挂、待补充合同、待归档、已归档)
                qdo.contractStatus,
                // 签订日期
                qdo.signDate,
                // 生效日期
                qdo.effectiveDate,
                // 失效日期
                qdo.expiryDate,
                // 销售负责人udc
                qdo.saleDutyId,
                // 采购负责人udc
                qdo.purchaseDutyId,
                // 交付负责人udc
                qdo.payDutyId,
                // 关联商机主键
                qdo.relateBusinessId,
                // 关联商机名称(冗余)
                qdo.relateBusinessName,
                // 关联合同主键
                qdo.relateContractId,
                // 关联合同名称(冗余)
                qdo.relateContractName,
                // 拓展字段1
                qdo.ext1,
                // 拓展字段2
                qdo.ext2,
                // 拓展字段3
                qdo.ext3,
                // 拓展字段4
                qdo.ext4,
                // 拓展字段5
                qdo.ext5,
                // 合同分类主键（预留后期用）
                qdo.categoryId,
                qdo.category,
                qdo.categoryValue,
                // 合同分类(冗余级联) udcName1/udcName2/udcName3
                qdo.categoryDesc,
                //财务期间主键（预留后期用)
                qdo.fiscalPeriodId,
                //财务期间(年+月的级联)
                qdo.fiscalPeriod,
                // 签单部门主键
                qdo.signOrgId,
                // 签单部门名称(冗余)
                qdo.signOrgName,
                // 采购部门主键
                qdo.purchaseOrgId,
                // 采购部门名称(冗余)
                qdo.purchaseOrgName,
                // 交付部门主键
                qdo.payOrgId,
                // 交付部门名称(冗余)
                qdo.payOrgName,
                // 合同附件1
                qdo.contractFile1,
                // 合同附件2
                qdo.contractFile2,
                // 合同附件3
                qdo.contractFile3,
                // 合同附件4
                qdo.contractFile4,
                // 合同附件5
                qdo.contractFile5,
                // 流程实例ID
                qdo.procInstId,
                // 流程审批状态
                qdo.procInstStatus,
                // 提交时间
                qdo.submitTime,
                // 审批时间
                qdo.approvedTime,
                // 版本
                qdo.version,
                // 排序号
                qdo.sortNo,
                // 税率
                qdo.taxRate,
                // 有效合同金额
                qdo.effectiveAmt,
                // 拓展字段1
                qdo.ext6,
                // 拓展字段2
                qdo.ext7,
                // 拓展字段3
                qdo.ext8,
                // 拓展字段4
                qdo.ext9,
                // 拓展字段5
                qdo.ext10,
                //主从合同类型
                qdo.mainType
        )).from(qdo);
//            .leftJoin(qdo1).on(qdo.id.eq(qdo1.parentId));
    }

    /**
     * 调用jpa的保存
     *
     * @param ado do对象
     * @return 保存后的对象
     */
    public ContractDO save(ContractDO ado) {
        return repo.save(ado);
    }

    /**
     * 调用jpa的保存所有
     *
     * @param dos 多个do对象
     * @return 保存后的对象集合
     */
    public List<ContractDO> saveAll(List<ContractDO> dos) {
        return repo.saveAll(dos);
    }

    /**
     * 按主键动态修改（只修非null字段，如果需要将某些字段修改为null，请添加nullFields）
     *
     * @param payload 要修改的对象
     * @return 修改的行数
     */
    @Transactional
    public long updateByKeyDynamic(ContractPayload payload) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
        .where(qdo.id.eq(payload.getId()));
        // 记录唯一ID
        if (payload.getId() != null) {
            update.set(qdo.id, payload.getId());
        }
        // 主合同ID crm_contract.id
        if (payload.getParentId() != null) {
            update.set(qdo.parentId, payload.getParentId());
        }
        // 合同编码
        if (payload.getContractCode() != null) {
            update.set(qdo.contractCode, payload.getContractCode());
        }
        // 合同名称
        if (payload.getContractName() != null) {
            update.set(qdo.contractName, payload.getContractName());
        }
        // 合同类型udc[CRM:CONTRACT:TYPE](销售合同、采购合同、框架协议)
        if (payload.getContractType() != null) {
            update.set(qdo.contractType, payload.getContractType());
        }
        // 我方签约主体主键
        if (payload.getSignCompanyId() != null) {
            update.set(qdo.signCompanyId, payload.getSignCompanyId());
        }
        // 我方签约主体名称(冗余)
        if (payload.getSignCompanyName() != null) {
            update.set(qdo.signCompanyName, payload.getSignCompanyName());
        }
        // 我方主体类型udc[CRM:COMPANY:TYPE](甲方、乙方、丙方、丁方)
        if (payload.getSignCompanyType() != null) {
            update.set(qdo.signCompanyType, payload.getSignCompanyType());
        }
        // 客户主键
        if (payload.getCustomerId() != null) {
            update.set(qdo.customerId, payload.getCustomerId());
        }
        // 客户名称(冗余)
        if (payload.getCustomerName() != null) {
            update.set(qdo.customerName, payload.getCustomerName());
        }
        // 供应商主键
        if (payload.getSuppliersId() != null) {
            update.set(qdo.suppliersId, payload.getSuppliersId());
        }
        // 供应商名称(冗余)
        if (payload.getSuppliersName() != null) {
            update.set(qdo.suppliersName, payload.getSuppliersName());
        }
        // 币种
        if (payload.getCurrency() != null) {
            update.set(qdo.currency, payload.getCurrency());
        }
        // 合同金额
        if (payload.getContractAmount() != null) {
            update.set(qdo.contractAmount, payload.getContractAmount());
        }
        // 合同状态udc[CRM:CONTRACT:STATUS](新建、被驳回、审批中、激活、暂挂、待补充合同、待归档、已归档)
        if (payload.getContractStatus() != null) {
            update.set(qdo.contractStatus, payload.getContractStatus());
        }
        // 签订日期
        if (payload.getSignDate() != null) {
            update.set(qdo.signDate, payload.getSignDate());
        }
        // 生效日期
        if (payload.getEffectiveDate() != null) {
            update.set(qdo.effectiveDate, payload.getEffectiveDate());
        }
        // 失效日期
        if (payload.getExpiryDate() != null) {
            update.set(qdo.expiryDate, payload.getExpiryDate());
        }
        // 销售负责人udc
        if (payload.getSaleDutyId() != null) {
            update.set(qdo.saleDutyId, payload.getSaleDutyId());
        }
        // 采购负责人udc
        if (payload.getPurchaseDutyId() != null) {
            update.set(qdo.purchaseDutyId, payload.getPurchaseDutyId());
        }
        // 交付负责人udc
        if (payload.getPayDutyId() != null) {
            update.set(qdo.payDutyId, payload.getPayDutyId());
        }
        // 关联商机主键
        if (payload.getRelateBusinessId() != null) {
            update.set(qdo.relateBusinessId, payload.getRelateBusinessId());
        }
        // 关联商机名称(冗余)
        if (payload.getRelateBusinessName() != null) {
            update.set(qdo.relateBusinessName, payload.getRelateBusinessName());
        }
        // 关联合同主键
        if (payload.getRelateContractId() != null) {
            update.set(qdo.relateContractId, payload.getRelateContractId());
        }
        // 关联合同名称(冗余)
        if (payload.getRelateContractName() != null) {
            update.set(qdo.relateContractName, payload.getRelateContractName());
        }
        // 合同分类主键（预留后期用）
        if (payload.getCategoryId() != null) {
            update.set(qdo.categoryId, payload.getCategoryId());
        }
        // 合同分类(冗余级联) udcName1/udcName2/udcName3
        if (payload.getCategoryDesc() != null) {
            update.set(qdo.categoryDesc, payload.getCategoryDesc());
        }
        // 财务期间主键（预留后期用
        if (payload.getFiscalPeriodId() != null) {
            update.set(qdo.fiscalPeriodId, payload.getFiscalPeriodId());
        }
        // 财务期间(年+月的级联)
        if (payload.getFiscalPeriod() != null) {
            update.set(qdo.fiscalPeriod, payload.getFiscalPeriod());
        }
        // 签单部门主键
        if (payload.getSignOrgId() != null) {
            update.set(qdo.signOrgId, payload.getSignOrgId());
        }
        // 签单部门名称(冗余)
        if (payload.getSignOrgName() != null) {
            update.set(qdo.signOrgName, payload.getSignOrgName());
        }
        // 采购部门主键
        if (payload.getPurchaseOrgId() != null) {
            update.set(qdo.purchaseOrgId, payload.getPurchaseOrgId());
        }
        // 采购部门名称(冗余)
        if (payload.getPurchaseOrgName() != null) {
            update.set(qdo.purchaseOrgName, payload.getPurchaseOrgName());
        }
        // 交付部门主键
        if (payload.getPayOrgId() != null) {
            update.set(qdo.payOrgId, payload.getPayOrgId());
        }
        // 交付部门名称(冗余)
        if (payload.getPayOrgName() != null) {
            update.set(qdo.payOrgName, payload.getPayOrgName());
        }
        // 合同附件1
        if (payload.getContractFile1() != null) {
            update.set(qdo.contractFile1, payload.getContractFile1());
        }
        // 合同附件2
        if (payload.getContractFile2() != null) {
            update.set(qdo.contractFile2, payload.getContractFile2());
        }
        // 合同附件3
        if (payload.getContractFile3() != null) {
            update.set(qdo.contractFile3, payload.getContractFile3());
        }
        // 合同附件4
        if (payload.getContractFile4() != null) {
            update.set(qdo.contractFile4, payload.getContractFile4());
        }
        // 合同附件5
        if (payload.getContractFile5() != null) {
            update.set(qdo.contractFile5, payload.getContractFile5());
        }
        // 流程实例ID
        if (payload.getProcInstId() != null) {
            update.set(qdo.procInstId, payload.getProcInstId());
        }
        // 流程审批状态
        if (payload.getProcInstStatus() != null) {
            update.set(qdo.procInstStatus, payload.getProcInstStatus());
        }
        // 提交时间
        if (payload.getSubmitTime() != null) {
            update.set(qdo.submitTime, payload.getSubmitTime());
        }
        // 审批时间
        if (payload.getApprovedTime() != null) {
            update.set(qdo.approvedTime, payload.getApprovedTime());
        }
        // 版本
        if (payload.getVersion() != null) {
            update.set(qdo.version, payload.getVersion());
        }
        // 排序号
        if (payload.getSortNo() != null) {
            update.set(qdo.sortNo, payload.getSortNo());
        }
        // 税率
        if (payload.getTaxRate() != null) {
            update.set(qdo.taxRate, payload.getTaxRate());
        }
        // 有效合同金额
        if (payload.getEffectiveAmt() != null) {
            update.set(qdo.effectiveAmt, payload.getEffectiveAmt());
        }
        // 主从合同类型
        if (payload.getMainType() != null) {
            update.set(qdo.mainType, payload.getMainType());
        }
        // 拓展字段1
        if (payload.getExt1() != null) {
            update.set(qdo.ext1, payload.getExt1());
        }
        // 拓展字段2
        if (payload.getExt2() != null) {
            update.set(qdo.ext2, payload.getExt2());
        }
        // 拓展字段3
        if (payload.getExt3() != null) {
            update.set(qdo.ext3, payload.getExt3());
        }
        // 拓展字段4
        if (payload.getExt4() != null) {
            update.set(qdo.ext4, payload.getExt4());
        }
        // 拓展字段5
        if (payload.getExt5() != null) {
            update.set(qdo.ext5, payload.getExt5());
        }
        // 拓展字段6
        if (payload.getExt6() != null) {
            update.set(qdo.ext6, payload.getExt6());
        }
        // 拓展字段7
        if (payload.getExt7() != null) {
            update.set(qdo.ext7, payload.getExt7());
        }
        // 拓展字段8
        if (payload.getExt8() != null) {
            update.set(qdo.ext8, payload.getExt8());
        }
        // 拓展字段9
        if (payload.getExt9() != null) {
            update.set(qdo.ext9, payload.getExt9());
        }
        // 拓展字段10
        if (payload.getExt10() != null) {
            update.set(qdo.ext10, payload.getExt10());
        }
        // 处理要设置成空的字段
        List<String> nullFields = payload.getNullFields();
        if (nullFields != null && nullFields.size() > 0) {
            // 记录唯一ID
            if (nullFields.contains("id")) {
                update.setNull(qdo.id);
            }
            // 主合同ID crm_contract.id
            if (nullFields.contains("parentId")) {
                update.setNull(qdo.parentId);
            }
            // 合同编码
            if (nullFields.contains("contractCode")) {
                update.setNull(qdo.contractCode);
            }
            // 合同名称
            if (nullFields.contains("contractName")) {
                update.setNull(qdo.contractName);
            }
            // 合同类型udc[CRM:CONTRACT:TYPE](销售合同、采购合同、框架协议)
            if (nullFields.contains("contractType")) {
                update.setNull(qdo.contractType);
            }
            // 我方签约主体主键
            if (nullFields.contains("signCompanyId")) {
                update.setNull(qdo.signCompanyId);
            }
            // 我方签约主体名称(冗余)
            if (nullFields.contains("signCompanyName")) {
                update.setNull(qdo.signCompanyName);
            }
            // 我方主体类型udc[CRM:COMPANY:TYPE](甲方、乙方、丙方、丁方)
            if (nullFields.contains("signCompanyType")) {
                update.setNull(qdo.signCompanyType);
            }
            // 客户主键
            if (nullFields.contains("customerId")) {
                update.setNull(qdo.customerId);
            }
            // 客户名称(冗余)
            if (nullFields.contains("customerName")) {
                update.setNull(qdo.customerName);
            }
            // 供应商主键
            if (nullFields.contains("suppliersId")) {
                update.setNull(qdo.suppliersId);
            }
            // 供应商名称(冗余)
            if (nullFields.contains("suppliersName")) {
                update.setNull(qdo.suppliersName);
            }
            // 币种
            if (nullFields.contains("currency")) {
                update.setNull(qdo.currency);
            }
            // 合同金额
            if (nullFields.contains("contractAmount")) {
                update.setNull(qdo.contractAmount);
            }
            // 合同状态udc[CRM:CONTRACT:STATUS](新建、被驳回、审批中、激活、暂挂、待补充合同、待归档、已归档)
            if (nullFields.contains("contractStatus")) {
                update.setNull(qdo.contractStatus);
            }
            // 签订日期
            if (nullFields.contains("signDate")) {
                update.setNull(qdo.signDate);
            }
            // 生效日期
            if (nullFields.contains("effectiveDate")) {
                update.setNull(qdo.effectiveDate);
            }
            // 失效日期
            if (nullFields.contains("expiryDate")) {
                update.setNull(qdo.expiryDate);
            }
            // 销售负责人udc
            if (nullFields.contains("saleDutyId")) {
                update.setNull(qdo.saleDutyId);
            }
            // 采购负责人udc
            if (nullFields.contains("purchaseDutyId")) {
                update.setNull(qdo.purchaseDutyId);
            }
            // 交付负责人udc
            if (nullFields.contains("payDutyId")) {
                update.setNull(qdo.payDutyId);
            }
            // 关联商机主键
            if (nullFields.contains("relateBusinessId")) {
                update.setNull(qdo.relateBusinessId);
            }
            // 关联商机名称(冗余)
            if (nullFields.contains("relateBusinessName")) {
                update.setNull(qdo.relateBusinessName);
            }
            // 关联合同主键
            if (nullFields.contains("relateContractId")) {
                update.setNull(qdo.relateContractId);
            }
            // 关联合同名称(冗余)
            if (nullFields.contains("relateContractName")) {
                update.setNull(qdo.relateContractName);
            }
            // 财务期间主键（预留后期用）
            if (nullFields.contains("fiscalPeriodId")) {
                update.setNull(qdo.fiscalPeriodId);
            }
            // 财务期间(年+月的级联)
            if (nullFields.contains("fiscalPeriod")) {
                update.setNull(qdo.fiscalPeriod);
            }
            // 合同分类主键（预留后期用）
            if (nullFields.contains("categoryId")) {
                update.setNull(qdo.categoryId);
            }
            // 合同分类(冗余级联) udcName1/udcName2/udcName3
            if (nullFields.contains("categoryDesc")) {
                update.setNull(qdo.categoryDesc);
            }
            // 签单部门主键
            if (nullFields.contains("signOrgId")) {
                update.setNull(qdo.signOrgId);
            }
            // 签单部门名称(冗余)
            if (nullFields.contains("signOrgName")) {
                update.setNull(qdo.signOrgName);
            }
            // 采购部门主键
            if (nullFields.contains("purchaseOrgId")) {
                update.setNull(qdo.purchaseOrgId);
            }
            // 采购部门名称(冗余)
            if (nullFields.contains("purchaseOrgName")) {
                update.setNull(qdo.purchaseOrgName);
            }
            // 交付部门主键
            if (nullFields.contains("payOrgId")) {
                update.setNull(qdo.payOrgId);
            }
            // 交付部门名称(冗余)
            if (nullFields.contains("payOrgName")) {
                update.setNull(qdo.payOrgName);
            }
            // 合同附件1
            if (nullFields.contains("contractFile1")) {
                update.setNull(qdo.contractFile1);
            }
            // 合同附件2
            if (nullFields.contains("contractFile2")) {
                update.setNull(qdo.contractFile2);
            }
            // 合同附件3
            if (nullFields.contains("contractFile3")) {
                update.setNull(qdo.contractFile3);
            }
            // 合同附件4
            if (nullFields.contains("contractFile4")) {
                update.setNull(qdo.contractFile4);
            }
            // 合同附件5
            if (nullFields.contains("contractFile5")) {
                update.setNull(qdo.contractFile5);
            }
            // 流程实例ID
            if (nullFields.contains("procInstId")) {
                update.setNull(qdo.procInstId);
            }
            // 流程审批状态
            if (nullFields.contains("procInstStatus")) {
                update.setNull(qdo.procInstStatus);
            }
            // 提交时间
            if (nullFields.contains("submitTime")) {
                update.setNull(qdo.submitTime);
            }
            // 审批时间
            if (nullFields.contains("approvedTime")) {
                update.setNull(qdo.approvedTime);
            }
            // 版本
            if (nullFields.contains("version")) {
                update.setNull(qdo.version);
            }
            // 排序号
            if (nullFields.contains("sortNo")) {
                update.setNull(qdo.sortNo);
            }
            // 税率
            if (nullFields.contains("taxRate")) {
                update.setNull(qdo.taxRate);
            }
            // 有效合同金额
            if (nullFields.contains("effectiveAmt")) {
                update.setNull(qdo.effectiveAmt);
            }
            // 主从合同类型
            if (nullFields.contains("mainType")) {
                update.setNull(qdo.mainType);
            }
            // 拓展字段1
            if (nullFields.contains("ext1")) {
                update.setNull(qdo.ext1);
            }
            // 拓展字段2
            if (nullFields.contains("ext2")) {
                update.setNull(qdo.ext2);
            }
            // 拓展字段3
            if (nullFields.contains("ext3")) {
                update.setNull(qdo.ext3);
            }
            // 拓展字段4
            if (nullFields.contains("ext4")) {
                update.setNull(qdo.ext4);
            }
            // 拓展字段5
            if (nullFields.contains("ext5")) {
                update.setNull(qdo.ext5);
            }
            // 拓展字段6
            if (nullFields.contains("ext6")) {
                update.setNull(qdo.ext6);
            }
            // 拓展字段7
            if (nullFields.contains("ext7")) {
                update.setNull(qdo.ext7);
            }
            // 拓展字段8
            if (nullFields.contains("ext8")) {
                update.setNull(qdo.ext8);
            }
            // 拓展字段9
            if (nullFields.contains("ext9")) {
                update.setNull(qdo.ext9);
            }
            // 拓展字段10
            if (nullFields.contains("ext10")) {
                update.setNull(qdo.ext10);
            }
        }
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        // 执行修改
        return update.execute();
    }

    /**
     * 逻辑删除
     *
     * @param keys 主集合
     * @return 删除的行数
     */
    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
            .set(qdo.deleteFlag, 1)
            .where(qdo.id.in(keys));
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        return update.execute();
    }

    /**
     * 更新工作流程
     *
     * @param payload 有效载荷
     * @return long
     */
    public long updateWorkFlow(ContractPayload payload) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
            .where(qdo.id.eq(payload.getId()));

        // 流程实例id
        if (!ObjectUtils.isEmpty(payload.getProcInstId())) {
            update.set(qdo.procInstId, payload.getProcInstId());
        } else {
            update.setNull(qdo.procInstId);
        }
        // 审批状态
        if (!ObjectUtils.isEmpty(payload.getProcInstStatus())) {
            update.set(qdo.procInstStatus, payload.getProcInstStatus());
        } else {
            update.setNull(qdo.procInstStatus);
        }
        // 状态
        if (!ObjectUtils.isEmpty(payload.getContractStatus())) {
            update.set(qdo.contractStatus, payload.getContractStatus());
        } else {
            update.setNull(qdo.contractStatus);
        }
        // 提审时间
        if (!ObjectUtils.isEmpty(payload.getSubmitTime())) {
            update.set(qdo.submitTime, payload.getSubmitTime());
        }
        // 审批结束时间
        if (!ObjectUtils.isEmpty(payload.getApprovedTime())) {
            update.set(qdo.approvedTime, payload.getApprovedTime());
        }
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        // 执行修改
        return update.execute();
    }

    public List<ContractVO> queryByParentKey(Long id) {
        JPAQuery<ContractVO> jpaQuery=getJpaQuerySelect();
        jpaQuery.where(qdo.parentId.eq(id));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetch();
    }


    public List<ContractSimpleVO> listSimpleParentId(ContractQuery query) {
        JPAQuery<ContractSimpleVO> jpaQuery= getJpaQuerySimpleSelect();
        jpaQuery.where(whereSimple(query));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetch();
    }
}

