package com.elitesland.tw.tw5crm.server.contract.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5crm.api.contract.payload.ContractInvoicePayload;
import com.elitesland.tw.tw5crm.api.contract.query.ContractInvoiceQuery;
import com.elitesland.tw.tw5crm.api.contract.vo.ContractInvoiceVO;
import com.elitesland.tw.tw5crm.server.contract.entity.ContractInvoiceDO;
import com.elitesland.tw.tw5crm.server.contract.entity.QContractInvoiceDO;
import com.elitesland.tw.tw5crm.server.contract.repo.ContractInvoiceRepo;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * 合同管理-发票详情
 *
 * @author wangly
 * @date 2023-04-25
 */
@Repository
@RequiredArgsConstructor
public class ContractInvoiceDAO {

    private final JPAQueryFactory jpaQueryFactory;
    private final ContractInvoiceRepo repo;
    private final QContractInvoiceDO qdo = QContractInvoiceDO.contractInvoiceDO;

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<ContractInvoiceVO> getJpaQuerySelect() {
        return jpaQueryFactory.select(Projections.bean(ContractInvoiceVO.class,
                qdo.id,
                //qdo.remark,
                //qdo.createUserId,
                //qdo.creator,
                //qdo.createTime,
                //qdo.modifyUserId,
                //qdo.updater,
                //qdo.modifyTime,
                // 开票申请表id
                qdo.billingId,
                // 开票申请表流水号
                qdo.billingCode,
                // 发票类型 udc[CRM:CONTRACT:INVOICE_TYPE]
                qdo.invoiceType,
                // 开票主体
                qdo.billingMainbody,
                // 归属人ID
                qdo.belongUserId,
                // 发票状态 udc[CRM:CONTRACT:INVOICE_STATUS]
                qdo.invoiceStatus,
                // 发票来源
                qdo.invoiceSource,
                // 币种 udc[SYSTEM_BASIC:CURRENCY]
                qdo.currCode,
                // 发票抬头名称(购买方名称)
                qdo.invoiceTitle,
                // 发票代码
                qdo.invoiceCode,
                // 发票号码
                qdo.invoiceTaxNum,
                // 发票税号(购买方纳税人识别号)
                qdo.invoiceTaxNo,
                // 开户银行
                qdo.accountBank,
                // 银行账户
                qdo.account,
                // 发票金额(含税)
                qdo.invoiceTotalAmount,
                // 发票金额(不含税)
                qdo.invoiceAmount,
                // 发票税率 udc[CRM:CONTRACT:TAX_RATE]
                qdo.taxRate,
                // 发票税额
                qdo.invoiceTax,
                // 开票日期
                qdo.invoiceDate,
                // 注册地址
                qdo.registerAddress,
                // 注册电话
                qdo.registerPhone,
                // 更新时间
                qdo.updateTime,
                // 附件1
                qdo.fileCodes1,
                // 附件2
                qdo.fileCodes2,
                // 附件3
                qdo.fileCodes3,
                // 附件4
                qdo.fileCodes4,
                // 附件5
                qdo.fileCodes5,
                // 版本
                qdo.version,
                // 排序号
                qdo.sortNo,
                // 拓展字段1
                qdo.ext1,
                // 拓展字段2
                qdo.ext2,
                // 拓展字段3
                qdo.ext3,
                // 拓展字段4
                qdo.ext4,
                // 拓展字段5
                qdo.ext5,
                // 拓展字段6
                qdo.ext6,
                // 拓展字段7
                qdo.ext7,
                // 拓展字段8
                qdo.ext8,
                // 拓展字段9
                qdo.ext9
        )).from(qdo);
    }

    /**
     * 拼装查询条件
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    private JPAQuery<ContractInvoiceVO> getJpaQueryWhere(ContractInvoiceQuery query) {
        JPAQuery<ContractInvoiceVO> jpaQuery = getJpaQuerySelect();
            // 条件封装
            jpaQuery.where(where(query));
            // 常用基础查询条件拼装
            SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
            // 动态排序
            jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
            return jpaQuery;
            }

    /**
     * 统计
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    public long count(ContractInvoiceQuery query) {
        long total = jpaQueryFactory
            .select(qdo.count())
            .from(qdo)
            .where(where(query))
            .fetchOne();
        return total;
    }

    /**
     * 查询条件封装
     *
     * @param query 条件
     * @return {@link Predicate}
     */
    private Predicate where(ContractInvoiceQuery query){
        List<Predicate> list = new ArrayList<>();
        /** 记录唯一ID 精确 */
        if (!ObjectUtils.isEmpty(query.getId())) {
            list.add(qdo.id.eq(query.getId()));
        }
        /** 开票申请表id 精确 */
        if (!ObjectUtils.isEmpty(query.getBillingId())) {
            list.add(qdo.billingId.eq(query.getBillingId()));
        }
        /** 开票申请表流水号 精确 */
        if (!ObjectUtils.isEmpty(query.getBillingCode())) {
            list.add(qdo.billingCode.eq(query.getBillingCode()));
        }
        /** 发票类型 udc[CRM:CONTRACT:INVOICE_TYPE] 精确 */
        if (!ObjectUtils.isEmpty(query.getInvoiceType())) {
            list.add(qdo.invoiceType.eq(query.getInvoiceType()));
        }
        /** 开票主体 精确 */
        if (!ObjectUtils.isEmpty(query.getBillingMainbody())) {
            list.add(qdo.billingMainbody.eq(query.getBillingMainbody()));
        }
        /** 归属人ID 精确 */
        if (!ObjectUtils.isEmpty(query.getBelongUserId())) {
            list.add(qdo.belongUserId.eq(query.getBelongUserId()));
        }
        /** 发票状态 udc[CRM:CONTRACT:INVOICE_STATUS] 精确 */
        if (!ObjectUtils.isEmpty(query.getInvoiceStatus())) {
            list.add(qdo.invoiceStatus.eq(query.getInvoiceStatus()));
        }
        /** 发票来源 精确 */
        if (!ObjectUtils.isEmpty(query.getInvoiceSource())) {
            list.add(qdo.invoiceSource.eq(query.getInvoiceSource()));
        }
        /** 币种 udc[SYSTEM_BASIC:CURRENCY] 精确 */
        if (!ObjectUtils.isEmpty(query.getCurrCode())) {
            list.add(qdo.currCode.eq(query.getCurrCode()));
        }
        /** 发票抬头名称(购买方名称) 精确 */
        if (!ObjectUtils.isEmpty(query.getInvoiceTitle())) {
            list.add(qdo.invoiceTitle.eq(query.getInvoiceTitle()));
        }
        /** 发票代码 精确 */
        if (!ObjectUtils.isEmpty(query.getInvoiceCode())) {
            list.add(qdo.invoiceCode.eq(query.getInvoiceCode()));
        }
        /** 发票号码 精确 */
        if (!ObjectUtils.isEmpty(query.getInvoiceTaxNum())) {
            list.add(qdo.invoiceTaxNum.eq(query.getInvoiceTaxNum()));
        }
        /** 发票税号(购买方纳税人识别号) 精确 */
        if (!ObjectUtils.isEmpty(query.getInvoiceTaxNo())) {
            list.add(qdo.invoiceTaxNo.eq(query.getInvoiceTaxNo()));
        }
        /** 开户银行 精确 */
        if (!ObjectUtils.isEmpty(query.getAccountBank())) {
            list.add(qdo.accountBank.eq(query.getAccountBank()));
        }
        /** 银行账户 精确 */
        if (!ObjectUtils.isEmpty(query.getAccount())) {
            list.add(qdo.account.eq(query.getAccount()));
        }
        /** 发票金额(含税) 精确 */
        if (!ObjectUtils.isEmpty(query.getInvoiceTotalAmount())) {
            list.add(qdo.invoiceTotalAmount.eq(query.getInvoiceTotalAmount()));
        }
        /** 发票金额(不含税) 精确 */
        if (!ObjectUtils.isEmpty(query.getInvoiceAmount())) {
            list.add(qdo.invoiceAmount.eq(query.getInvoiceAmount()));
        }
        /** 发票税率 udc[CRM:CONTRACT:TAX_RATE] 精确 */
        if (!ObjectUtils.isEmpty(query.getTaxRate())) {
            list.add(qdo.taxRate.eq(query.getTaxRate()));
        }
        /** 发票税额 精确 */
        if (!ObjectUtils.isEmpty(query.getInvoiceTax())) {
            list.add(qdo.invoiceTax.eq(query.getInvoiceTax()));
        }
        /** 开票日期 精确 */
        if (!ObjectUtils.isEmpty(query.getInvoiceDate())) {
            list.add(qdo.invoiceDate.eq(query.getInvoiceDate()));
        }
        /** 注册地址 精确 */
        if (!ObjectUtils.isEmpty(query.getRegisterAddress())) {
            list.add(qdo.registerAddress.eq(query.getRegisterAddress()));
        }
        /** 注册电话 精确 */
        if (!ObjectUtils.isEmpty(query.getRegisterPhone())) {
            list.add(qdo.registerPhone.eq(query.getRegisterPhone()));
        }
        /** 更新时间 精确 */
        if (!ObjectUtils.isEmpty(query.getUpdateTime())) {
            list.add(qdo.updateTime.eq(query.getUpdateTime()));
        }
        /** 附件1 精确 */
        if (!ObjectUtils.isEmpty(query.getFileCodes1())) {
            list.add(qdo.fileCodes1.eq(query.getFileCodes1()));
        }
        /** 附件2 精确 */
        if (!ObjectUtils.isEmpty(query.getFileCodes2())) {
            list.add(qdo.fileCodes2.eq(query.getFileCodes2()));
        }
        /** 附件3 精确 */
        if (!ObjectUtils.isEmpty(query.getFileCodes3())) {
            list.add(qdo.fileCodes3.eq(query.getFileCodes3()));
        }
        /** 附件4 精确 */
        if (!ObjectUtils.isEmpty(query.getFileCodes4())) {
            list.add(qdo.fileCodes4.eq(query.getFileCodes4()));
        }
        /** 附件5 精确 */
        if (!ObjectUtils.isEmpty(query.getFileCodes5())) {
            list.add(qdo.fileCodes5.eq(query.getFileCodes5()));
        }
        /** 版本 精确 */
        if (!ObjectUtils.isEmpty(query.getVersion())) {
            list.add(qdo.version.eq(query.getVersion()));
        }
        /** 排序号 精确 */
        if (!ObjectUtils.isEmpty(query.getSortNo())) {
            list.add(qdo.sortNo.eq(query.getSortNo()));
        }
        /** 拓展字段1 精确 */
        if (!ObjectUtils.isEmpty(query.getExt1())) {
            list.add(qdo.ext1.eq(query.getExt1()));
        }
        /** 拓展字段2 精确 */
        if (!ObjectUtils.isEmpty(query.getExt2())) {
            list.add(qdo.ext2.eq(query.getExt2()));
        }
        /** 拓展字段3 精确 */
        if (!ObjectUtils.isEmpty(query.getExt3())) {
            list.add(qdo.ext3.eq(query.getExt3()));
        }
        /** 拓展字段4 精确 */
        if (!ObjectUtils.isEmpty(query.getExt4())) {
            list.add(qdo.ext4.eq(query.getExt4()));
        }
        /** 拓展字段5 精确 */
        if (!ObjectUtils.isEmpty(query.getExt5())) {
            list.add(qdo.ext5.eq(query.getExt5()));
        }
        /** 拓展字段6 精确 */
        if (!ObjectUtils.isEmpty(query.getExt6())) {
            list.add(qdo.ext6.eq(query.getExt6()));
        }
        /** 拓展字段7 精确 */
        if (!ObjectUtils.isEmpty(query.getExt7())) {
            list.add(qdo.ext7.eq(query.getExt7()));
        }
        /** 拓展字段8 精确 */
        if (!ObjectUtils.isEmpty(query.getExt8())) {
            list.add(qdo.ext8.eq(query.getExt8()));
        }
        /** 拓展字段9 精确 */
        if (!ObjectUtils.isEmpty(query.getExt9())) {
            list.add(qdo.ext9.eq(query.getExt9()));
        }
        return ExpressionUtils.allOf(list);
    }

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 结果
     */
    public ContractInvoiceVO queryByKey(Long id) {
        JPAQuery<ContractInvoiceVO> jpaQuery = getJpaQuerySelect();
            jpaQuery.where(qdo.id.eq(id));
            jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    /**
     * 动态查询集合
     *
     * @param query 查询参数
     * @return 结果集合
     */
    public List<ContractInvoiceVO> queryListDynamic(ContractInvoiceQuery query) {
        JPAQuery<ContractInvoiceVO> jpaQuery = getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    /**
     * 根据开票申请ID查询发票详情
     *
     * @param billingId 开票申请ID
     * @return 结果集合
     */
    public ContractInvoiceVO queryInvoicetByBillingId(Long billingId) {
        ContractInvoiceVO contractInvoiceVO = jpaQueryFactory.select(Projections.bean(ContractInvoiceVO.class,

                qdo.id,
                qdo.billingId,
                qdo.billingCode,
                // 发票类型 udc[CRM:CONTRACT:INVOICE_TYPE]
                qdo.invoiceType,
                // 开票主体
                qdo.billingMainbody,
                // 发票抬头名称(购买方名称)
                qdo.invoiceTitle,
                // 发票代码
                qdo.invoiceCode,
                // 发票号码
                qdo.invoiceTaxNum,
                // 发票税号(购买方纳税人识别号)
                qdo.invoiceTaxNo,
                // 开户银行
                qdo.accountBank,
                // 银行账户
                qdo.account,
                // 发票税率 udc[CRM:CONTRACT:TAX_RATE]
                qdo.taxRate,
                // 发票税额
                qdo.invoiceTax,
                // 开票日期
                qdo.invoiceDate,

                // 注册地址
                qdo.registerAddress,
                // 注册电话
                qdo.registerPhone,
                qdo.fileCodes1)).from(qdo).where(qdo.billingId.eq(billingId)).fetchOne();
        return contractInvoiceVO;
    }


    /**
     * 分页查询
     *
     * @param query 查询参数
     * @return 分页结果
     */
    public PagingVO<ContractInvoiceVO> queryPaging(ContractInvoiceQuery query) {
        long total = count(query);
        if (total == 0) {
             return PagingVO.empty();
        }
        JPAQuery<ContractInvoiceVO> jpaQuery = getJpaQueryWhere(query);
        List<ContractInvoiceVO> result = jpaQuery
                .offset(query.getPageRequest().getOffset())
                .limit(query.getPageRequest().getPageSize())
                .fetch();
        return PagingVO.<ContractInvoiceVO>builder().records(result).total(total).build();
    }

    /**
     * 调用jpa的保存
     *
     * @param ado do对象
     * @return 保存后的对象
     */
    public ContractInvoiceDO save(ContractInvoiceDO ado) {
        return repo.save(ado);
    }

    /**
     * 调用jpa的保存所有
     *
     * @param dos 多个do对象
     * @return 保存后的对象集合
     */
    public List<ContractInvoiceDO> saveAll(List<ContractInvoiceDO> dos) {
        return repo.saveAll(dos);
    }

    /**
     * 按主键动态修改（只修非null字段，如果需要将某些字段修改为null，请添加nullFields）
     *
     * @param payload 要修改的对象
     * @return 修改的行数
     */
    @Transactional
    public long updateByKeyDynamic(ContractInvoicePayload payload) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
        .where(qdo.id.eq(payload.getId()));
        // 记录唯一ID
        if (payload.getId() != null) {
            update.set(qdo.id, payload.getId());
        }
        // 开票申请表id
        if (payload.getBillingId() != null) {
            update.set(qdo.billingId, payload.getBillingId());
        }
        // 开票申请表流水号
        if (payload.getBillingCode() != null) {
            update.set(qdo.billingCode, payload.getBillingCode());
        }
        // 发票类型 udc[CRM:CONTRACT:INVOICE_TYPE]
        if (payload.getInvoiceType() != null) {
            update.set(qdo.invoiceType, payload.getInvoiceType());
        }
        // 开票主体
        if (payload.getBillingMainbody() != null) {
            update.set(qdo.billingMainbody, payload.getBillingMainbody());
        }
        // 归属人ID
        if (payload.getBelongUserId() != null) {
            update.set(qdo.belongUserId, payload.getBelongUserId());
        }
        // 发票状态 udc[CRM:CONTRACT:INVOICE_STATUS]
        if (payload.getInvoiceStatus() != null) {
            update.set(qdo.invoiceStatus, payload.getInvoiceStatus());
        }
        // 发票来源
        if (payload.getInvoiceSource() != null) {
            update.set(qdo.invoiceSource, payload.getInvoiceSource());
        }
        // 币种 udc[SYSTEM_BASIC:CURRENCY]
        if (payload.getCurrCode() != null) {
            update.set(qdo.currCode, payload.getCurrCode());
        }
        // 发票抬头名称(购买方名称)
        if (payload.getInvoiceTitle() != null) {
            update.set(qdo.invoiceTitle, payload.getInvoiceTitle());
        }
        // 发票代码
        if (payload.getInvoiceCode() != null) {
            update.set(qdo.invoiceCode, payload.getInvoiceCode());
        }
        // 发票号码
        if (payload.getInvoiceTaxNum() != null) {
            update.set(qdo.invoiceTaxNum, payload.getInvoiceTaxNum());
        }
        // 发票税号(购买方纳税人识别号)
        if (payload.getInvoiceTaxNo() != null) {
            update.set(qdo.invoiceTaxNo, payload.getInvoiceTaxNo());
        }
        // 开户银行
        if (payload.getAccountBank() != null) {
            update.set(qdo.accountBank, payload.getAccountBank());
        }
        // 银行账户
        if (payload.getAccount() != null) {
            update.set(qdo.account, payload.getAccount());
        }
        // 发票金额(含税)
        if (payload.getInvoiceTotalAmount() != null) {
            update.set(qdo.invoiceTotalAmount, payload.getInvoiceTotalAmount());
        }
        // 发票金额(不含税)
        if (payload.getInvoiceAmount() != null) {
            update.set(qdo.invoiceAmount, payload.getInvoiceAmount());
        }
        // 发票税率 udc[CRM:CONTRACT:TAX_RATE]
        if (payload.getTaxRate() != null) {
            update.set(qdo.taxRate, payload.getTaxRate());
        }
        // 发票税额
        if (payload.getInvoiceTax() != null) {
            update.set(qdo.invoiceTax, payload.getInvoiceTax());
        }
        // 开票日期
        if (payload.getInvoiceDate() != null) {
            update.set(qdo.invoiceDate, payload.getInvoiceDate());
        }
        // 注册地址
        if (payload.getRegisterAddress() != null) {
            update.set(qdo.registerAddress, payload.getRegisterAddress());
        }
        // 注册电话
        if (payload.getRegisterPhone() != null) {
            update.set(qdo.registerPhone, payload.getRegisterPhone());
        }
        // 更新时间
        if (payload.getUpdateTime() != null) {
            update.set(qdo.updateTime, payload.getUpdateTime());
        }
        // 附件1
        if (payload.getFileCodes1() != null) {
            update.set(qdo.fileCodes1, payload.getFileCodes1());
        }
        // 附件2
        if (payload.getFileCodes2() != null) {
            update.set(qdo.fileCodes2, payload.getFileCodes2());
        }
        // 附件3
        if (payload.getFileCodes3() != null) {
            update.set(qdo.fileCodes3, payload.getFileCodes3());
        }
        // 附件4
        if (payload.getFileCodes4() != null) {
            update.set(qdo.fileCodes4, payload.getFileCodes4());
        }
        // 附件5
        if (payload.getFileCodes5() != null) {
            update.set(qdo.fileCodes5, payload.getFileCodes5());
        }
        // 版本
        if (payload.getVersion() != null) {
            update.set(qdo.version, payload.getVersion());
        }
        // 排序号
        if (payload.getSortNo() != null) {
            update.set(qdo.sortNo, payload.getSortNo());
        }
        // 拓展字段1
        if (payload.getExt1() != null) {
            update.set(qdo.ext1, payload.getExt1());
        }
        // 拓展字段2
        if (payload.getExt2() != null) {
            update.set(qdo.ext2, payload.getExt2());
        }
        // 拓展字段3
        if (payload.getExt3() != null) {
            update.set(qdo.ext3, payload.getExt3());
        }
        // 拓展字段4
        if (payload.getExt4() != null) {
            update.set(qdo.ext4, payload.getExt4());
        }
        // 拓展字段5
        if (payload.getExt5() != null) {
            update.set(qdo.ext5, payload.getExt5());
        }
        // 拓展字段6
        if (payload.getExt6() != null) {
            update.set(qdo.ext6, payload.getExt6());
        }
        // 拓展字段7
        if (payload.getExt7() != null) {
            update.set(qdo.ext7, payload.getExt7());
        }
        // 拓展字段8
        if (payload.getExt8() != null) {
            update.set(qdo.ext8, payload.getExt8());
        }
        // 拓展字段9
        if (payload.getExt9() != null) {
            update.set(qdo.ext9, payload.getExt9());
        }
        // 处理要设置成空的字段
        List<String> nullFields = payload.getNullFields();
        if (nullFields != null && nullFields.size() > 0) {
            // 记录唯一ID
            if (nullFields.contains("id")) {
                update.setNull(qdo.id);
            }
            // 开票申请表id
            if (nullFields.contains("billingId")) {
                update.setNull(qdo.billingId);
            }
            // 开票申请表流水号
            if (nullFields.contains("billingCode")) {
                update.setNull(qdo.billingCode);
            }
            // 发票类型 udc[CRM:CONTRACT:INVOICE_TYPE]
            if (nullFields.contains("invoiceType")) {
                update.setNull(qdo.invoiceType);
            }
            // 开票主体
            if (nullFields.contains("billingMainbody")) {
                update.setNull(qdo.billingMainbody);
            }
            // 归属人ID
            if (nullFields.contains("belongUserId")) {
                update.setNull(qdo.belongUserId);
            }
            // 发票状态 udc[CRM:CONTRACT:INVOICE_STATUS]
            if (nullFields.contains("invoiceStatus")) {
                update.setNull(qdo.invoiceStatus);
            }
            // 发票来源
            if (nullFields.contains("invoiceSource")) {
                update.setNull(qdo.invoiceSource);
            }
            // 币种 udc[SYSTEM_BASIC:CURRENCY]
            if (nullFields.contains("currCode")) {
                update.setNull(qdo.currCode);
            }
            // 发票抬头名称(购买方名称)
            if (nullFields.contains("invoiceTitle")) {
                update.setNull(qdo.invoiceTitle);
            }
            // 发票代码
            if (nullFields.contains("invoiceCode")) {
                update.setNull(qdo.invoiceCode);
            }
            // 发票号码
            if (nullFields.contains("invoiceTaxNum")) {
                update.setNull(qdo.invoiceTaxNum);
            }
            // 发票税号(购买方纳税人识别号)
            if (nullFields.contains("invoiceTaxNo")) {
                update.setNull(qdo.invoiceTaxNo);
            }
            // 开户银行
            if (nullFields.contains("accountBank")) {
                update.setNull(qdo.accountBank);
            }
            // 银行账户
            if (nullFields.contains("account")) {
                update.setNull(qdo.account);
            }
            // 发票金额(含税)
            if (nullFields.contains("invoiceTotalAmount")) {
                update.setNull(qdo.invoiceTotalAmount);
            }
            // 发票金额(不含税)
            if (nullFields.contains("invoiceAmount")) {
                update.setNull(qdo.invoiceAmount);
            }
            // 发票税率 udc[CRM:CONTRACT:TAX_RATE]
            if (nullFields.contains("taxRate")) {
                update.setNull(qdo.taxRate);
            }
            // 发票税额
            if (nullFields.contains("invoiceTax")) {
                update.setNull(qdo.invoiceTax);
            }
            // 开票日期
            if (nullFields.contains("invoiceDate")) {
                update.setNull(qdo.invoiceDate);
            }
            // 注册地址
            if (nullFields.contains("registerAddress")) {
                update.setNull(qdo.registerAddress);
            }
            // 注册电话
            if (nullFields.contains("registerPhone")) {
                update.setNull(qdo.registerPhone);
            }
            // 更新时间
            if (nullFields.contains("updateTime")) {
                update.setNull(qdo.updateTime);
            }
            // 附件1
            if (nullFields.contains("fileCodes1")) {
                update.setNull(qdo.fileCodes1);
            }
            // 附件2
            if (nullFields.contains("fileCodes2")) {
                update.setNull(qdo.fileCodes2);
            }
            // 附件3
            if (nullFields.contains("fileCodes3")) {
                update.setNull(qdo.fileCodes3);
            }
            // 附件4
            if (nullFields.contains("fileCodes4")) {
                update.setNull(qdo.fileCodes4);
            }
            // 附件5
            if (nullFields.contains("fileCodes5")) {
                update.setNull(qdo.fileCodes5);
            }
            // 版本
            if (nullFields.contains("version")) {
                update.setNull(qdo.version);
            }
            // 排序号
            if (nullFields.contains("sortNo")) {
                update.setNull(qdo.sortNo);
            }
            // 拓展字段1
            if (nullFields.contains("ext1")) {
                update.setNull(qdo.ext1);
            }
            // 拓展字段2
            if (nullFields.contains("ext2")) {
                update.setNull(qdo.ext2);
            }
            // 拓展字段3
            if (nullFields.contains("ext3")) {
                update.setNull(qdo.ext3);
            }
            // 拓展字段4
            if (nullFields.contains("ext4")) {
                update.setNull(qdo.ext4);
            }
            // 拓展字段5
            if (nullFields.contains("ext5")) {
                update.setNull(qdo.ext5);
            }
            // 拓展字段6
            if (nullFields.contains("ext6")) {
                update.setNull(qdo.ext6);
            }
            // 拓展字段7
            if (nullFields.contains("ext7")) {
                update.setNull(qdo.ext7);
            }
            // 拓展字段8
            if (nullFields.contains("ext8")) {
                update.setNull(qdo.ext8);
            }
            // 拓展字段9
            if (nullFields.contains("ext9")) {
                update.setNull(qdo.ext9);
            }
        }
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        // 执行修改
        return update.execute();
    }

    /**
     * 逻辑删除
     *
     * @param keys 主集合
     * @return 删除的行数
     */
    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
            .set(qdo.deleteFlag, 1)
            .where(qdo.id.in(keys));
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        return update.execute();
    }

    /**
     * 通过开票申请表ID查询
     *
     * @param billingId 开票申请表ID
     * @return ContractInvoiceVO
     */
    public ContractInvoiceVO queryByBillingId(long billingId) {
        JPAQuery<ContractInvoiceVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.billingId.eq(billingId));
        return jpaQuery.fetchOne();
    }
}

