package com.elitesland.tw.tw5crm.server.contract.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5crm.api.contract.payload.ContractReceiveAccountPayload;
import com.elitesland.tw.tw5crm.api.contract.query.ContractReceiveAccountQuery;
import com.elitesland.tw.tw5crm.api.contract.vo.ContractAccountNameVO;
import com.elitesland.tw.tw5crm.api.contract.vo.ContractReceiveAccountVO;
import com.elitesland.tw.tw5crm.server.contract.entity.CrmContractReceiveAccountDO;
import com.elitesland.tw.tw5crm.server.contract.entity.QCrmContractReceiveAccountDO;
import com.elitesland.tw.tw5crm.server.contract.repo.CrmContractReceiveAccountRepo;
import com.querydsl.core.QueryResults;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * 取款录入
 *
 * @author zach.zhang
 * @date 2023-04-19
 */
@Repository
@RequiredArgsConstructor
public class CrmContractReceiveAccountDAO {

    private final JPAQueryFactory jpaQueryFactory;
    private final CrmContractReceiveAccountRepo repo;
    private final QCrmContractReceiveAccountDO qdo = QCrmContractReceiveAccountDO.crmContractReceiveAccountDO;

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<ContractReceiveAccountVO> getJpaQuerySelect() {
        return jpaQueryFactory.select(Projections.bean(ContractReceiveAccountVO.class,
                qdo.id,
                qdo.remark,
                qdo.createUserId,
                qdo.creator,
                qdo.createTime,
                //qdo.modifyUserId,
                //qdo.updater,
                //qdo.modifyTime,
                // 流水号
                qdo.receiveAccountNo,
                // 到款金额
                qdo.receiveAccount,
                // 到款日期
                qdo.receiveDate,
                // 开户名称
                qdo.accountName,
                // 开户银行
                qdo.accountBank,
                // 银行账户
                qdo.account,
                // 税号
                qdo.taxNo,
                // 注册地址
                qdo.registerAddress,
                // 注册电话
                qdo.registerPhone,
                // 附件
                qdo.fileCodes,
                qdo.creator,
                qdo.remark,
                // 拓展字段1
                qdo.ext1,
                // 拓展字段2
                qdo.ext2,
                // 拓展字段3
                qdo.ext3,
                // 拓展字段4
                qdo.ext4,
                // 拓展字段5
                qdo.ext5
        )).from(qdo);
    }



    public List<ContractReceiveAccountVO> queryAllAccount() {
        JPAQuery<ContractReceiveAccountVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetch();
    }

    /**
     * 拼装查询条件
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    private JPAQuery<ContractReceiveAccountVO> getJpaQueryWhere(ContractReceiveAccountQuery query) {
        JPAQuery<ContractReceiveAccountVO> jpaQuery = getJpaQuerySelect();
        if (!ObjectUtils.isEmpty(query.getCreateUserId())) {
            jpaQuery.where(qdo.createUserId.eq(query.getCreateUserId()));
        }
        if (!ObjectUtils.isEmpty(query.getReceiveAccountNo())) {
            jpaQuery.where(qdo.receiveAccountNo.eq(query.getReceiveAccountNo()));
        }

        if (StringUtils.hasText(query.getAccountName())){
            jpaQuery.where(qdo.accountName.eq(query.getAccountName()));
        }
        if (!ObjectUtils.isEmpty(query.getReceiveAccount())){
            jpaQuery.where(qdo.receiveAccount.eq(query.getReceiveAccount()));
        }
        if (!ObjectUtils.isEmpty(query.getReceiveDate())) {
            jpaQuery.where(qdo.receiveDate.eq(query.getReceiveDate()));
        }
        if (StringUtils.hasText(query.getAccountName())){
            jpaQuery.where(qdo.accountName.eq(query.getAccountName()));
        }
        if (StringUtils.hasText(query.getAccountBank())){
            jpaQuery.where(qdo.accountBank.contains(query.getAccountBank()));
        }
        if (StringUtils.hasText(query.getAccount())){
            jpaQuery.where(qdo.account.contains(query.getAccount()));
        }

        if (StringUtils.hasText(query.getCreator())){
            jpaQuery.where(qdo.creator.eq(query.getCreator()));
        }
        if (!ObjectUtils.isEmpty(query.getCreateUserId())) {
            jpaQuery.where(qdo.createUserId.eq(query.getCreateUserId()));
        }


        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        // 动态排序
        jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
        return jpaQuery.distinct();
            }




    /**
     * 统计
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    public long count(ContractReceiveAccountQuery query) {
        long total = jpaQueryFactory
            .select(qdo.count())
            .from(qdo)
            .where(where(query))
            .fetchOne();
        return total;
    }

    /**
     * 查询条件封装
     *
     * @param query 条件
     * @return {@link Predicate}
     */
    private Predicate where(ContractReceiveAccountQuery query){
        List<Predicate> list = new ArrayList<>();
        /** id主键 精确 */
        if (!ObjectUtils.isEmpty(query.getId())) {
            list.add(qdo.id.eq(query.getId()));
        }
        /** 流水号 精确 */
        if (!ObjectUtils.isEmpty(query.getReceiveAccountNo())) {
            list.add(qdo.receiveAccountNo.eq(query.getReceiveAccountNo()));
        }
        /** 到款金额 精确 */
        if (!ObjectUtils.isEmpty(query.getReceiveAccount())) {
            list.add(qdo.receiveAccount.eq(query.getReceiveAccount()));
        }
        /** 到款日期 精确 */
        if (!ObjectUtils.isEmpty(query.getReceiveDate())) {
            list.add(qdo.receiveDate.eq(query.getReceiveDate()));
        }
        /** 开户名称 精确 */
        if (!ObjectUtils.isEmpty(query.getAccountName())) {
            list.add(qdo.accountName.eq(query.getAccountName()));
        }
        /** 开户银行 精确 */
        if (!ObjectUtils.isEmpty(query.getAccountBank())) {
            list.add(qdo.accountBank.eq(query.getAccountBank()));
        }
        /** 银行账户 精确 */
        if (!ObjectUtils.isEmpty(query.getAccount())) {
            list.add(qdo.account.eq(query.getAccount()));
        }
        /** 税号 精确 */
        if (!ObjectUtils.isEmpty(query.getTaxNo())) {
            list.add(qdo.taxNo.eq(query.getTaxNo()));
        }
        /** 注册地址 精确 */
        if (!ObjectUtils.isEmpty(query.getRegisterAddress())) {
            list.add(qdo.registerAddress.eq(query.getRegisterAddress()));
        }
        /** 注册电话 精确 */
        if (!ObjectUtils.isEmpty(query.getRegisterPhone())) {
            list.add(qdo.registerPhone.eq(query.getRegisterPhone()));
        }

        return ExpressionUtils.allOf(list);
    }

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 结果
     */
    public ContractReceiveAccountVO queryByKey(Long id) {
        JPAQuery<ContractReceiveAccountVO> jpaQuery = getJpaQuerySelect();
            jpaQuery.where(qdo.id.eq(id));
            jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    /**
     * 动态查询集合
     *
     * @param query 查询参数
     * @return 结果集合
     */
    public List<ContractReceiveAccountVO> queryListDynamic(ContractReceiveAccountQuery query) {
        JPAQuery<ContractReceiveAccountVO> jpaQuery = getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    /**
     * 分页查询
     *
     * @param query 查询参数
     * @return 分页结果
     */
    public PagingVO<ContractReceiveAccountVO> queryPaging(ContractReceiveAccountQuery query) {
        JPAQuery<ContractReceiveAccountVO> jpaQuery = getJpaQueryWhere(query);
        QueryResults<ContractReceiveAccountVO> result = jpaQuery.offset(query.getPageRequest().getOffset()).limit(query.getPageRequest().getPageSize()).fetchResults();
        return PagingVO.<ContractReceiveAccountVO>builder().records(result.getResults()).total(result.getTotal()).build();
    }

    /**
     * 调用jpa的保存
     *
     * @param ado do对象
     * @return 保存后的对象
     */
    public CrmContractReceiveAccountDO save(CrmContractReceiveAccountDO ado) {
        return repo.save(ado);
    }

    /**
     * 调用jpa的保存所有
     *
     * @param dos 多个do对象
     * @return 保存后的对象集合
     */
    public List<CrmContractReceiveAccountDO> saveAll(List<CrmContractReceiveAccountDO> dos) {
        return repo.saveAll(dos);
    }

    /**
     * 按主键动态修改（只修非null字段，如果需要将某些字段修改为null，请添加nullFields）
     *
     * @param payload 要修改的对象
     * @return 修改的行数
     */
    @Transactional
    public long updateByKeyDynamic(ContractReceiveAccountPayload payload) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
        .where(qdo.id.eq(payload.getId()));
        // id主键
        if (payload.getId() != null) {
            update.set(qdo.id, payload.getId());
        }
        // 流水号
        if (payload.getReceiveAccountNo() != null) {
            update.set(qdo.receiveAccountNo, payload.getReceiveAccountNo());
        }
        // 到款金额
        if (payload.getReceiveAccount() != null) {
            update.set(qdo.receiveAccount, payload.getReceiveAccount());
        }
        // 到款日期
        if (payload.getReceiveDate() != null) {
            update.set(qdo.receiveDate, payload.getReceiveDate());
        }
        // 开户名称
        if (payload.getAccountName() != null) {
            update.set(qdo.accountName, payload.getAccountName());
        }
        // 开户银行
        if (payload.getAccountBank() != null) {
            update.set(qdo.accountBank, payload.getAccountBank());
        }
        // 银行账户
        if (payload.getAccount() != null) {
            update.set(qdo.account, payload.getAccount());
        }
        // 税号
        if (payload.getTaxNo() != null) {
            update.set(qdo.taxNo, payload.getTaxNo());
        }
        // 注册地址
        if (payload.getRegisterAddress() != null) {
            update.set(qdo.registerAddress, payload.getRegisterAddress());
        }
        // 注册电话
        if (payload.getRegisterPhone() != null) {
            update.set(qdo.registerPhone, payload.getRegisterPhone());
        }
        // 附件
        if (payload.getFileCodes() != null) {
            update.set(qdo.fileCodes, payload.getFileCodes());
        }
        // 拓展字段1
        if (payload.getExt1() != null) {
            update.set(qdo.ext1, payload.getExt1());
        }
        // 拓展字段2
        if (payload.getExt2() != null) {
            update.set(qdo.ext2, payload.getExt2());
        }
        // 拓展字段3
        if (payload.getExt3() != null) {
            update.set(qdo.ext3, payload.getExt3());
        }
        // 拓展字段4
        if (payload.getExt4() != null) {
            update.set(qdo.ext4, payload.getExt4());
        }
        // 拓展字段5
        if (payload.getExt5() != null) {
            update.set(qdo.ext5, payload.getExt5());
        }
        // 处理要设置成空的字段
        List<String> nullFields = payload.getNullFields();
        if (nullFields != null && nullFields.size() > 0) {
            // id主键
            if (nullFields.contains("id")) {
                update.setNull(qdo.id);
            }
            // 流水号
            if (nullFields.contains("receiveAccountNo")) {
                update.setNull(qdo.receiveAccountNo);
            }
            // 到款金额
            if (nullFields.contains("receiveAccount")) {
                update.setNull(qdo.receiveAccount);
            }
            // 到款日期
            if (nullFields.contains("receiveDate")) {
                update.setNull(qdo.receiveDate);
            }
            // 开户名称
            if (nullFields.contains("accountName")) {
                update.setNull(qdo.accountName);
            }
            // 开户银行
            if (nullFields.contains("accountBank")) {
                update.setNull(qdo.accountBank);
            }
            // 银行账户
            if (nullFields.contains("account")) {
                update.setNull(qdo.account);
            }
            // 税号
            if (nullFields.contains("taxNo")) {
                update.setNull(qdo.taxNo);
            }
            // 注册地址
            if (nullFields.contains("registerAddress")) {
                update.setNull(qdo.registerAddress);
            }
            // 注册电话
            if (nullFields.contains("registerPhone")) {
                update.setNull(qdo.registerPhone);
            }
            // 附件
            if (nullFields.contains("fileCodes")) {
                update.setNull(qdo.fileCodes);
            }
            // 拓展字段1
            if (nullFields.contains("ext1")) {
                update.setNull(qdo.ext1);
            }
            // 拓展字段2
            if (nullFields.contains("ext2")) {
                update.setNull(qdo.ext2);
            }
            // 拓展字段3
            if (nullFields.contains("ext3")) {
                update.setNull(qdo.ext3);
            }
            // 拓展字段4
            if (nullFields.contains("ext4")) {
                update.setNull(qdo.ext4);
            }
            // 拓展字段5
            if (nullFields.contains("ext5")) {
                update.setNull(qdo.ext5);
            }
        }
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        // 执行修改
        return update.execute();
    }

    /**
     * 逻辑删除
     *
     * @param keys 主集合
     * @return 删除的行数
     */
    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
            .set(qdo.deleteFlag, 1)
            .where(qdo.id.in(keys));
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        return update.execute();
    }

    public ContractReceiveAccountVO queryByNo(String no) {
        JPAQuery<ContractReceiveAccountVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.receiveAccountNo.eq(no));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    public List<ContractAccountNameVO> listSimple() {
        QCrmContractReceiveAccountDO qdo = QCrmContractReceiveAccountDO.crmContractReceiveAccountDO;
        JPAQuery<ContractAccountNameVO> query = jpaQueryFactory.select(Projections.bean(ContractAccountNameVO.class,
            qdo.accountName,
            qdo.receiveAccountNo
        )).from(qdo);
        return query.fetch();
    }
}

