package com.elitesland.tw.tw5crm.server.contract.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.cloudt.common.base.BaseModel;
import com.elitesland.workflow.enums.ProcInstStatus;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.*;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * 合同管理-开票申请
 *
 * @author wangly
 * @date 2023-04-25
 */
@Entity
@Table(name = "crm_contract_billing_apply", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "crm_contract_billing_apply", comment = "开票申请表")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class ContractBillingApplyDO extends BaseModel implements Serializable  {
    /** 开票流水号 */
    @Comment("开票流水号")
    @Column()
    private String billingCode;
    /** 开票状态 udc[CRM:CONTRACT:BILLING_STATUS] */
    @Comment("开票状态 udc[CRM:CONTRACT:BILLING_STATUS]")
    @Column()
    private String billingStatus;
    /** 客户主键 */
    @ApiModelProperty("客户主键")
    @Column()
    private Long customerId;
    /** 客户名称 */
    @Comment("客户名称（冗余）")
    @Column()
    private String customerName;
    /** 开票主体 */
    @Comment("开票主体")
    @Column()
    private String billingMainbody;
    /** 发票抬头名称(购买方名称) */
    @Comment("发票抬头名称(购买方名称)")
    @Column()
    private String invoiceTitle;
    /** 币种 udc[SYSTEM_BASIC:CURRENCY] */
    @Comment("币种 udc[SYSTEM_BASIC:CURRENCY]")
    @Column()
    private String currCode;
    /** 开票总金额(冗余) */
    @Comment("开票总金额(冗余)")
    @Column()
    private BigDecimal billingTotalAmount;
    /** 发票代码(冗余) */
    @Comment("发票代码(冗余)")
    @Column()
    private String invoiceCode;
    /** 发票号码(冗余) */
    @Comment("发票号码(冗余)")
    @Column()
    private String invoiceTaxNum;
    /** 开票日期 */
    @Comment("开票日期")
    @Column()
    private LocalDate invoiceDate;
    /** 付款方式 udc[CRM:CONTRACT:PAYMENT_METHOD] */
    @Comment("付款方式 udc[CRM:CONTRACT:PAYMENT_METHOD]")
    @Column()
    private String paymentMethod;
    /** 申请人Id */
    @Comment("申请人Id")
    @Column()
    private Long applyUserId;
    /** 申请人名称 */
    @Comment("申请人名称")
    @Column()
    private String applyUserName;
    /** 收件人名称 */
    @Comment("收件人名称")
    @Column()
    private String receiveName;
    /** 收件人地址 */
    @Comment("收件人地址")
    @Column()
    private String  receiveAddress;
    /** 收件人电话 */
    @Comment("收件人电话")
    @Column()
    private String receivePhone;
    /** 收件人邮箱 */
    @Comment("收件人邮箱")
    @Column()
    private String receiveEmail;
    /** 流程实例ID */
    @Comment("流程实例ID")
    @Column()
    private String procInstId;
    /** 流程审批状态 */
    @Comment("流程审批状态")
    @Column()
    @Enumerated(EnumType.STRING)
    private ProcInstStatus procInstStatus;
    /** 提交时间 */
    @Comment("提交时间")
    @Column()
    private LocalDateTime submitTime;
    /** 审批时间 */
    @Comment("审批时间")
    @Column()
    private LocalDateTime approvedTime;
    /** 版本 */
    @Comment("版本")
    @Column()
    private String version;
    /** 更新时间 */
    @Comment("更新时间")
    @Column()
    private LocalDateTime updateTime;
    /** 附件 */
    @Comment("附件")
    @Column()
    private String fileCodes;
    /** 排序号 */
    @Comment("排序号")
    @Column()
    private Integer sortNo;
    /** 拓展字段1 */
    @Comment("拓展字段1")
    @Column()
    private String ext1;
    /** 拓展字段2 */
    @Comment("拓展字段2")
    @Column()
    private String ext2;
    /** 拓展字段3 */
    @Comment("拓展字段3")
    @Column()
    private String ext3;
    /** 拓展字段4 */
    @Comment("拓展字段4")
    @Column()
    private String ext4;
    /** 拓展字段5 */
    @Comment("拓展字段5")
    @Column()
    private String ext5;

    public void copy(ContractBillingApplyDO source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
