package com.elitesland.tw.tw5crm.server.contract.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.cloudt.common.base.BaseModel;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 合同管理-开票明细
 *
 * @author wangly
 * @date 2023-04-25
 */
@Entity
@Table(name = "crm_contract_billing_detail", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "crm_contract_billing_detail", comment = "开票明细表")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class ContractBillingDetailDO extends BaseModel implements Serializable  {
    /** 开票申请表id */
    @Comment("开票申请表id")
    @Column()
    private Long billingId;
    /** 开票流水号 */
    @Comment("开票流水号")
    @Column()
    private String billingCode;
    /** 合同ID */
    @Comment("合同ID")
    @Column()
    private Long contractId;
    /** 收款计划ID */
    @Comment("收款计划ID")
    @Column()
    private Long collectionPlanId;
    /** 合同编号 */
    @Comment("合同编号")
    @Column()
    private String contractCode;
    /** 合同名称 */
    @Comment("合同名称")
    @Column()
    private String contractName;
    /** 收款阶段 */
    @Comment("收款阶段")
    @Column()
    private String collectionStage;
    /** 客户名称 */
    @Comment("客户名称")
    @Column()
    private String customerName;
    /** 开票金额 */
    @Comment("开票金额")
    @Column()
    private BigDecimal billingAmount;
    /** 附件 */
    @Comment("附件")
    @Column()
    private String fileCodes;
    /** 排序号 */
    @Comment("排序号")
    @Column()
    private Integer sortNo;
    /** 拓展字段1 */
    @Comment("拓展字段1")
    @Column()
    private String ext1;
    /** 拓展字段2 */
    @Comment("拓展字段2")
    @Column()
    private String ext2;
    /** 拓展字段3 */
    @Comment("拓展字段3")
    @Column()
    private String ext3;
    /** 拓展字段4 */
    @Comment("拓展字段4")
    @Column()
    private String ext4;
    /** 拓展字段5 */
    @Comment("拓展字段5")
    @Column()
    private String ext5;

    public void copy(ContractBillingDetailDO source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
