package com.elitesland.tw.tw5crm.server.contract.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.cloudt.common.base.BaseModel;
import com.elitesland.workflow.enums.ProcInstStatus;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.*;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * 合同收款计划
 *
 * @author duwh
 * @date 2023-04-24
 */
@Entity
@Table(name = "crm_contract_collection_plan", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "crm_contract_collection_plan", comment = "合同收款计划")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class ContractCollectionPlanDO extends BaseModel implements Serializable  {
    /** 收款阶段 */
    @Comment("收款阶段")
    @Column()
    private String phase;
    /** 收款编号 */
    @Comment("收款编号")
    @Column()
    private String planCode;
    /** 收款状态 udc[CRM:CONTRACT:COLLECTION_PLAN_STATUS] 新建、激活 */
    @Comment("收款状态 udc[CRM:CONTRACT:COLLECTION_STATUS]未收款、部分收款、已完成")
    @Column()
    private String status;
    /** 收款计划状态 udc[CRM:CONTRACT:COLLECTION_STATUS]未收款、部分收款、已完成 */
    @Comment("收款计划状态 udc[CRM:CONTRACT:COLLECTION_PLAN_STATUS]新建、激活")
    @Column()
    private String planStatus;
    /** 当期收款金额 */
    @Comment("当期收款金额")
    @Column()
    private BigDecimal collectionAmount;
    /** 当期收款比例 */
    @Comment("当期收款比例")
    @Column()
    private BigDecimal collectionRatio;
    /** 预计收款日期 */
    @Comment("预计收款日期")
    @Column()
    private LocalDate expectRecvDate;
    /** 合同主键 */
    @Comment("合同主键")
    @Column()
    private Long contractId;
    /** 附件 */
    @Comment("附件")
    @Column()
    private String fileCodes;
    /** 流程实例ID */
    @Comment("流程实例ID")
    @Column()
    private String procInstId;
    @Column
    @Comment("流程实例状态")
    @Enumerated(EnumType.STRING)
    private ProcInstStatus procInstStatus;
    /** 提交时间 */
    @Comment("提交时间")
    @Column()
    private LocalDateTime submitTime;
    /** 审批时间 */
    @Comment("审批时间")
    @Column()
    private LocalDateTime approvedTime;
    /** 版本 */
    @Comment("版本")
    @Column()
    private String version;
    /** 排序号 */
    @Comment("排序号")
    @Column()
    private Integer sortNo;
    /** 拓展字段1 */
    @Comment("拓展字段1")
    @Column()
    private String ext1;
    /** 拓展字段2 */
    @Comment("拓展字段2")
    @Column()
    private String ext2;
    /** 拓展字段3 */
    @Comment("拓展字段3")
    @Column()
    private String ext3;
    /** 拓展字段4 */
    @Comment("拓展字段4")
    @Column()
    private String ext4;
    /** 拓展字段5 */
    @Comment("拓展字段5")
    @Column()
    private String ext5;

    public void copy(ContractCollectionPlanDO source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
