package com.elitesland.tw.tw5crm.server.contract.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.cloudt.common.base.BaseModel;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import lombok.Getter;
import lombok.Setter;
import java.io.Serializable;
import org.hibernate.annotations.Where;

import javax.persistence.*;
import javax.validation.constraints.*;

/**
 * 相对方信息
 *
 * @author zach.zhang
 * @date 2023-04-23
 */
@Entity
@Table(name = "crm_contract_counterside", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "crm_contract_counterside", comment = "相对方信息表")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class ContractCountersideDO extends BaseModel implements Serializable  {
    /** 相对方名称 */
    @Comment("相对方名称")
    @Column()
    private String countersideName;
    /** 相对方主体类型 */
    @Comment("相对方主体类型")
    @Column()
    private String countersideType;
    /** 联系人 */
    @Comment("联系人")
    @Column()
    private String contactPerson;
    /** 联系人电话 */
    @Comment("联系人电话")
    @Column()
    private String phone;
    /** 合同id */
    @Comment("合同id")
    @Column()
    private Long contractId;
    /** 拓展字段1 */
    @Comment("拓展字段1")
    @Column()
    private String ext1;
    /** 拓展字段2 */
    @Comment("拓展字段2")
    @Column()
    private String ext2;
    /** 拓展字段3 */
    @Comment("拓展字段3")
    @Column()
    private String ext3;
    /** 拓展字段4 */
    @Comment("拓展字段4")
    @Column()
    private String ext4;
    /** 拓展字段5 */
    @Comment("拓展字段5")
    @Column()
    private String ext5;

    public void copy(ContractCountersideDO source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
