package com.elitesland.tw.tw5crm.server.contract.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.cloudt.common.base.BaseModel;
import com.elitesland.workflow.enums.ProcInstStatus;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.*;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * 合同管理
 *
 * @author kola
 * @date 2023-04-24
 */
@Entity
@Table(name = "crm_contract", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "crm_contract", comment = "合同管理")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class ContractDO extends BaseModel implements Serializable  {
    /** 主合同ID crm_contract.id */
    @Comment("主合同ID crm_contract.id")
    @Column()
    private Long parentId;
    /** 合同编码 */
    @Comment("合同编码")
    @Column()
    private String contractCode;
    /** 合同名称 */
    @Comment("合同名称")
    @Column()
    private String contractName;
    /** 合同类型udc[CRM:CONTRACT:TYPE](销售合同、采购合同、框架协议) */
    @Comment("合同类型udc[CRM:CONTRACT:TYPE](销售合同、采购合同、框架协议)")
    @Column()
    private String contractType;
    /** 我方签约主体主键 */
    @Comment("我方签约主体主键")
    @Column()
    private Long signCompanyId;
    /** 我方签约主体名称(冗余) */
    @Comment("我方签约主体名称(冗余)")
    @Column()
    private String signCompanyName;
    /** 我方主体类型udc[CRM:COMPANY:TYPE](甲方、乙方、丙方、丁方) */
    @Comment("我方主体类型udc[CRM:COMPANY:TYPE](甲方、乙方、丙方、丁方)")
    @Column()
    private String signCompanyType;
    /** 客户主键 */
    @Comment("客户主键")
    @Column()
    private Long customerId;
    /** 客户名称(冗余) */
    @Comment("客户名称(冗余)")
    @Column()
    private String customerName;
    /** 供应商主键 */
    @Comment("供应商主键")
    @Column()
    private Long suppliersId;
    /** 供应商名称(冗余) */
    @Comment("供应商名称(冗余)")
    @Column()
    private String suppliersName;
    /** 币种 */
    @Comment("币种")
    @Column()
    private String currency;
    /** 合同金额 */
    @Comment("合同金额")
    @Column()
    private BigDecimal contractAmount;
    /** 合同状态udc[CRM:CONTRACT:STATUS](新建、被驳回、审批中、激活、暂挂、待补充合同、待归档、已归档) */
    @Comment("合同状态udc[CRM:CONTRACT:STATUS](新建、被驳回、审批中、激活、暂挂、待补充合同、待归档、已归档)")
    @Column()
    private String contractStatus;
    /** 签订日期 */
    @Comment("签订日期")
    @Column()
    private LocalDate signDate;
    /** 生效日期 */
    @Comment("生效日期")
    @Column()
    private LocalDate effectiveDate;
    /** 失效日期 */
    @Comment("失效日期")
    @Column()
    private LocalDate expiryDate;
    /** 销售负责人udc */
    @Comment("销售负责人")
    @Column()
    private Long saleDutyId;
    /** 采购负责人udc */
    @Comment("采购负责人")
    @Column()
    private Long purchaseDutyId;
    /** 交付负责人udc */
    @Comment("交付负责人")
    @Column()
    private Long payDutyId;
    /** 关联商机主键 */
    @Comment("关联商机主键")
    @Column()
    private Long relateBusinessId;
    /** 关联商机名称(冗余) */
    @Comment("关联商机名称(冗余)")
    @Column()
    private String relateBusinessName;
    /** 关联合同主键 */
    @Comment("关联合同主键")
    @Column()
    private Long relateContractId;
    /** 关联合同名称(冗余) */
    @Comment("关联合同名称(冗余)")
    @Column()
    private String relateContractName;
    /** 合同分类主键（预留后期用） */
    @Comment("合同分类主键（预留后期用）")
    @Column()
    private Long categoryId;
    /** 合同分类 udc[CRM:CONTRACT:CATEGORY] */
    @Comment("模版分类 udc[CRM:CONTRACT:CATEGORY]")
    @Column(
        name = "category",
        columnDefinition = "varchar(4000) comment '模版分类 udc[CRM:CONTRACT:CATEGORY] udcValue1,udcValue2,udcValue3' "
    )
    private String category;
    /** 合同分类 udc[CRM:CONTRACT:TEMPLATE:CATEGORY] */
    @ApiModelProperty("模版分类 udc[CRM:CONTRACT:TEMPLATE:CATEGORY] 具体选的哪个值")
    private String categoryValue;
    /** 合同分类(冗余级联) udcName1/udcName2/udcName3 */
    @Comment("合同分类(冗余级联) udcName1/udcName2/udcName3")
    @Column(
        name = "category_desc",
        columnDefinition = "varchar(4000) comment '模版分类 udc[CRM:CONTRACT:CATEGORY] udcName1/udcName2/udcName3' "
    )
    private String categoryDesc;
    /** 财务期间主键（预留后期用） */
    @Comment("财务期间主键（预留后期用）")
    @Column()
    private Long fiscalPeriodId;
    /** 财务期间(年+月的级联) */
    @Comment("财务期间(年+月的级联)")
    @Column()
    private String fiscalPeriod;
    /** 签单部门主键 */
    @Comment("签单部门主键")
    @Column()
    private Long signOrgId;
    /** 签单部门名称(冗余) */
    @Comment("签单部门名称(冗余)")
    @Column()
    private String signOrgName;
    /** 采购部门主键 */
    @Comment("采购部门主键")
    @Column()
    private Long purchaseOrgId;
    /** 采购部门名称(冗余) */
    @Comment("采购部门名称(冗余)")
    @Column()
    private String purchaseOrgName;
    /** 交付部门主键 */
    @Comment("交付部门主键")
    @Column()
    private Long payOrgId;
    /** 交付部门名称(冗余) */
    @Comment("交付部门名称(冗余)")
    @Column()
    private String payOrgName;
    /** 合同附件1- 归档附件 */
    @Comment("合同附件1 - 归档附件")
    @Column()
    private String contractFile1;
    /** 合同附件2 - 非标合同附件 */
    @Comment("合同附件2 - 非标合同附件")
    @Column()
    private String contractFile2;
    /** 合同附件3 */
    @Comment("合同附件3 - 易稻壳在线编辑附件")
    @Column()
    private String contractFile3;
    /** 合同附件4 */
    @Comment("合同附件4")
    @Column()
    private String contractFile4;
    /** 合同附件5 */
    @Comment("合同附件5")
    @Column()
    private String contractFile5;
    /** 流程实例ID */
    @Comment("流程实例ID")
    @Column()
    private String procInstId;
    /** 流程审批状态 */
    @Comment("流程审批状态")
    @Column()
    @Enumerated(EnumType.STRING)
    private ProcInstStatus procInstStatus;
    /** 提交时间 */
    @Comment("提交时间")
    @Column()
    private LocalDateTime submitTime;
    /** 审批时间 */
    @Comment("审批时间")
    @Column()
    private LocalDateTime approvedTime;
    /** 版本 */
    @Comment("版本")
    @Column()
    private String version;
    /** 排序号 */
    @Comment("排序号")
    @Column()
    private Integer sortNo;
    /** 税率 */
    @Comment("税率")
    @Column()
    private BigDecimal taxRate;
    /** 有效合同金额 */
    @Comment("有效合同金额")
    @Column()
    private BigDecimal effectiveAmt;
    /** 拓展字段1 */
    @Comment("拓展字段1")
    @Column()
    private String ext1;
    /** 拓展字段2 */
    @Comment("拓展字段2")
    @Column()
    private String ext2;
    /** 拓展字段3 */
    @Comment("拓展字段3")
    @Column()
    private String ext3;
    /** 拓展字段4 */
    @Comment("拓展字段4")
    @Column()
    private String ext4;
    /** 拓展字段5 */
    @Comment("拓展字段5")
    @Column()
    private String ext5;
    /** 拓展字段6 */
    @Comment("拓展字段6")
    @Column()
    private String ext6;
    /** 拓展字段7 */
    @Comment("拓展字段7")
    @Column()
    private String ext7;
    /** 拓展字段8 */
    @Comment("拓展字段8")
    @Column()
    private String ext8;
    /** 拓展字段9 */
    @Comment("拓展字段9")
    @Column()
    private String ext9;
    /** 拓展字段10 */
    @Comment("拓展字段10")
    @Column()
    private String ext10;
    /** 主or从合同类型udc[CRM:CONTRACT:MAINTYPE](主合同、从合同)*/
    @Comment("主or从合同类型udc[CRM:CONTRACT:MAINTYPE](主合同、从合同)")
    @Column()
    private String mainType;

    public void copy(ContractDO source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
