package com.elitesland.tw.tw5crm.server.contract.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.cloudt.common.base.BaseModel;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * 合同管理-发票详情
 *
 * @author wangly
 * @date 2023-04-25
 */
@Entity
@Table(name = "crm_contract_invoice", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "crm_contract_invoice", comment = "发票详情表")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class ContractInvoiceDO extends BaseModel implements Serializable  {
    /** 开票申请表id */
    @Comment("开票申请表id")
    @Column()
    private Long billingId;
    /** 开票申请表流水号 */
    @Comment("开票申请表流水号")
    @Column()
    private String billingCode;
    /** 发票类型 udc[CRM:CONTRACT:INVOICE_TYPE] */
    @Comment("发票类型 udc[CRM:CONTRACT:INVOICE_TYPE]")
    @Column()
    private String invoiceType;
    /** 开票主体 */
    @Comment("开票主体")
    @Column()
    private String billingMainbody;
    /** 归属人ID */
    @Comment("归属人ID")
    @Column()
    private Long belongUserId;
    /** 发票状态 udc[CRM:CONTRACT:INVOICE_STATUS] */
    @Comment("发票状态 udc[CRM:CONTRACT:INVOICE_STATUS]")
    @Column()
    private String invoiceStatus;
    /** 发票来源 */
    @Comment("发票来源")
    @Column()
    private String invoiceSource;
    /** 币种 udc[SYSTEM_BASIC:CURRENCY] */
    @Comment("币种 udc[SYSTEM_BASIC:CURRENCY]")
    @Column()
    private String currCode;
    /** 发票抬头名称(购买方名称) */
    @Comment("发票抬头名称(购买方名称)")
    @Column()
    private String invoiceTitle;
    /** 发票代码 */
    @Comment("发票代码")
    @Column()
    private String invoiceCode;
    /** 发票号码 */
    @Comment("发票号码")
    @Column()
    private String invoiceTaxNum;
    /** 发票税号(购买方纳税人识别号) */
    @Comment("发票税号(购买方纳税人识别号)")
    @Column()
    private String invoiceTaxNo;
    /** 开户银行 */
    @Comment("开户银行")
    @Column()
    private String accountBank;
    /** 银行账户 */
    @Comment("银行账户")
    @Column()
    private String account;
    /** 发票金额(含税) */
    @Comment("发票金额(含税)")
    @Column()
    private BigDecimal invoiceTotalAmount;
    /** 发票金额(不含税) */
    @Comment("发票金额(不含税)")
    @Column()
    private BigDecimal invoiceAmount;
    /** 发票税率 udc[CRM:CONTRACT:TAX_RATE] */
    @Comment("发票税率 udc[CRM:CONTRACT:TAX_RATE]")
    @Column()
    private BigDecimal taxRate;
    /** 发票税额 */
    @Comment("发票税额")
    @Column()
    private BigDecimal invoiceTax;
    /** 开票日期 */
    @Comment("开票日期")
    @Column()
    private LocalDate invoiceDate;
    /** 注册地址 */
    @Comment("注册地址")
    @Column()
    private String registerAddress;
    /** 注册电话 */
    @Comment("注册电话")
    @Column()
    private String registerPhone;
    /** 更新时间 */
    @Comment("更新时间")
    @Column()
    private LocalDateTime updateTime;
    /** 附件1 */
    @Comment("附件1")
    @Column()
    private String fileCodes1;
    /** 附件2 */
    @Comment("附件2")
    @Column()
    private String fileCodes2;
    /** 附件3 */
    @Comment("附件3")
    @Column()
    private String fileCodes3;
    /** 附件4 */
    @Comment("附件4")
    @Column()
    private String fileCodes4;
    /** 附件5 */
    @Comment("附件5")
    @Column()
    private String fileCodes5;
    /** 版本 */
    @Comment("版本")
    @Column()
    private String version;
    /** 排序号 */
    @Comment("排序号")
    @Column()
    private Integer sortNo;
    /** 拓展字段1 */
    @Comment("拓展字段1")
    @Column()
    private String ext1;
    /** 拓展字段2 */
    @Comment("拓展字段2")
    @Column()
    private String ext2;
    /** 拓展字段3 */
    @Comment("拓展字段3")
    @Column()
    private String ext3;
    /** 拓展字段4 */
    @Comment("拓展字段4")
    @Column()
    private String ext4;
    /** 拓展字段5 */
    @Comment("拓展字段5")
    @Column()
    private String ext5;
    /** 拓展字段6 */
    @Comment("拓展字段6")
    @Column()
    private String ext6;
    /** 拓展字段7 */
    @Comment("拓展字段7")
    @Column()
    private String ext7;
    /** 拓展字段8 */
    @Comment("拓展字段8")
    @Column()
    private String ext8;
    /** 拓展字段9 */
    @Comment("拓展字段9")
    @Column()
    private String ext9;

    public void copy(ContractInvoiceDO source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
