package com.elitesland.tw.tw5crm.server.contract.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.cloudt.common.base.BaseModel;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 合同产品信息关系表
 *
 * @author duwh
 * @date 2023-04-25
 */
@Entity
@Table(name = "crm_contract_product_ref", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "crm_contract_product_ref", comment = "合同产品信息关系表")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class ContractProductRefDO extends BaseModel implements Serializable  {
    /** 合同主键 */
    @Comment("合同主键")
    @Column()
    private Long contractId;
    /** crm_product_price.id 价目表主键 */
    @Comment("crm_product_price.id 价目表主键")
    @Column()
    private Long priceId;
    /** 商品sku主键 */
    @Comment("商品sku主键")
    @Column()
    private Long skuId;
    /** 产品SKU名称 */
    @Comment("产品SKU名称")
    @Column()
    private String skuName;
    /** 产品SKU编码 */
    @Comment("产品SKU编码")
    @Column()
    private String skuCode;
    /** 产品类型 udc[crm:product:spu_type] */
    @Comment("产品类型 udc[crm:product:spu_type]")
    @Column()
    private String spuType;
    /** 销售单位 udc[crm:product:sku_sale_unit] */
    @Comment("销售单位 udc[crm:product:sku_sale_unit]")
    @Column()
    private String saleUnit;
    /** 税率 产品类型udc拓展字段1中维护 */
    @Comment("税率 产品类型udc拓展字段1中维护")
    @Column()
    private String taxRate;
    /** 数量 */
    @Comment("数量")
    @Column()
    private Integer quantity;
    /** 价目表价格 */
    @Comment("价目表价格")
    @Column()
    private BigDecimal pricePrice;
    /** 规格属性 */
    @Comment("规格属性")
    @Column()
    private String attributeStr;
    /** 排序号 */
    @Comment("排序号")
    @Column()
    private Integer sortNo;
    /** 拓展字段1 */
    @Comment("拓展字段1")
    @Column()
    private String ext1;
    /** 拓展字段2 */
    @Comment("拓展字段2")
    @Column()
    private String ext2;
    /** 拓展字段3 */
    @Comment("拓展字段3")
    @Column()
    private String ext3;
    /** 拓展字段4 */
    @Comment("拓展字段4")
    @Column()
    private String ext4;
    /** 拓展字段5 */
    @Comment("拓展字段5")
    @Column()
    private String ext5;

    public void copy(ContractProductRefDO source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
