package com.elitesland.tw.tw5crm.server.contract.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.cloudt.common.base.BaseModel;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 到款明细
 *
 * @author zach.zhang
 * @date 2023-04-25
 */
@Entity
@Table(name = "crm_contract_receive_details", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "crm_contract_receive_details", comment = "到款明细")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class ContractReceiveDetailsDO extends BaseModel implements Serializable  {

    /** 主表主键 */
    @Comment("主表主键 crm_contract_receive_account.id")
    @Column()
    private Long receiveAccountId;
    /** 合同id */
    @Comment("合同id")
    @Column()
    private Long contractId;
    /** 合同名称 */
    @Comment("合同名称")
    @Column()
    private String contractName;
    /** 收款计划id */
    @Comment("收款计划id")
    @Column()
    private Long planId;
    /** 收款阶段 */
    @Comment("收款阶段")
    @Column()
    private String phase;
    /** 客户id */
    @Comment("客户id")
    @Column()
    private Long customerId;
    /** 客户名称 */
    @Comment("客户名称")
    @Column()
    private String customerName;
    /** 销售负责人id */
    @Comment("销售负责人id")
    @Column()
    private Long saleDutyId;
    /** 到款金额 */
    @Comment("到款金额")
    @Column()
    private BigDecimal receiveMoney;
    /** 销售负责人名称 */
    @Comment("销售负责人名称")
    @Column()
    private String saleDutyName;

    public void copy(ContractReceiveDetailsDO source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
