package com.elitesland.tw.tw5crm.server.contract.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.cloudt.common.base.BaseModel;
import lombok.Getter;
import lombok.Setter;
import java.io.Serializable;
import org.hibernate.annotations.Where;

import javax.persistence.*;
import javax.validation.constraints.*;
import java.time.LocalDate;
import java.math.BigDecimal;

/**
 * 合同签订
 *
 * @author zach.zhang
 * @date 2023-04-26
 */
@Entity
@Table(name = "crm_contract_sign", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "crm_contract_sign", comment = "合同签订")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class ContractSignDO extends BaseModel implements Serializable  {
    /** 合同id */
    @Comment("合同id")
    @Column()
    private Long contractId;
    /** 合同名称 */
    @Comment("合同名称")
    @Column()
    private String contractName;
    /** 客户id */
    @Comment("客户id")
    @Column()
    private Long customerId;
    /** 客户名称 */
    @Comment("客户名称")
    @Column()
    private String customerName;
    /** 我方签约主体id */
    @Comment("我方签约主体id")
    @Column()
    private Long signcompanyId;
    /** 我方签约主体名称 */
    @Comment("我方签约主体名称")
    @Column()
    private String signcompanyName;
    /** 币种 */
    @Comment("币种")
    @Column()
    private String currency;
    /** 合同金额 */
    @Comment("合同金额")
    @Column()
    private BigDecimal contractAmount;
    /** 签订方式udc[CRM:SIGN:TYPE](面签、物流签、第三方电子签) */
    @Comment("签订方式udc[CRM:SIGN:TYPE](面签、物流签、第三方电子签)")
    @Column()
    private String signType;
    /** 签订时间 */
    @Comment("签订时间")
    @Column()
    private LocalDate signDate;
    /** 物流公司 */
    @Comment(" 物流公司udc[CRM:LOGISTICS:COMPANY](顺丰，申通，圆通，EMS）")
    @Column()
    private String logisticsCompany;
    /** 物流单号 */
    @Comment("物流单号")
    @Column()
    private Long logisticsNumber;
    /** 单据号 */
    @Comment("单据号")
    @Column()
    private String filecodes;

    public void copy(ContractSignDO source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
