package com.elitesland.tw.tw5crm.server.contract.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.cloudt.common.base.BaseModel;
import com.elitesland.workflow.enums.ProcInstStatus;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.*;
import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * 合同模版
 *
 * @author duwh
 * @date 2023-04-20
 */
@Entity
@Table(name = "crm_contract_template", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "crm_contract_template", comment = "合同模版")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class ContractTemplateDO extends BaseModel implements Serializable  {
    /** 模版名称 */
    @Comment("模版名称")
    @Column()
    private String name;
    /** 模版编号 */
    @Comment("模版编号")
    @Column()
    private String code;
    /** 模版类型 udc[CRM:CONTRACT:TEMPLATE:TYPE] */
    @Comment("模版类型 udc[CRM:CONTRACT:TEMPLATE:TYPE]")
    @Column()
    private String type;
    /** 状态 udc[CRM:CONTRACT:TEMPLATE:STATUS] */
    @Comment("状态 udc[CRM:CONTRACT:TEMPLATE:STATUS]")
    @Column()
    private String status;
    /** 分类主键（预留后期用） */
    @Comment("分类主键（预留后期用）")
    @Column()
    private Long categoryId;
    /** 版本 */
    @Comment("版本")
    @Column()
    private String version;
    /** 试用部门主键集合，英文逗号隔开；全部 ALL */
    @Comment("试用部门主键集合，英文逗号隔开；全部 ALL")
    @Column(
        name = "org_id_list",
        columnDefinition = "varchar(4000) comment '试用部门主键集合，英文逗号隔开；全部 ALL' "
    )
    private String orgIdList;
    /** 试用部门名称（冗余） */
    @Comment("试用部门名称（冗余）")
    @Column(
        name = "org_name_list",
        columnDefinition = "varchar(4000) comment '试用部门名称（冗余）' "
    )
    private String orgNameList;

    /** 附件 */
    @Comment("附件")
    @Column()
    private String fileCodes;
    /** 附件 */
    @Comment("易稻壳附件")
    @Column()
    private String yeedocFileCodes;
    /** 排序号 */
    @Comment("排序号")
    @Column()
    private Integer sortNo;
    /** 拓展字段1 */
    @Comment("拓展字段1")
    @Column()
    private String ext1;
    /** 拓展字段2 */
    @Comment("拓展字段2")
    @Column()
    private String ext2;
    /** 拓展字段3 */
    @Comment("拓展字段3")
    @Column()
    private String ext3;
    /** 拓展字段4 */
    @Comment("拓展字段4")
    @Column()
    private String ext4;
    /** 拓展字段5 */
    @Comment("拓展字段5")
    @Column()
    private String ext5;
    /** 模版分类 udc[CRM:CONTRACT:TEMPLATE:CATEGORY] */
    @Comment("模版分类 udc[CRM:CONTRACT:TEMPLATE:CATEGORY]")
    @Column(
        name = "category",
        columnDefinition = "varchar(4000) comment '模版分类 udc[CRM:CONTRACT:TEMPLATE:CATEGORY] udcValue1,udcValue2,udcValue3' "
    )
    private String category;
    /** 模版分类 udc[CRM:CONTRACT:TEMPLATE:CATEGORY] */
    @ApiModelProperty("模版分类 udc[CRM:CONTRACT:TEMPLATE:CATEGORY] 具体选的哪个值")
    private String categoryValue;
    @Comment("模版分类(冗余级联) udcName1/udcName2/udcName3")
    @Column(
        name = "category_desc",
        columnDefinition = "varchar(4000) comment '模版分类(冗余级联) udcName1/udcName2/udcName3' "
    )
    private String categoryDesc;

    /** 流程实例ID */
    @Comment("流程实例ID")
    @Column()
    private String procInstId;
    @Column
    @Comment("流程实例状态")
    @Enumerated(EnumType.STRING)
    private ProcInstStatus procInstStatus;
    /** 提交时间 */
    @Comment("提交时间")
    @Column()
    private LocalDateTime submitTime;
    /** 审批时间 */
    @Comment("审批时间")
    @Column()
    private LocalDateTime approvedTime;

    /** 变更主键 */
    @Comment("变更主键 com_business_change.id")
    @Column()
    private Long changeId;

    /** 变更流程实例ID */
    @Comment("变更流程实例ID")
    @Column()
    private String changeProcInstId;
    @Column
    @Comment("变更流程实例状态")
    @Enumerated(EnumType.STRING)
    private ProcInstStatus changeProcInstStatus;
    /** 变更流程提交时间 */
    @Comment("变更流程提交时间")
    @Column()
    private LocalDateTime changeSubmitTime;
    /** 变更流程审批时间 */
    @Comment("变更流程审批时间")
    @Column()
    private LocalDateTime changeApprovedTime;

    public void copy(ContractTemplateDO source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
