package com.elitesland.tw.tw5crm.server.contract.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.cloudt.common.base.BaseModel;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;

/**
 * 合同模版试用部门关系表
 *
 * @author duwh
 * @date 2023-04-20
 */
@Entity
@Table(name = "crm_contract_template_org_ref", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "crm_contract_template_org_ref", comment = "合同模版试用部门关系表")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class ContractTemplateOrgRefDO extends BaseModel implements Serializable  {
    /** 部门名称（冗余） */
    @Comment("部门名称（冗余）")
    @Column()
    private String name;
    /** 模版ID crm_contract_template.id */
    @Comment("模版ID crm_contract_template.id")
    @Column()
    private Long tempId;
    /** 组织BuID prd_org_organization.id */
    @Comment("组织BuID prd_org_organization.id")
    @Column()
    private Long orgId;

    public void copy(ContractTemplateOrgRefDO source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
