package com.elitesland.tw.tw5crm.server.contract.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.cloudt.common.base.BaseModel;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;

/**
 * 取款录入
 *
 * @author zach.zhang
 * @date 2023-04-19
 */
@Entity
@Table(name = "crm_contract_receive_account", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "crm_contract_receive_account", comment = "到款录入表")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class CrmContractReceiveAccountDO extends BaseModel implements Serializable  {
    /** 流水号 */
    @Comment("流水号")
    @Column()
    private String receiveAccountNo;
    /** 到款金额 */
    @Comment("到款金额")
    @Column()
    private BigDecimal receiveAccount;
    /** 到款日期 */
    @Comment("到款日期")
    @Column()
    private LocalDate receiveDate;
    /** 开户名称 */
    @Comment("开户名称")
    @Column()
    private String accountName;
    /** 开户银行 */
    @Comment("开户银行")
    @Column()
    private String accountBank;
    /** 银行账户 */
    @Comment("银行账户")
    @Column()
    private String account;
    /** 税号 */
    @Comment("税号")
    @Column()
    private String taxNo;
    /** 注册地址 */
    @Comment("注册地址")
    @Column()
    private String registerAddress;
    /** 注册电话 */
    @Comment("注册电话")
    @Column()
    private String registerPhone;
    /** 附件 */
    @Comment("附件")
    @Column()
    private String fileCodes;

    /** 拓展字段1 */
    @Comment("拓展字段1")
    @Column()
    private String ext1;
    /** 拓展字段2 */
    @Comment("拓展字段2")
    @Column()
    private String ext2;
    /** 拓展字段3 */
    @Comment("拓展字段3")
    @Column()
    private String ext3;
    /** 拓展字段4 */
    @Comment("拓展字段4")
    @Column()
    private String ext4;
    /** 拓展字段5 */
    @Comment("拓展字段5")
    @Column()
    private String ext5;


    public void copy(CrmContractReceiveAccountDO source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
