package com.elitesland.tw.tw5crm.server.contract.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.common.BaseServiceImpl;
import com.elitesland.tw.tw5crm.api.contract.payload.ContractBillingDetailPayload;
import com.elitesland.tw.tw5crm.api.contract.query.ContractBillingDetailQuery;
import com.elitesland.tw.tw5crm.api.contract.query.ContractInvoiceBillingDetailQuery;
import com.elitesland.tw.tw5crm.api.contract.service.ContractBillingDetailService;
import com.elitesland.tw.tw5crm.api.contract.vo.ContractBillingDetailVO;
import com.elitesland.tw.tw5crm.server.contract.convert.ContractBillingDetailConvert;
import com.elitesland.tw.tw5crm.server.contract.dao.ContractBillingDetailDAO;
import com.elitesland.tw.tw5crm.server.contract.entity.ContractBillingDetailDO;
import com.elitesland.tw.tw5crm.server.contract.repo.ContractBillingDetailRepo;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import java.math.BigDecimal;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

/**
 * 合同管理-开票明细
 *
 * @author wangly
 * @date 2023-04-25
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class ContractBillingDetailServiceImpl extends BaseServiceImpl implements ContractBillingDetailService {

    private final ContractBillingDetailRepo contractBillingDetailRepo;
    private final ContractBillingDetailDAO contractBillingDetailDAO;

    @Override
    public PagingVO<ContractBillingDetailVO> queryPaging(ContractBillingDetailQuery query){
        return contractBillingDetailDAO.queryPaging(query);
    }

    @Override
    public List<ContractBillingDetailVO> queryListDynamic(ContractBillingDetailQuery query){
        return contractBillingDetailDAO.queryListDynamic(query);
    }

    @Override
    public ContractBillingDetailVO queryByKey(Long key) {
        ContractBillingDetailDO entity = contractBillingDetailRepo.findById(key).orElseGet(ContractBillingDetailDO::new);
        Assert.notNull(entity.getId(), "不存在");
        ContractBillingDetailVO vo = ContractBillingDetailConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public ContractBillingDetailVO insert(ContractBillingDetailPayload payload) {
        ContractBillingDetailDO entityDo = ContractBillingDetailConvert.INSTANCE.toDo(payload);
        return ContractBillingDetailConvert.INSTANCE.toVo(contractBillingDetailRepo.save(entityDo));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public ContractBillingDetailVO update(ContractBillingDetailPayload payload) {
        ContractBillingDetailDO entity = contractBillingDetailRepo.findById(payload.getId()).orElseGet(ContractBillingDetailDO::new);
        Assert.notNull(entity.getId(), "不存在");
        ContractBillingDetailDO entityDo = ContractBillingDetailConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return ContractBillingDetailConvert.INSTANCE.toVo(contractBillingDetailRepo.save(entity));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            keys.stream().forEach(id -> {
                Optional<ContractBillingDetailDO> optional = contractBillingDetailRepo.findById(id);
                if (!optional.isEmpty()) {
                    ContractBillingDetailDO entity = optional.get();
                    entity.setDeleteFlag(1);
                    contractBillingDetailRepo.save(entity);
                }
             });
        }
    }

    @Override
    public List<ContractBillingDetailVO> queryListByBillingId(Long billingId) {
        return contractBillingDetailDAO.queryListByBillingId(billingId);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public List<ContractBillingDetailVO> saveAll(List<ContractBillingDetailPayload>  contractBillingDetailPayloadList,long billingId,String billingCode) {
        List<ContractBillingDetailDO> contractBillingDetailDOList =
                contractBillingDetailPayloadList.stream().map(contractBillingDetailPayload ->{
                    ContractBillingDetailDO contractBillingDetailDO = ContractBillingDetailConvert.INSTANCE.toDo(contractBillingDetailPayload);
                    contractBillingDetailDO.setBillingId(billingId);
                    contractBillingDetailDO.setBillingCode(billingCode);
                    return  contractBillingDetailDO;
                }).collect(Collectors.toList());
        return ContractBillingDetailConvert.INSTANCE.toVoList(contractBillingDetailRepo.saveAll(contractBillingDetailDOList));
    }

    @Override
    public PagingVO<ContractBillingDetailVO> queryBillingDetailList(ContractInvoiceBillingDetailQuery query) {
        return contractBillingDetailDAO.queryBillingDetailList(query);
    }
    /**
     * 通过收款计划id获取开票中/已开票金额
     *
     * @param planId 收款计划id
     */
    @Override
    public BigDecimal getAmoutByPlanIdAndBillingStatus(Long planId,String billingStatus){
        return contractBillingDetailDAO.getAmoutByPlanIdAndBillingStatus(planId,billingStatus);
    }
}
