package com.elitesland.tw.tw5crm.server.contract.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.common.BaseServiceImpl;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5crm.api.contract.payload.ContractCountersidePayload;
import com.elitesland.tw.tw5crm.api.contract.query.ContractCountersideQuery;
import com.elitesland.tw.tw5crm.api.contract.service.ContractCountersideService;
import com.elitesland.tw.tw5crm.api.contract.vo.ContractCountersideVO;
import com.elitesland.tw.tw5crm.server.contract.convert.ContractCountersideConvert;
import com.elitesland.tw.tw5crm.server.contract.dao.ContractCountersideDAO;
import com.elitesland.tw.tw5crm.server.contract.entity.ContractCountersideDO;
import com.elitesland.tw.tw5crm.server.contract.repo.ContractCountersideRepo;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import java.util.List;
import java.util.Optional;

/**
 * 相对方信息
 *
 * @author zach.zhang
 * @date 2023-04-23
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class ContractCountersideServiceImpl extends BaseServiceImpl implements ContractCountersideService {

    private final ContractCountersideRepo contractCountersideRepo;
    private final ContractCountersideDAO contractCountersideDAO;

    @Override
    public PagingVO<ContractCountersideVO> queryPaging(ContractCountersideQuery query){
        // 参数校验
        checkQuery(query);
        return contractCountersideDAO.queryPaging(query);
    }

    private void checkQuery(ContractCountersideQuery query) {
        if (null == query.getContractId()) {
            throw TwException.error("", "contractId不能为空");
        }
    }

    private void checkPayload(ContractCountersidePayload query) {
        if (null == query.getContractId()) {
            throw TwException.error("", "contractId不能为空");
        }
    }

    @Override
    public List<ContractCountersideVO> queryListDynamic(ContractCountersideQuery query){
        // 参数校验
        checkQuery(query);
        return contractCountersideDAO.queryListDynamic(query);
    }

    @Override
    public ContractCountersideVO queryByKey(Long key) {
        ContractCountersideDO entity = contractCountersideRepo.findById(key).orElseGet(ContractCountersideDO::new);
        Assert.notNull(entity.getId(), "不存在");
        ContractCountersideVO vo = ContractCountersideConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public ContractCountersideVO insert(ContractCountersidePayload payload) {
        // 参数校验
        checkPayload(payload);
        ContractCountersideDO entityDo = ContractCountersideConvert.INSTANCE.toDo(payload);
        return ContractCountersideConvert.INSTANCE.toVo(contractCountersideRepo.save(entityDo));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public ContractCountersideVO update(ContractCountersidePayload payload) {
        ContractCountersideDO entity = contractCountersideRepo.findById(payload.getId()).orElseGet(ContractCountersideDO::new);
        Assert.notNull(entity.getId(), "不存在");
        ContractCountersideDO entityDo = ContractCountersideConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return ContractCountersideConvert.INSTANCE.toVo(contractCountersideRepo.save(entity));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            keys.stream().forEach(id -> {
                Optional<ContractCountersideDO> optional = contractCountersideRepo.findById(id);
                if (!optional.isEmpty()) {
                    ContractCountersideDO entity = optional.get();
                    entity.setDeleteFlag(1);
                    contractCountersideRepo.save(entity);
                }
             });
        }
    }

}
