package com.elitesland.tw.tw5crm.server.contract.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.common.BaseServiceImpl;
import com.elitesland.tw.tw5.server.prd.common.FileUtil;
import com.elitesland.tw.tw5.server.udc.UdcUtil;
import com.elitesland.tw.tw5crm.api.contract.payload.ContractBillingApplyPayload;
import com.elitesland.tw.tw5crm.api.contract.payload.ContractInvoicePayload;
import com.elitesland.tw.tw5crm.api.contract.query.ContractInvoiceQuery;
import com.elitesland.tw.tw5crm.api.contract.service.ContractInvoiceService;
import com.elitesland.tw.tw5crm.api.contract.vo.ContractInvoiceVO;
import com.elitesland.tw.tw5crm.server.contract.convert.ContractInvoiceConvert;
import com.elitesland.tw.tw5crm.server.contract.dao.ContractInvoiceDAO;
import com.elitesland.tw.tw5crm.server.contract.entity.ContractInvoiceDO;
import com.elitesland.tw.tw5crm.server.contract.repo.ContractInvoiceRepo;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import java.time.LocalDate;
import java.util.List;
import java.util.Optional;

/**
 * 合同管理-发票详情
 *
 * @author wangly
 * @date 2023-04-25
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class ContractInvoiceServiceImpl extends BaseServiceImpl implements ContractInvoiceService {

    private final ContractInvoiceRepo contractInvoiceRepo;
    private final ContractInvoiceDAO contractInvoiceDAO;
    private final FileUtil fileUtil;
    private final UdcUtil udcUtil;
    @Override
    public PagingVO<ContractInvoiceVO> queryPaging(ContractInvoiceQuery query){
        return contractInvoiceDAO.queryPaging(query);
    }

    @Override
    public List<ContractInvoiceVO> queryListDynamic(ContractInvoiceQuery query){
        return contractInvoiceDAO.queryListDynamic(query);
    }

    @Override
    public ContractInvoiceVO queryByKey(Long key) {
        ContractInvoiceDO entity = contractInvoiceRepo.findById(key).orElseGet(ContractInvoiceDO::new);
        Assert.notNull(entity.getId(), "不存在");
        ContractInvoiceVO vo = ContractInvoiceConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public ContractInvoiceVO insert(ContractInvoicePayload payload) {
        ContractInvoiceDO entityDo = ContractInvoiceConvert.INSTANCE.toDo(payload);
        return ContractInvoiceConvert.INSTANCE.toVo(contractInvoiceRepo.save(entityDo));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public ContractInvoiceVO update(ContractInvoicePayload payload) {
        ContractInvoiceDO entity = contractInvoiceRepo.findById(payload.getId()).orElseGet(ContractInvoiceDO::new);
        Assert.notNull(entity.getId(), "不存在");
        ContractInvoiceDO entityDo = ContractInvoiceConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return ContractInvoiceConvert.INSTANCE.toVo(contractInvoiceRepo.save(entity));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            keys.stream().forEach(id -> {
                Optional<ContractInvoiceDO> optional = contractInvoiceRepo.findById(id);
                if (!optional.isEmpty()) {
                    ContractInvoiceDO entity = optional.get();
                    entity.setDeleteFlag(1);
                    contractInvoiceRepo.save(entity);
                }
             });
        }
    }

    @Override
    public ContractInvoiceVO queryInvoicetByBillingId(Long billingId) {
        ContractInvoiceVO contractInvoiceVO = contractInvoiceDAO.queryInvoicetByBillingId(billingId);
        ContractInvoiceVO contractInvoiceVOTranslate = (ContractInvoiceVO)udcUtil.translate(contractInvoiceVO);
        contractInvoiceVOTranslate.setFileDatas(fileUtil.getFileDatas(contractInvoiceVO.getFileCodes1()));
        return contractInvoiceVOTranslate;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void updateInvoiceEntry(ContractBillingApplyPayload payload) {
        ContractInvoiceVO entity = contractInvoiceDAO.queryByBillingId(payload.getId());
        Assert.notNull(entity.getId(), "不存在");
        entity.setInvoiceTaxNum(payload.getInvoiceTaxNum());
        entity.setInvoiceDate(LocalDate.now());
        //上传的时候映射的是申请表的附件字段 需要放到发票里面
        entity.setFileCodes1(payload.getFileCodes());
        ContractInvoiceDO contractInvoiceDO = ContractInvoiceConvert.INSTANCE.toEntity(entity);
        contractInvoiceRepo.save(contractInvoiceDO);
    }

}
