package com.elitesland.tw.tw5crm.server.contract.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.common.BaseServiceImpl;
import com.elitesland.tw.tw5crm.api.contract.payload.ContractProductRefPayload;
import com.elitesland.tw.tw5crm.api.contract.query.ContractProductRefQuery;
import com.elitesland.tw.tw5crm.api.contract.service.ContractProductRefService;
import com.elitesland.tw.tw5crm.api.contract.vo.ContractProductRefVO;
import com.elitesland.tw.tw5crm.server.contract.convert.ContractProductRefConvert;
import com.elitesland.tw.tw5crm.server.contract.dao.ContractProductRefDAO;
import com.elitesland.tw.tw5crm.server.contract.entity.ContractProductRefDO;
import com.elitesland.tw.tw5crm.server.contract.repo.ContractProductRefRepo;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import java.util.List;
import java.util.Optional;

/**
 * 合同产品信息关系表
 *
 * @author duwh
 * @date 2023-04-25
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class ContractProductRefServiceImpl extends BaseServiceImpl implements ContractProductRefService {

    private final ContractProductRefRepo contractProductRefRepo;
    private final ContractProductRefDAO contractProductRefDAO;

    @Override
    public PagingVO<ContractProductRefVO> queryPaging(ContractProductRefQuery query){
        return contractProductRefDAO.queryPaging(query);
    }

    @Override
    public List<ContractProductRefVO> queryListDynamic(ContractProductRefQuery query){
        return contractProductRefDAO.queryListDynamic(query);
    }

    @Override
    public ContractProductRefVO queryByKey(Long key) {
        ContractProductRefDO entity = contractProductRefRepo.findById(key).orElseGet(ContractProductRefDO::new);
        Assert.notNull(entity.getId(), "不存在");
        ContractProductRefVO vo = ContractProductRefConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public ContractProductRefVO insert(ContractProductRefPayload payload) {
        ContractProductRefDO entityDo = ContractProductRefConvert.INSTANCE.toDo(payload);
        return ContractProductRefConvert.INSTANCE.toVo(contractProductRefRepo.save(entityDo));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public ContractProductRefVO update(ContractProductRefPayload payload) {
        ContractProductRefDO entity = contractProductRefRepo.findById(payload.getId()).orElseGet(ContractProductRefDO::new);
        Assert.notNull(entity.getId(), "不存在");
        ContractProductRefDO entityDo = ContractProductRefConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return ContractProductRefConvert.INSTANCE.toVo(contractProductRefRepo.save(entity));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            keys.stream().forEach(id -> {
                Optional<ContractProductRefDO> optional = contractProductRefRepo.findById(id);
                if (!optional.isEmpty()) {
                    ContractProductRefDO entity = optional.get();
                    entity.setDeleteFlag(1);
                    contractProductRefRepo.save(entity);
                }
             });
        }
    }

}
