package com.elitesland.tw.tw5crm.server.contract.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.common.BaseServiceImpl;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.FileUtil;
import com.elitesland.tw.tw5crm.api.contract.payload.ContractReceiveAccountPayload;
import com.elitesland.tw.tw5crm.api.contract.payload.ContractReceiveDetailsPayload;
import com.elitesland.tw.tw5crm.api.contract.query.ContractReceiveAccountQuery;
import com.elitesland.tw.tw5crm.api.contract.query.ContractReceiveDetailsQuery;
import com.elitesland.tw.tw5crm.api.contract.service.ContractReceiveAccountService;
import com.elitesland.tw.tw5crm.api.contract.vo.ContractAccountNameVO;
import com.elitesland.tw.tw5crm.api.contract.vo.ContractReceiveAccountVO;
import com.elitesland.tw.tw5crm.api.contract.vo.ContractReceiveDetailsVO;
import com.elitesland.tw.tw5crm.server.common.constants.ContractCollectionPlanPlanStatus;
import com.elitesland.tw.tw5crm.server.common.constants.GenerateSeqNumConstants;
import com.elitesland.tw.tw5crm.server.contract.convert.ContractReceiveDetailsConvert;
import com.elitesland.tw.tw5crm.server.contract.convert.CrmContractReceiveAccountConvert;
import com.elitesland.tw.tw5crm.server.contract.dao.ContractReceiveDetailsDAO;
import com.elitesland.tw.tw5crm.server.contract.dao.CrmContractReceiveAccountDAO;
import com.elitesland.tw.tw5crm.server.contract.entity.ContractCollectionPlanDO;
import com.elitesland.tw.tw5crm.server.contract.entity.ContractDO;
import com.elitesland.tw.tw5crm.server.contract.entity.ContractReceiveDetailsDO;
import com.elitesland.tw.tw5crm.server.contract.entity.CrmContractReceiveAccountDO;
import com.elitesland.tw.tw5crm.server.contract.repo.ContractCollectionPlanRepo;
import com.elitesland.tw.tw5crm.server.contract.repo.ContractReceiveDetailsRepo;
import com.elitesland.tw.tw5crm.server.contract.repo.ContractRepo;
import com.elitesland.tw.tw5crm.server.contract.repo.CrmContractReceiveAccountRepo;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

/**
 * 取款录入
 *
 * @author zach.zhang
 * @date 2023-04-19
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class ContractReceiveAccountServiceImpl extends BaseServiceImpl implements ContractReceiveAccountService {
    private final CrmContractReceiveAccountRepo crmContractReceiveAccountRepo;
    private final CrmContractReceiveAccountDAO crmContractReceiveAccountDAO;
    private final ContractReceiveDetailsRepo contractReceiveDetailsRepo;
    private final ContractCollectionPlanRepo collectionPlanRepo;
    private final ContractReceiveDetailsDAO contractReceiveDetailsDAO;
    private final FileUtil fileUtil;
    private final CacheUtil cacheUtil;
    public final ContractRepo contractRepo;

    @Override
    public PagingVO<ContractReceiveAccountVO> queryPaging(ContractReceiveAccountQuery query){
        PagingVO<ContractReceiveAccountVO> PagingVO = crmContractReceiveAccountDAO.queryPaging(query);
        List<ContractReceiveAccountVO> records = PagingVO.getRecords();
//        for (ContractReceiveAccountVO e : records) {
//            ContractReceiveDetailsQuery detailsQuery = new ContractReceiveDetailsQuery();
//            detailsQuery.setReceiveAccountId(e.getId());
//            List<ContractReceiveDetailsVO> contractReceiveDetailsVOS = contractReceiveDetailsDAO.queryListDynamic(detailsQuery);
//            e.setContractReceiveDetailsVO(contractReceiveDetailsVOS);
//        }
        return PagingVO;
    }

    @Override
    public List<ContractReceiveAccountVO> queryListDynamic(ContractReceiveAccountQuery query){
        return crmContractReceiveAccountDAO.queryListDynamic(query);
    }

    @Override
    public ContractReceiveAccountVO queryByKey(Long key) {
        CrmContractReceiveAccountDO entity = crmContractReceiveAccountRepo.findById(key).orElseGet(CrmContractReceiveAccountDO::new);
        Assert.notNull(entity.getId(), "到款收入不存在");
        ContractReceiveAccountVO vo = CrmContractReceiveAccountConvert.INSTANCE.toVo(entity);
        translation(vo);
        ContractReceiveDetailsQuery detailsQuery = new ContractReceiveDetailsQuery();
        detailsQuery.setReceiveAccountId(vo.getId());
        List<ContractReceiveDetailsVO> contractReceiveDetailsVOS = contractReceiveDetailsDAO.queryListDynamic(detailsQuery);
        vo.setContractReceiveDetailsVO(contractReceiveDetailsVOS);
        return vo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public ContractReceiveAccountVO insert(ContractReceiveAccountPayload payload) {
        List<ContractReceiveDetailsPayload> contractReceiveDetailsPayloadList = payload.getContractReceiveDetailsPayload();
        String code = generateSeqNum(GenerateSeqNumConstants.CRM_RECEIVE_ACCOUNT);
        payload.setReceiveAccountNo(code);

        CrmContractReceiveAccountDO entityDo = CrmContractReceiveAccountConvert.INSTANCE.toDo(payload);
        CrmContractReceiveAccountDO save = crmContractReceiveAccountRepo.save(entityDo);

        // 现阶段只有新增、没有编辑
        Map<Long, BigDecimal> collectionAmountMap = new HashMap<>();
        Map<Long, ContractCollectionPlanDO> contractCollectionPlanDOMap = new HashMap<>();
        // 到款明细
        for (ContractReceiveDetailsPayload e : contractReceiveDetailsPayloadList) {
            ContractDO contractDO = contractRepo.findById(e.getContractId()).orElseGet(ContractDO::new);
            e.setContractName(contractDO.getContractName());
            e.setSaleDutyId(contractDO.getSaleDutyId());
            e.setSaleDutyName(cacheUtil.getUserName(contractDO.getSaleDutyId()));
            ContractCollectionPlanDO contractCollectionPlanDO = collectionPlanRepo.findById(e.getPlanId()).orElseGet(ContractCollectionPlanDO::new);
            //通过收款计划id判断收款明细中是否有相同的收款计划
            if(collectionAmountMap.containsKey(contractCollectionPlanDO.getId())){
                //有相同的收款计划 将收款金额相加
                collectionAmountMap.put(contractCollectionPlanDO.getId(),collectionAmountMap.get(contractCollectionPlanDO.getId()).add(e.getReceiveMoney()));
            }else{
                //收款计划或者到款录入金额是空就跳过
                if(contractCollectionPlanDO.getCollectionAmount()!=null&&e.getReceiveMoney()!=null){
                    //先查询之前有没有到款录入的金额
                    BigDecimal totalReceivedMoney = contractReceiveDetailsDAO.queryTotalReceiveMoneyByPlanId(contractCollectionPlanDO.getId());
                    //如果不相同就放入到两个map里面 后面循环判断是否全部收款 将之前到款录入的金额也加进去一起计算
                    collectionAmountMap.put(contractCollectionPlanDO.getId(),e.getReceiveMoney().add(totalReceivedMoney));
                    contractCollectionPlanDOMap.put(contractCollectionPlanDO.getId(),contractCollectionPlanDO);
                }
           }
            String phase = contractCollectionPlanDO.getPhase();
            e.setPhase(phase);

            ContractReceiveDetailsDO contractReceiveDetailsDO = ContractReceiveDetailsConvert.INSTANCE.toDo(e);
            // 主表id
            contractReceiveDetailsDO.setReceiveAccountId(save.getId());
            contractReceiveDetailsRepo.save(contractReceiveDetailsDO);
        }

        //循环map 修改收款计划的状态
        contractCollectionPlanDOMap.forEach((planId,value)->{
            //如果收款金额为0  跳过本次循环
            if(collectionAmountMap.get(planId).compareTo(BigDecimal.ZERO)==0){
                return;
            }
           int count =  value.getCollectionAmount().subtract(collectionAmountMap.get(planId)).compareTo(BigDecimal.ZERO);
           //如果当期收款金额-收款金额小与等于0 则状态改为全部收款
           if(count<=0){
               value.setStatus(ContractCollectionPlanPlanStatus.OK.getCode());
            }else{
               //否则都是部分收款
               value.setStatus(ContractCollectionPlanPlanStatus.PART.getCode());
           }

            collectionPlanRepo.save(value);
        });
        return CrmContractReceiveAccountConvert.INSTANCE.toVo(save);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public ContractReceiveAccountVO update(ContractReceiveAccountPayload payload) {
        CrmContractReceiveAccountDO entity = crmContractReceiveAccountRepo.findById(payload.getId()).orElseGet(CrmContractReceiveAccountDO::new);
        Assert.notNull(entity.getId(), "到款录入不存在");
        CrmContractReceiveAccountDO entityDo = CrmContractReceiveAccountConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return CrmContractReceiveAccountConvert.INSTANCE.toVo(crmContractReceiveAccountRepo.save(entity));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            keys.stream().forEach(id -> {
                Optional<CrmContractReceiveAccountDO> optional = crmContractReceiveAccountRepo.findById(id);
                if (!optional.isEmpty()) {
                    CrmContractReceiveAccountDO entity = optional.get();
                    entity.setDeleteFlag(1);
                    crmContractReceiveAccountRepo.save(entity);
                }
             });
        }
    }
    private void translation(ContractReceiveAccountVO vo) {
        vo.setFileDatas(fileUtil.getFileDatas(vo.getFileCodes()));
    }

    @Override
    public List<ContractAccountNameVO> listSimple() {
        List<ContractAccountNameVO> resultList = crmContractReceiveAccountDAO.listSimple();
        return resultList;
    }

}
