package com.elitesland.tw.tw5crm.server.contract.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.common.BaseServiceImpl;
import com.elitesland.tw.tw5crm.api.contract.payload.ContractReceiveDetailsPayload;
import com.elitesland.tw.tw5crm.api.contract.query.ContractReceiveDetailsQuery;
import com.elitesland.tw.tw5crm.api.contract.service.ContractReceiveDetailsService;
import com.elitesland.tw.tw5crm.api.contract.vo.ContractReceiveDetailsVO;
import com.elitesland.tw.tw5crm.server.contract.convert.ContractReceiveDetailsConvert;
import com.elitesland.tw.tw5crm.server.contract.dao.ContractReceiveDetailsDAO;
import com.elitesland.tw.tw5crm.server.contract.entity.ContractDO;
import com.elitesland.tw.tw5crm.server.contract.entity.ContractReceiveDetailsDO;
import com.elitesland.tw.tw5crm.server.contract.repo.ContractReceiveDetailsRepo;
import com.elitesland.tw.tw5crm.server.contract.repo.ContractRepo;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import java.util.List;
import java.util.Optional;

/**
 * 到款明细
 *
 * @author zach.zhang
 * @date 2023-04-25
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class ContractReceiveDetailsServiceImpl extends BaseServiceImpl implements ContractReceiveDetailsService {

    private final ContractReceiveDetailsRepo contractReceiveDetailsRepo;
    private final ContractReceiveDetailsDAO contractReceiveDetailsDAO;
    private final ContractRepo contractRepo;

    @Override
    public PagingVO<ContractReceiveDetailsVO> queryPaging(ContractReceiveDetailsQuery query) {
        return contractReceiveDetailsDAO.queryPaging(query);
    }

    @Override
    public List<ContractReceiveDetailsVO> queryListDynamic(ContractReceiveDetailsQuery query) {
        return contractReceiveDetailsDAO.queryListDynamic(query);
    }

    @Override
    public ContractReceiveDetailsVO queryByKey(Long key) {
        ContractReceiveDetailsDO entity = contractReceiveDetailsRepo.findById(key).orElseGet(ContractReceiveDetailsDO::new);
        Assert.notNull(entity.getId(), "收款明细不存在");
        ContractReceiveDetailsVO vo = ContractReceiveDetailsConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public ContractReceiveDetailsVO insert(ContractReceiveDetailsPayload payload) {
        ContractDO contractDO = contractRepo.findById(payload.getContractId()).orElseGet(ContractDO::new);
        payload.setCustomerName(contractDO.getCustomerName());
        payload.setSaleDutyId(contractDO.getSaleDutyId());
        ContractReceiveDetailsDO entityDo = ContractReceiveDetailsConvert.INSTANCE.toDo(payload);
        return ContractReceiveDetailsConvert.INSTANCE.toVo(contractReceiveDetailsRepo.save(entityDo));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public ContractReceiveDetailsVO update(ContractReceiveDetailsPayload payload) {
        ContractReceiveDetailsDO entity = contractReceiveDetailsRepo.findById(payload.getId()).orElseGet(ContractReceiveDetailsDO::new);
        Assert.notNull(entity.getId(), "收款明细不存在");
        ContractReceiveDetailsDO entityDo = ContractReceiveDetailsConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return ContractReceiveDetailsConvert.INSTANCE.toVo(contractReceiveDetailsRepo.save(entity));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            keys.stream().forEach(id -> {
                Optional<ContractReceiveDetailsDO> optional = contractReceiveDetailsRepo.findById(id);
                if (!optional.isEmpty()) {
                    ContractReceiveDetailsDO entity = optional.get();
                    entity.setDeleteFlag(1);
                    contractReceiveDetailsRepo.save(entity);
                }
            });
        }
    }


}
