package com.elitesland.tw.tw5crm.server.contract.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.common.BaseServiceImpl;
import com.elitesland.tw.tw5crm.api.contract.payload.ContractTemplateOrgRefPayload;
import com.elitesland.tw.tw5crm.api.contract.query.ContractTemplateOrgRefQuery;
import com.elitesland.tw.tw5crm.api.contract.service.ContractTemplateOrgRefService;
import com.elitesland.tw.tw5crm.api.contract.vo.ContractTemplateOrgRefVO;
import com.elitesland.tw.tw5crm.server.contract.convert.ContractTemplateOrgRefConvert;
import com.elitesland.tw.tw5crm.server.contract.dao.ContractTemplateOrgRefDAO;
import com.elitesland.tw.tw5crm.server.contract.entity.ContractTemplateOrgRefDO;
import com.elitesland.tw.tw5crm.server.contract.repo.ContractTemplateOrgRefRepo;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import java.util.List;
import java.util.Optional;

/**
 * 合同模版试用部门关系表
 *
 * @author duwh
 * @date 2023-04-20
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class ContractTemplateOrgRefServiceImpl extends BaseServiceImpl implements ContractTemplateOrgRefService {

    private final ContractTemplateOrgRefRepo contractTemplateOrgRefRepo;
    private final ContractTemplateOrgRefDAO contractTemplateOrgRefDAO;

    @Override
    public PagingVO<ContractTemplateOrgRefVO> queryPaging(ContractTemplateOrgRefQuery query){
        return contractTemplateOrgRefDAO.queryPaging(query);
    }

    @Override
    public List<ContractTemplateOrgRefVO> queryListDynamic(ContractTemplateOrgRefQuery query){
        return contractTemplateOrgRefDAO.queryListDynamic(query);
    }

    @Override
    public ContractTemplateOrgRefVO queryByKey(Long key) {
        ContractTemplateOrgRefDO entity = contractTemplateOrgRefRepo.findById(key).orElseGet(ContractTemplateOrgRefDO::new);
        Assert.notNull(entity.getId(), "不存在");
        ContractTemplateOrgRefVO vo = ContractTemplateOrgRefConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public ContractTemplateOrgRefVO insert(ContractTemplateOrgRefPayload payload) {
        ContractTemplateOrgRefDO entityDo = ContractTemplateOrgRefConvert.INSTANCE.toDo(payload);
        return ContractTemplateOrgRefConvert.INSTANCE.toVo(contractTemplateOrgRefRepo.save(entityDo));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public ContractTemplateOrgRefVO update(ContractTemplateOrgRefPayload payload) {
        ContractTemplateOrgRefDO entity = contractTemplateOrgRefRepo.findById(payload.getId()).orElseGet(ContractTemplateOrgRefDO::new);
        Assert.notNull(entity.getId(), "不存在");
        ContractTemplateOrgRefDO entityDo = ContractTemplateOrgRefConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return ContractTemplateOrgRefConvert.INSTANCE.toVo(contractTemplateOrgRefRepo.save(entity));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            keys.stream().forEach(id -> {
                Optional<ContractTemplateOrgRefDO> optional = contractTemplateOrgRefRepo.findById(id);
                if (!optional.isEmpty()) {
                    ContractTemplateOrgRefDO entity = optional.get();
                    entity.setDeleteFlag(1);
                    contractTemplateOrgRefRepo.save(entity);
                }
             });
        }
    }

    @Override
    public void deleteByTempId(Long tempId) {
        if(null != tempId){
            contractTemplateOrgRefRepo.deleteByTempId(tempId);
        }
    }

}
