package com.elitesland.tw.tw5crm.server.contract.workflow;

import com.elitesland.tw.tw5.server.prd.common.functionEnum.WorkFlowStatusEnum;
import com.elitesland.tw.tw5crm.api.contract.payload.ContractTemplatePayload;
import com.elitesland.tw.tw5crm.api.contract.vo.ContractTemplateVO;
import com.elitesland.tw.tw5crm.server.contract.dao.ContractTemplateDAO;
import com.elitesland.workflow.WorkflowCallBack;
import com.elitesland.workflow.WorkflowConstant;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.workflow.payload.ProcessStatusChangePayload;
import com.elitesland.workflow.payload.TaskAssigneePayload;
import com.elitesland.workflow.payload.TaskCompletedPayload;
import com.elitesland.workflow.payload.TaskCreatedPayload;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;

/**
 * 合同模版审批流程
 *
 * @author duwh
 * @date 2023/03/27
 */
@Slf4j
@RestController
@RequestMapping(WorkflowConstant.WORKFLOW + "CONTRACT_TEMPLATE" + WorkflowConstant.CALLBACK)
@Transactional
@RequiredArgsConstructor
public class ContractTemplateWorkflowController implements WorkflowCallBack {
    private final ContractTemplateDAO contractTemplateDAO;

    /**
     * 动态指定任务负责人
     */
    @Override
    @PostMapping(WorkflowConstant.TASK_ASSIGNEE_PATH)
    public ArrayList<String> taskAssignee(@RequestBody TaskAssigneePayload payload) {
        log.info("动态指定任务负责人参数: {}", payload);
        return null;
    }

    /**
     * 任务创建回调
     */
    @Override
    @PostMapping(WorkflowConstant.TASK_CREATED_PATH)
    public void taskCreated(@RequestBody TaskCreatedPayload payload) {
        log.info("任务创建后回调参数: {}", payload);
    }

    /**
     * 任务完成回调(只有正常推下一个节点,才算任务完成,其他从当前任务撤回/驳回都能不算当前任务完成,不会触发下面回调)
     */
    @Override
    @PostMapping(WorkflowConstant.TASK_COMPLETED_PATH)
    public void taskCompleted(@RequestBody TaskCompletedPayload payload) {
        log.info("任务完成后回调参数: {}", payload);
    }

    /**
     * 流程状态变化回调
     */
    @Override
    @PostMapping(WorkflowConstant.PROCESS_STATUS_CHANGE_PATH)
    @Transactional()
    public void processStatusChange(@RequestBody ProcessStatusChangePayload payload) {
        log.info("流程状态变化回调参数:{}", payload);
        String businessKey = payload.getBusinessKey();
        ProcInstStatus procInstStatus = payload.getProcInstStatus();
        ContractTemplatePayload updatePayload = new ContractTemplatePayload();
        final long id = Long.parseLong(businessKey);
        updatePayload.setId(id);
        //根据业务key查询当前业务对象
        final ContractTemplateVO vo = contractTemplateDAO.queryByKey(Long.valueOf(businessKey));

        updatePayload.setProcInstId(vo.getProcInstId());
        updatePayload.setSubmitTime(vo.getSubmitTime());
        updatePayload.setApprovedTime(vo.getApprovedTime());
        updatePayload.setProcInstStatus(procInstStatus);
        if (vo != null) {
            boolean deleteFlag = false;
            switch (procInstStatus) {
                case NOTSUBMIT://创建人提交节点
                    //一般情况将单据状态变成"新建",流程状态改为未提交
                    updatePayload.setStatus(WorkFlowStatusEnum.CREATE_WORK.getCode());
                    break;
                case INTERRUPT://中断（删除工作流，初始化单据，管理员操作）
                    //一般情况将单据状态变成"新建",并且将单据上的"流程实例状态"，"流程实例ID"清成null
                    updatePayload.setStatus(WorkFlowStatusEnum.CREATE_WORK.getCode());
                    break;
                case INVALID://作废 先删除流程再删除单据
                    //一般情况将单据状态变成"作废" ，或直接删除单据
                    updatePayload.setStatus(WorkFlowStatusEnum.INVALID.getCode());
                    deleteFlag = true;
                    break;
                case REJECTED://审批人拒绝，回到第一个节点
                    //将单据状态变为新建状态
                    updatePayload.setStatus(WorkFlowStatusEnum.CREATE_WORK.getCode());
                    break;
                case APPROVED:
                    //一般情况将单据状态变成"激活"
                    updatePayload.setStatus(WorkFlowStatusEnum.APPROVED_WORK.getCode());
                    updatePayload.setApprovedTime(LocalDateTime.now());
                    break;
                case APPROVING:
                    updatePayload.setStatus(WorkFlowStatusEnum.APPROVING_WORK.getCode());
                    break;
            }
            contractTemplateDAO.updateWorkFlow(updatePayload);
            if (deleteFlag) {
                contractTemplateDAO.deleteSoft(Arrays.asList(id));
            }
        }
    }

}
